/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.items;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.chaosthedude.naturescompass.gui.GuiWrapper;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import com.chaosthedude.naturescompass.utils.CompassState;
import com.chaosthedude.naturescompass.utils.ItemUtils;
import com.chaosthedude.naturescompass.utils.PlayerUtils;
import com.chaosthedude.naturescompass.workers.BiomeSearchWorker;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public class NaturesCompassItem
extends class_1792 {
    public static final String NAME = "naturescompass";
    public static final class_5321<class_1792> KEY = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"naturescompass", (String)"naturescompass"));
    private BiomeSearchWorker worker;

    public NaturesCompassItem() {
        super(new class_1792.class_1793().method_63686(KEY).method_7889(1));
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715()) {
            if (world.field_9236) {
                class_1799 stack = ItemUtils.getHeldNatureCompass(player);
                GuiWrapper.openGUI(world, player, stack);
            } else {
                class_3218 serverWorld = (class_3218)world;
                class_3222 serverPlayer = (class_3222)player;
                boolean canTeleport = NaturesCompassConfig.allowTeleport && PlayerUtils.canTeleport(player);
                List<class_2960> allowedBiomeIDs = BiomeUtils.getAllowedBiomeIDs(world);
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new SyncPacket(canTeleport, allowedBiomeIDs, BiomeUtils.getGeneratingDimensionsForAllowedBiomes(serverWorld)));
            }
        } else {
            if (this.worker != null) {
                this.worker.stop();
                this.worker = null;
            }
            this.setState(player.method_5998(hand), null, CompassState.INACTIVE, player);
        }
        return class_1269.field_21466;
    }

    public void searchForBiome(class_3218 world, class_1657 player, class_2960 biomeID, class_2338 pos, class_1799 stack) {
        this.setSearching(stack, biomeID, player);
        Optional<class_1959> optionalBiome = BiomeUtils.getBiomeForIdentifier((class_1937)world, biomeID);
        if (optionalBiome.isPresent()) {
            if (this.worker != null) {
                this.worker.stop();
            }
            this.worker = new BiomeSearchWorker(world, player, stack, optionalBiome.get(), pos);
            this.worker.start();
        }
    }

    public void succeed(class_1799 stack, class_1657 player, int x, int z, int samples, boolean displayCoordinates) {
        this.setFound(stack, x, z, samples, player);
        this.setDisplayCoordinates(stack, displayCoordinates);
        this.worker = null;
    }

    public void fail(class_1799 stack, class_1657 player, int searchRadius, int samples) {
        this.setNotFound(stack, player, searchRadius, samples);
        this.worker = null;
    }

    public boolean isActive(class_1799 stack) {
        if (ItemUtils.isCompass(stack)) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(class_1799 stack, class_2960 biomeID, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.BIOME_ID_COMPONENT, (Object)biomeID.toString());
            stack.method_57379(NaturesCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.SEARCHING.getID());
            stack.method_57379(NaturesCompass.SEARCH_RADIUS_COMPONENT, (Object)0);
        }
    }

    public void setFound(class_1799 stack, int x, int z, int samples, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.FOUND.getID());
            stack.method_57379(NaturesCompass.FOUND_X_COMPONENT, (Object)x);
            stack.method_57379(NaturesCompass.FOUND_Z_COMPONENT, (Object)z);
            stack.method_57379(NaturesCompass.SAMPLES_COMPONENT, (Object)samples);
        }
    }

    public void setNotFound(class_1799 stack, class_1657 player, int searchRadius, int samples) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.NOT_FOUND.getID());
            stack.method_57379(NaturesCompass.SEARCH_RADIUS_COMPONENT, (Object)searchRadius);
            stack.method_57379(NaturesCompass.SAMPLES_COMPONENT, (Object)samples);
        }
    }

    public void setInactive(class_1799 stack, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.INACTIVE.getID());
        }
    }

    public void setState(class_1799 stack, class_2338 pos, CompassState state, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.COMPASS_STATE_COMPONENT, (Object)state.getID());
        }
    }

    public void setDisplayCoordinates(class_1799 stack, boolean displayPosition) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.DISPLAY_COORDS_COMPONENT, (Object)displayPosition);
        }
    }

    public void setFoundBiomeX(class_1799 stack, int x, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.FOUND_X_COMPONENT, (Object)x);
        }
    }

    public void setFoundBiomeZ(class_1799 stack, int z, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.FOUND_Z_COMPONENT, (Object)z);
        }
    }

    public void setBiomeID(class_1799 stack, class_2960 biomeID, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.BIOME_ID_COMPONENT, (Object)biomeID.toString());
        }
    }

    public void setSearchRadius(class_1799 stack, int searchRadius, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.SEARCH_RADIUS_COMPONENT, (Object)searchRadius);
        }
    }

    public void setSamples(class_1799 stack, int samples, class_1657 player) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(NaturesCompass.SAMPLES_COMPONENT, (Object)samples);
        }
    }

    public CompassState getState(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.COMPASS_STATE_COMPONENT)) {
            return CompassState.fromID((Integer)stack.method_58694(NaturesCompass.COMPASS_STATE_COMPONENT));
        }
        return null;
    }

    public int getFoundBiomeX(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.FOUND_X_COMPONENT)) {
            return (Integer)stack.method_58694(NaturesCompass.FOUND_X_COMPONENT);
        }
        return 0;
    }

    public int getFoundBiomeZ(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.FOUND_Z_COMPONENT)) {
            return (Integer)stack.method_58694(NaturesCompass.FOUND_Z_COMPONENT);
        }
        return 0;
    }

    public class_2960 getBiomeID(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.BIOME_ID_COMPONENT)) {
            return class_2960.method_60654((String)((String)stack.method_58694(NaturesCompass.BIOME_ID_COMPONENT)));
        }
        return class_2960.method_60655((String)"", (String)"");
    }

    public int getSearchRadius(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.SEARCH_RADIUS_COMPONENT)) {
            return (Integer)stack.method_58694(NaturesCompass.SEARCH_RADIUS_COMPONENT);
        }
        return -1;
    }

    public int getSamples(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.SAMPLES_COMPONENT)) {
            return (Integer)stack.method_58694(NaturesCompass.SAMPLES_COMPONENT);
        }
        return -1;
    }

    public boolean shouldDisplayCoordinates(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(NaturesCompass.DISPLAY_COORDS_COMPONENT)) {
            return (Boolean)stack.method_58694(NaturesCompass.DISPLAY_COORDS_COMPONENT);
        }
        return true;
    }

    public int getDistanceToBiome(class_1657 player, class_1799 stack) {
        return BiomeUtils.getDistanceToBiome(player, this.getFoundBiomeX(stack), this.getFoundBiomeZ(stack));
    }
}

