/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.ClientBlockStateColorCache;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(ClientLevelWrapper.class.getSimpleName());
    private static final Map<ClientLevel, WeakReference<ClientLevelWrapper>> LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    private final ClientLevel level;
    private final ConcurrentHashMap<BlockState, ClientBlockStateColorCache> blockCache = new ConcurrentHashMap();
    private final Function<BlockState, ClientBlockStateColorCache> cachedBlockColorCacheFunction = blockState -> this.createBlockColorCache((BlockState)blockState);
    private BlockStateWrapper dirtBlockWrapper;
    private BiomeWrapper plainsBiomeWrapper;
    @Deprecated
    private IDhLevel parentDhLevel;

    protected ClientLevelWrapper(ClientLevel level) {
        this.level = level;
    }

    public static IClientLevelWrapper getWrapper(@NotNull ClientLevel level) {
        return ClientLevelWrapper.getWrapper(level, false);
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@Nullable ClientLevel level, boolean bypassLevelKeyManager) {
        ClientLevelWrapper levelWrapper;
        WeakReference<ClientLevelWrapper> levelRef;
        if (!bypassLevelKeyManager) {
            if (level == null) {
                return null;
            }
            IServerKeyedClientLevel overrideLevel = KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel();
            if (overrideLevel != null) {
                return overrideLevel;
            }
        }
        if ((levelRef = LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.get(level)) != null && (levelWrapper = (ClientLevelWrapper)levelRef.get()) != null) {
            return levelWrapper;
        }
        return (IClientLevelWrapper)LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.compute(level, (newLevel, newLevelRef) -> {
            ClientLevelWrapper oldLevelWrapper;
            if (newLevelRef != null && (oldLevelWrapper = (ClientLevelWrapper)newLevelRef.get()) != null) {
                return newLevelRef;
            }
            return new WeakReference<ClientLevelWrapper>(new ClientLevelWrapper((ClientLevel)newLevel));
        }).get();
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            Iterable serverLevels = MINECRAFT.getSingleplayerServer().getAllLevels();
            ServerLevelWrapper foundLevelWrapper = null;
            for (ServerLevel serverLevel : serverLevels) {
                if (serverLevel.dimension() != this.level.dimension()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + String.valueOf(this.level));
            return null;
        }
    }

    @Override
    public int getBlockColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper blockWrapper) {
        ClientBlockStateColorCache blockColorCache = this.blockCache.computeIfAbsent(((BlockStateWrapper)blockWrapper).blockState, this.cachedBlockColorCacheFunction);
        return blockColorCache.getColor((BiomeWrapper)biome, pos);
    }

    private ClientBlockStateColorCache createBlockColorCache(BlockState block) {
        return new ClientBlockStateColorCache(block, this);
    }

    @Override
    public int getDirtBlockColor() {
        if (this.dirtBlockWrapper == null) {
            try {
                this.dirtBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:dirt", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get dirt color with resource location [minecraft:dirt] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return -1;
            }
        }
        return this.getBlockColor(DhBlockPos.ZERO, BiomeWrapper.EMPTY_WRAPPER, this.dirtBlockWrapper);
    }

    @Override
    public void clearBlockColorCache() {
        this.blockCache.clear();
    }

    @Override
    public IBiomeWrapper getPlainsBiomeWrapper() {
        if (this.plainsBiomeWrapper == null) {
            try {
                this.plainsBiomeWrapper = (BiomeWrapper)BiomeWrapper.deserialize("minecraft:plains", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get planes biome with resource location [minecraft:plains] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return null;
            }
        }
        return this.plainsBiomeWrapper;
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.dimensionType());
    }

    @Override
    public String getDimensionName() {
        return this.level.dimension().location().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.getBiomeManager().biomeZoomSeed;
    }

    @Override
    public String getDhIdentifier() {
        return this.getHashedSeedEncoded() + "@" + this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.dimensionType().hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.dimensionType().hasSkyLight();
    }

    @Override
    public int getMaxHeight() {
        return this.level.getHeight();
    }

    @Override
    public int getMinHeight() {
        return this.level.getMinY();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.hasChunk(pos.getX(), pos.getZ())) {
            return null;
        }
        ChunkAccess chunk = this.level.getChunk(pos.getX(), pos.getZ(), ChunkStatus.EMPTY, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ClientChunkCache source = this.level.getChunkSource();
        return source.hasChunk(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.getBlockState(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.level.getBiome(McObjectConverter.Convert(pos)), this);
    }

    public ClientLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.remove(this.level);
        this.parentDhLevel = null;
    }

    @Override
    public File getDhSaveFolder() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getSaveStructure().getSaveFolder(this);
    }

    @Override
    public void setParentLevel(IDhLevel parentLevel) {
        this.parentDhLevel = parentLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getGenericRenderer();
    }

    @Override
    public Color getCloudColor(float tickDelta) {
        int argbColor = this.level.getCloudColor(tickDelta);
        return ColorUtil.toColorObjARGB(argbColor);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

