/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.FakeTrackBlock;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntityTilt;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.IMergeableBE;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5321;

public class TrackBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity,
IMergeableBE {
    Map<class_2338, BezierConnection> connections = new HashMap<class_2338, BezierConnection>();
    boolean cancelDrops;
    public Pair<class_5321<class_1937>, class_2338> boundLocation;
    public TrackBlockEntityTilt tilt;

    public TrackBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK, pos, state);
        this.setLazyTickRate(100);
        this.tilt = new TrackBlockEntityTilt(this);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        this.cancelDrops |= this.field_11863.method_8320(pos).method_27852((class_2248)AllBlocks.TRACK);
        this.removeInboundConnections(true);
    }

    public Map<class_2338, BezierConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_11863.field_9236 && this.hasInteractableConnections()) {
            AllClientHandle.INSTANCE.registerToCurveInteraction(this);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.tilt.undoSmoothing();
    }

    @Override
    public void lazyTick() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void validateConnections() {
        HashSet<class_2338> invalid = new HashSet<class_2338>();
        for (Map.Entry<class_2338, BezierConnection> entry : this.connections.entrySet()) {
            TrackBlockEntity trackBE;
            BezierConnection bc;
            block10: {
                class_2338 key;
                block9: {
                    class_2586 blockEntity;
                    key = entry.getKey();
                    if (!key.equals((Object)(bc = entry.getValue()).getKey()) || !this.field_11867.equals(bc.bePositions.getFirst())) {
                        invalid.add(key);
                        continue;
                    }
                    class_2680 blockState = this.field_11863.method_8320(key);
                    class_2248 class_22482 = blockState.method_26204();
                    if (class_22482 instanceof ITrackBlock) {
                        ITrackBlock trackBlock = (ITrackBlock)class_22482;
                        if (!((Boolean)blockState.method_11654((class_2769)TrackBlock.HAS_BE)).booleanValue()) {
                            for (class_243 v : trackBlock.getTrackAxes((class_1922)this.field_11863, key, blockState)) {
                                class_243 bcEndAxis;
                                if (!(v.method_1022(bcEndAxis = (class_243)bc.axes.getSecond()) < 9.765625E-4) && !(v.method_1022(bcEndAxis.method_1021(-1.0)) < 9.765625E-4)) continue;
                                this.field_11863.method_8652(key, (class_2680)blockState.method_11657((class_2769)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
                            }
                        }
                    }
                    if (!((blockEntity = this.field_11863.method_8321(key)) instanceof TrackBlockEntity)) break block9;
                    trackBE = (TrackBlockEntity)blockEntity;
                    if (!blockEntity.method_11015()) break block10;
                }
                invalid.add(key);
                continue;
            }
            if (trackBE.connections.containsKey(this.field_11867)) continue;
            trackBE.addConnection(bc.secondary());
            trackBE.tilt.tryApplySmoothing();
        }
        for (class_2338 blockPos : invalid) {
            this.removeConnection(blockPos);
        }
    }

    public void addConnection(BezierConnection connection) {
        if (this.connections.containsKey(connection.getKey()) && connection.equalsSansMaterial(this.connections.get(connection.getKey()))) {
            return;
        }
        this.connections.put(connection.getKey(), connection);
        this.field_11863.method_64310(this.field_11867, this.method_11010().method_26204(), 1);
        this.notifyUpdate();
        if (connection.isPrimary()) {
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void removeConnection(class_2338 target) {
        class_1937 class_19372;
        if (this.isTilted()) {
            this.tilt.captureSmoothingHandles();
        }
        BezierConnection removed = this.connections.remove(target);
        this.notifyUpdate();
        if (removed != null) {
            this.manageFakeTracksAlong(removed, true);
        }
        if (!this.connections.isEmpty() || ((TrackShape)((Object)this.method_11010().method_61767(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.NONE)))).isPortal()) {
            return;
        }
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        if (blockState.method_28498((class_2769)TrackBlock.HAS_BE)) {
            this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false)));
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            RemoveBlockEntityPacket packet = new RemoveBlockEntityPacket(this.field_11867);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false)) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    public void removeInboundConnections(boolean dropAndDiscard) {
        BezierConnection bezierConnection2;
        for (BezierConnection bezierConnection2 : this.connections.values()) {
            class_2586 class_25862 = this.field_11863.method_8321(bezierConnection2.getKey());
            if (!(class_25862 instanceof TrackBlockEntity)) {
                return;
            }
            TrackBlockEntity tbe = (TrackBlockEntity)class_25862;
            tbe.removeConnection((class_2338)bezierConnection2.bePositions.getFirst());
            if (!dropAndDiscard) continue;
            if (!this.cancelDrops) {
                bezierConnection2.spawnItems(this.field_11863);
            }
            bezierConnection2.spawnDestroyParticles(this.field_11863);
        }
        if (dropAndDiscard && (bezierConnection2 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)bezierConnection2;
            RemoveBlockEntityPacket packet = new RemoveBlockEntityPacket(this.field_11867);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false)) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    public void bind(class_5321<class_1937> boundDimension, class_2338 boundLocation) {
        this.boundLocation = Pair.of(boundDimension, boundLocation);
        this.method_5431();
    }

    public boolean isTilted() {
        return this.tilt.smoothingAngle.isPresent();
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        this.writeTurns(view, true);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.writeTurns(view, false);
        this.tilt.smoothingAngle.ifPresent(angle -> view.method_71468("Smoothing", (Codec)Codec.DOUBLE, angle));
        if (this.boundLocation == null) {
            return;
        }
        view.method_71468("BoundLocation", class_2338.field_25064, (Object)this.boundLocation.getSecond());
        view.method_71468("BoundDimension", class_1937.field_25178, this.boundLocation.getFirst());
    }

    private void writeTurns(class_11372 view, boolean restored) {
        class_11372.class_11374 list = view.method_71476("Connections");
        for (BezierConnection bezierConnection : this.connections.values()) {
            (restored ? this.tilt.restoreToOriginalCurve(bezierConnection.clone()) : bezierConnection).write(list.method_71480(), this.field_11867);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.connections.clear();
        view.method_71438("Connections").forEach(item -> {
            BezierConnection connection = new BezierConnection((class_11368)item, this.field_11867);
            this.connections.put(connection.getKey(), connection);
        });
        boolean smoothingPreviously = this.tilt.smoothingAngle.isPresent();
        this.tilt.smoothingAngle = view.method_71426("Smoothing", (Codec)Codec.DOUBLE);
        if (smoothingPreviously != this.tilt.smoothingAngle.isPresent() && clientPacket) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 16);
        }
        if (this.field_11863.field_9236) {
            AllClientHandle.INSTANCE.queueUpdate(this);
            if (this.hasInteractableConnections()) {
                AllClientHandle.INSTANCE.registerToCurveInteraction(this);
            } else {
                AllClientHandle.INSTANCE.removeFromCurveInteraction(this);
            }
        }
        view.method_71426("BoundLocation", class_2338.field_25064).ifPresent(pos -> {
            this.boundLocation = Pair.of((class_5321)view.method_71426("BoundDimension", class_1937.field_25178).orElseThrow(), pos);
        });
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void accept(class_2586 other) {
        if (other instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)other;
            this.connections.putAll(track.connections);
        }
        this.validateConnections();
        this.field_11863.method_64310(this.field_11867, this.method_11010().method_26204(), 1);
    }

    public boolean hasInteractableConnections() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        HashMap<class_2338, BezierConnection> restoredConnections = new HashMap<class_2338, BezierConnection>();
        for (Map.Entry<class_2338, BezierConnection> entry : this.connections.entrySet()) {
            restoredConnections.put(entry.getKey(), this.tilt.restoreToOriginalCurve(this.tilt.restoreToOriginalCurve(entry.getValue().secondary()).secondary()));
        }
        this.connections = restoredConnections;
        this.tilt.smoothingAngle = Optional.empty();
        if (transform.rotationAxis != class_2350.class_2351.field_11052) {
            return;
        }
        HashMap<class_2338, BezierConnection> transformedConnections = new HashMap<class_2338, BezierConnection>();
        for (Map.Entry<class_2338, BezierConnection> entry : this.connections.entrySet()) {
            BezierConnection newConnection = entry.getValue();
            newConnection.normals.replace(transform::applyWithoutOffsetUncentered);
            newConnection.axes.replace(transform::applyWithoutOffsetUncentered);
            class_2338 diff = ((class_2338)newConnection.bePositions.getSecond()).method_10059((class_2382)newConnection.bePositions.getFirst());
            newConnection.bePositions.setSecond(class_2338.method_49638((class_2374)class_243.method_24953((class_2382)((class_2382)newConnection.bePositions.getFirst())).method_1019(transform.applyWithoutOffsetUncentered(class_243.method_24954((class_2382)diff)))));
            class_243 beVec = class_243.method_24954((class_2382)this.field_11867);
            class_243 teCenterVec = beVec.method_1031(0.5, 0.5, 0.5);
            class_243 start = (class_243)newConnection.starts.getFirst();
            class_243 startToBE = start.method_1020(teCenterVec);
            class_243 endToStart = ((class_243)newConnection.starts.getSecond()).method_1020(start);
            startToBE = transform.applyWithoutOffsetUncentered(startToBE).method_1019(teCenterVec);
            endToStart = transform.applyWithoutOffsetUncentered(endToStart).method_1019(startToBE);
            newConnection.starts.setFirst(new TrackNodeLocation(startToBE).getLocation());
            newConnection.starts.setSecond(new TrackNodeLocation(endToStart).getLocation());
            class_2338 newTarget = newConnection.getKey();
            transformedConnections.put(newTarget, newConnection);
        }
        this.connections = transformedConnections;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.field_11863.field_9236) {
            AllClientHandle.INSTANCE.removeFromCurveInteraction(this);
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (BezierConnection connection : this.connections.values()) {
            this.manageFakeTracksAlong(connection, true);
        }
        if (this.boundLocation != null && this.field_11863 instanceof class_3218) {
            class_3218 otherLevel = this.field_11863.method_8503().method_3847(this.boundLocation.getFirst());
            if (otherLevel == null) {
                return;
            }
            if (otherLevel.method_8320(this.boundLocation.getSecond()).method_26164(AllBlockTags.TRACKS)) {
                otherLevel.method_22352(this.boundLocation.getSecond(), false);
            }
        }
    }

    public void manageFakeTracksAlong(BezierConnection bc, boolean remove) {
        Map<Pair<Integer, Integer>, Double> yLevels = bc.rasterise();
        for (Map.Entry<Pair<Integer, Integer>, Double> entry : yLevels.entrySet()) {
            double yValue = entry.getValue();
            int floor = class_3532.method_15357((double)yValue);
            class_2338 targetPos = new class_2338(entry.getKey().getFirst().intValue(), floor, entry.getKey().getSecond().intValue());
            targetPos = targetPos.method_10081((class_2382)bc.bePositions.getFirst()).method_10086(1);
            class_2680 stateAtPos = this.field_11863.method_8320(targetPos);
            boolean present = stateAtPos.method_27852((class_2248)AllBlocks.FAKE_TRACK);
            if (remove) {
                if (!present) continue;
                this.field_11863.method_8650(targetPos, false);
                continue;
            }
            class_3610 fluidState = stateAtPos.method_26227();
            if (!fluidState.method_15769() && !fluidState.method_33659((class_3611)class_3612.field_15910)) continue;
            if (!present && stateAtPos.method_45474()) {
                this.field_11863.method_8652(targetPos, ProperWaterloggedBlock.withWater((class_4538)this.field_11863, AllBlocks.FAKE_TRACK.method_9564(), targetPos), 3);
            }
            FakeTrackBlock.keepAlive((class_1936)this.field_11863, targetPos);
        }
    }
}

