/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

@Environment(value=EnvType.CLIENT)
public class PulleyScenes {
    public static void movement(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("rope_pulley", "Moving Structures using Rope Pulleys");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        Selection reversable = util.select().fromTo(2, 3, 4, 2, 4, 2);
        class_2338 leverPos = util.grid().at(1, 2, 4);
        class_2338 pulleyPos = util.grid().at(2, 4, 2);
        Selection redstoneStuff = util.select().fromTo(leverPos, leverPos.method_10078());
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        ElementLink<WorldSectionElement> plank = scene.world().showIndependentSection(util.select().position(2, 1, 2), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 4, 3, 2, 1, 4), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(pulleyPos), class_2350.field_11035);
        scene.idle(20);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, 2.0f, 40);
        scene.idle(45);
        scene.overlay().showText(60).pointAt(util.vector().blockSurface(pulleyPos, class_2350.field_11039)).attachKeyFrame().text("Rope Pulleys can move blocks vertically when given Rotational Force").placeNearTarget();
        scene.idle(70);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, -2.0f, 40);
        scene.world().moveSection(plank, util.vector().of(0.0, 2.0, 0.0), 40);
        scene.idle(60);
        scene.overlay().showText(60).pointAt(util.vector().blockSurface(pulleyPos, class_2350.field_11035)).text("Direction and Speed of movement depend on the Rotational Input").placeNearTarget();
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, 2.0f, 40);
        scene.world().moveSection(plank, util.vector().of(0.0, -2.0, 0.0), 40);
        scene.idle(50);
        scene.world().hideIndependentSection(plank, class_2350.field_11043);
        scene.idle(15);
        ElementLink<WorldSectionElement> chassis = scene.world().showIndependentSection(util.select().fromTo(2, 1, 1, 0, 2, 1), class_2350.field_11035);
        scene.world().moveSection(chassis, util.vector().of(1.0, 0.0, 1.0), 0);
        scene.world().replaceBlocks(util.select().fromTo(0, 2, 1, 2, 1, 1), class_2246.field_10161.method_9564(), false);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(2, 1, 0), class_2350.field_11035, chassis);
        scene.overlay().showOutline(PonderPalette.GREEN, "glue", util.select().position(3, 1, 1).add(util.select().fromTo(1, 1, 2, 3, 1, 2)).add(util.select().position(1, 2, 2)), 40);
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(2, 2, 0)), Pointing.RIGHT, 40).withItem(AllItems.SUPER_GLUE.method_7854());
        scene.idle(15);
        scene.effects().superGlue(util.grid().at(3, 1, 1), class_2350.field_11035, true);
        scene.overlay().showText(80).pointAt(util.vector().blockSurface(util.grid().at(1, 2, 2), class_2350.field_11043)).placeNearTarget().attachKeyFrame().sharedText("movement_anchors");
        scene.idle(90);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, -2.0f, 40);
        scene.world().moveSection(chassis, util.vector().of(0.0, 2.0, 0.0), 40);
        scene.idle(50);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, 2.0f, 40);
        scene.world().moveSection(chassis, util.vector().of(0.0, -2.0, 0.0), 40);
        scene.idle(50);
    }

    public static void movementModes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("rope_pulley_modes", "Movement Modes of the Rope Pulley");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        Selection reversable = util.select().fromTo(2, 3, 4, 2, 4, 2);
        class_2338 leverPos = util.grid().at(1, 2, 4);
        class_2338 pulleyPos = util.grid().at(2, 4, 2);
        Selection redstoneStuff = util.select().fromTo(leverPos, leverPos.method_10078());
        class_2338 flowerPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().showSection(util.select().position(flowerPos), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 4, 3, 2, 1, 4), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(pulleyPos), class_2350.field_11035);
        ElementLink<WorldSectionElement> glass = scene.world().showIndependentSection(util.select().position(pulleyPos.method_10074()), class_2350.field_11036);
        scene.idle(20);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, 2.0f, 40);
        scene.world().moveSection(glass, util.vector().of(0.0, -2.0, 0.0), 40);
        scene.idle(40);
        scene.world().destroyBlock(flowerPos);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().position(flowerPos), 70).text("Whenever Pulleys stop moving, the moved structure reverts to blocks").attachKeyFrame().placeNearTarget().colored(PonderPalette.RED);
        scene.idle(80);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, -2.0f, 40);
        scene.world().moveSection(glass, util.vector().of(0.0, 2.0, 0.0), 40);
        scene.world().hideSection(util.select().position(flowerPos), class_2350.field_11033);
        scene.idle(40);
        scene.world().setBlock(flowerPos, class_2246.field_10086.method_9564(), false);
        scene.world().showSection(util.select().position(flowerPos), class_2350.field_11033);
        scene.overlay().showCenteredScrollInput(pulleyPos, class_2350.field_11036, 60);
        scene.overlay().showControls(util.vector().topOf(pulleyPos), Pointing.DOWN, 60).rightClick();
        scene.overlay().showText(70).pointAt(util.vector().topOf(pulleyPos)).placeNearTarget().attachKeyFrame().sharedText("behaviour_modify_value_panel");
        scene.idle(80);
        scene.world().toggleRedstonePower(redstoneStuff);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(reversable, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(pulleyPos.method_10072());
        scene.world().movePulley(pulleyPos, 2.0f, 40);
        scene.world().moveSection(glass, util.vector().of(0.0, -2.0, 0.0), 40);
        scene.idle(50);
        scene.overlay().showText(120).colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(flowerPos, class_2350.field_11039)).placeNearTarget().text("It can be configured never to revert to solid blocks, or only at the location it started at");
        scene.idle(90);
    }

    public static void attachment(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("rope_pulley_attachment", "Moving Pulleys as part of a Contraption");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        Selection kinetics = util.select().fromTo(4, 3, 2, 4, 1, 5);
        Selection largeCog = util.select().position(3, 0, 5);
        scene.world().showSection(kinetics, class_2350.field_11033);
        ElementLink<WorldSectionElement> poles = scene.world().showIndependentSection(util.select().fromTo(4, 4, 2, 6, 4, 2), class_2350.field_11033);
        scene.world().moveSection(poles, util.vector().of(0.0, -1.0, 0.0), 0);
        scene.idle(10);
        class_2338 pulleyPos = util.grid().at(3, 3, 2);
        ElementLink<WorldSectionElement> pulley = scene.world().showIndependentSection(util.select().position(pulleyPos), class_2350.field_11034);
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().fromTo(3, 1, 1, 3, 1, 2).add(util.select().position(3, 2, 1)), class_2350.field_11035, pulley);
        scene.idle(10);
        scene.overlay().showText(50).pointAt(util.vector().blockSurface(pulleyPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("Whenever Pulleys are themselves being moved by a Contraption...");
        scene.idle(60);
        scene.world().setKineticSpeed(largeCog, -16.0f);
        scene.world().setKineticSpeed(kinetics, 32.0f);
        scene.effects().rotationDirectionIndicator(util.grid().at(4, 1, 5));
        scene.world().moveSection(poles, util.vector().of(-2.0, 0.0, 0.0), 40);
        scene.world().moveSection(pulley, util.vector().of(-2.0, 0.0, 0.0), 40);
        scene.idle(40);
        scene.overlay().showOutlineWithText(util.select().fromTo(1, 1, 1, 1, 1, 2), 50).colored(PonderPalette.GREEN).placeNearTarget().attachKeyFrame().text("...its attached structure will be dragged with it");
        scene.idle(60);
        scene.overlay().showText(80).colored(PonderPalette.RED).pointAt(util.vector().topOf(pulleyPos.method_10088(2))).placeNearTarget().text("Mind that pulleys are only movable while stopped");
        scene.idle(50);
    }

    public static void multiRope(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("rope_pulley_multi_rope", "Synchronised Pulley Movement");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.scaleSceneView(0.95f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        Selection contraption = util.select().fromTo(3, 1, 1, 1, 1, 3);
        class_2338 crankPos = util.grid().at(3, 4, 0);
        class_2338 pulley1 = util.grid().at(3, 4, 1);
        class_2338 pulley2 = util.grid().at(3, 4, 3);
        class_2338 pulley3 = util.grid().at(1, 4, 3);
        Selection kinetics = util.select().fromTo(3, 4, 0, 3, 4, 1);
        ElementLink<WorldSectionElement> planksLink = scene.world().showIndependentSection(contraption, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(pulley1), class_2350.field_11033);
        scene.idle(4);
        scene.world().showSection(util.select().position(pulley2), class_2350.field_11033);
        scene.idle(4);
        scene.world().showSection(util.select().position(pulley3), class_2350.field_11033);
        scene.idle(4);
        scene.world().showSection(util.select().position(crankPos), class_2350.field_11035);
        scene.idle(15);
        scene.world().setKineticSpeed(kinetics, 32.0f);
        scene.world().movePulley(pulley1, 2.0f, 20);
        scene.idle(20);
        scene.world().setKineticSpeed(kinetics, 0.0f);
        scene.overlay().showText(60).pointAt(util.vector().topOf(util.grid().at(3, 1, 1))).placeNearTarget().text("Whenever a pulley assembles a contraption...");
        scene.idle(70);
        scene.world().movePulley(pulley2, 2.0f, 0);
        scene.world().movePulley(pulley3, 2.0f, 0);
        scene.idle(1);
        scene.world().setKineticSpeed(kinetics, -32.0f);
        scene.world().movePulley(pulley1, -2.0f, 20);
        scene.world().movePulley(pulley2, -2.0f, 20);
        scene.world().movePulley(pulley3, -2.0f, 20);
        scene.world().moveSection(planksLink, util.vector().of(0.0, 2.0, 0.0), 20);
        scene.idle(20);
        scene.world().setKineticSpeed(kinetics, 0.0f);
        scene.overlay().showText(80).pointAt(util.vector().blockSurface(util.grid().at(1, 4, 3), class_2350.field_11039)).placeNearTarget().text("...other pulleys on the same layer will connect to the structure");
        scene.idle(60);
        scene.world().setKineticSpeed(kinetics, 32.0f);
        scene.world().movePulley(pulley1, 2.0f, 20);
        scene.world().movePulley(pulley2, 2.0f, 20);
        scene.world().movePulley(pulley3, 2.0f, 20);
        scene.world().moveSection(planksLink, util.vector().of(0.0, -2.0, 0.0), 20);
        scene.idle(20);
        scene.world().setKineticSpeed(kinetics, 0.0f);
        scene.idle(20);
        scene.world().setKineticSpeed(kinetics, 32.0f);
        scene.world().movePulley(pulley1, -2.0f, 20);
        scene.world().movePulley(pulley2, -2.0f, 20);
        scene.world().movePulley(pulley3, -2.0f, 20);
        scene.world().moveSection(planksLink, util.vector().of(0.0, 2.0, 0.0), 20);
        scene.idle(20);
        scene.world().setKineticSpeed(kinetics, 0.0f);
        scene.overlay().showText(80).pointAt(util.vector().blockSurface(util.grid().at(1, 4, 3), class_2350.field_11039)).placeNearTarget().text("They do not require to be powered, the effect is purely cosmetic");
        scene.idle(60);
        scene.world().setKineticSpeed(kinetics, 32.0f);
        scene.world().movePulley(pulley1, 2.0f, 20);
        scene.world().movePulley(pulley2, 2.0f, 20);
        scene.world().movePulley(pulley3, 2.0f, 20);
        scene.world().moveSection(planksLink, util.vector().of(0.0, -2.0, 0.0), 20);
        scene.idle(20);
        scene.world().setKineticSpeed(kinetics, 0.0f);
    }
}

