/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.flywheel.api.material.DepthTest;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.material.WriteMask;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import java.util.Comparator;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class MaterialRenderState {
    public static final Comparator<Material> COMPARATOR = MaterialRenderState::compare;

    private MaterialRenderState() {
    }

    public static void setup(Material material) {
        MaterialRenderState.setupFrameBuffer(material.target());
        MaterialRenderState.setupTexture(material);
        MaterialRenderState.setupBackfaceCulling(material.backfaceCulling());
        MaterialRenderState.setupPolygonOffset(material.polygonOffset());
        MaterialRenderState.setupDepthTest(material.depthTest());
        MaterialRenderState.setupTransparency(material.transparency());
        MaterialRenderState.setupWriteMask(material.writeMask());
    }

    public static void setupOit(Material material) {
        MaterialRenderState.setupTexture(material);
        MaterialRenderState.setupBackfaceCulling(material.backfaceCulling());
        MaterialRenderState.setupPolygonOffset(material.polygonOffset());
        MaterialRenderState.setupDepthTest(material.depthTest());
        WriteMask mask = material.writeMask();
        boolean writeColor = mask.color();
        GlStateManager._colorMask((boolean)writeColor, (boolean)writeColor, (boolean)writeColor, (boolean)writeColor);
    }

    private static void setupFrameBuffer(class_4668.class_4678 target) {
        class_276 framebuffer = target.method_68491();
        class_10868 colorAttachment = (class_10868)framebuffer.method_30277();
        if (colorAttachment == null) {
            framebuffer = class_310.method_1551().method_1522();
            colorAttachment = (class_10868)framebuffer.method_30277();
            Objects.requireNonNull(colorAttachment, "No color attachment for framebuffer");
        }
        int i = colorAttachment.method_68426(((class_10865)RenderSystem.getDevice()).method_68401(), framebuffer.field_1478 ? framebuffer.method_30278() : null);
        GlStateManager._glBindFramebuffer((int)36160, (int)i);
    }

    private static void setupTexture(Material material) {
        Samplers.DIFFUSE.makeActive();
        class_1044 texture = class_310.method_1551().method_1531().method_4619(material.texture());
        texture.method_4527(material.blur(), material.mipmap());
        class_10868 glTexture = (class_10868)texture.method_68004();
        int textureId = glTexture.method_68427();
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture.method_71659());
        GlStateManager._bindTexture((int)textureId);
        glTexture.method_68424(3553);
    }

    private static void setupBackfaceCulling(boolean backfaceCulling) {
        if (backfaceCulling) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
    }

    private static void setupPolygonOffset(boolean polygonOffset) {
        if (polygonOffset) {
            GlStateManager._polygonOffset((float)-1.0f, (float)-10.0f);
            GlStateManager._enablePolygonOffset();
        } else {
            GlStateManager._polygonOffset((float)0.0f, (float)0.0f);
            GlStateManager._disablePolygonOffset();
        }
    }

    private static void setupDepthTest(DepthTest depthTest) {
        switch (depthTest) {
            case OFF: {
                GlStateManager._disableDepthTest();
                break;
            }
            case NEVER: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)512);
                break;
            }
            case LESS: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)513);
                break;
            }
            case EQUAL: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)514);
                break;
            }
            case LEQUAL: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)515);
                break;
            }
            case GREATER: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)516);
                break;
            }
            case NOTEQUAL: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)517);
                break;
            }
            case GEQUAL: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)518);
                break;
            }
            case ALWAYS: {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc((int)519);
            }
        }
    }

    private static void setupTransparency(Transparency transparency) {
        switch (transparency) {
            case OPAQUE: {
                GlStateManager._disableBlend();
                break;
            }
            case ADDITIVE: {
                GlStateManager._enableBlend();
                GlStateManager._blendFuncSeparate((int)1, (int)1, (int)1, (int)1);
                break;
            }
            case LIGHTNING: {
                GlStateManager._enableBlend();
                GlStateManager._blendFuncSeparate((int)770, (int)1, (int)770, (int)1);
                break;
            }
            case GLINT: {
                GlStateManager._enableBlend();
                GlStateManager._blendFuncSeparate((int)768, (int)1, (int)0, (int)1);
                break;
            }
            case CRUMBLING: {
                GlStateManager._enableBlend();
                GlStateManager._blendFuncSeparate((int)774, (int)768, (int)1, (int)0);
                break;
            }
            case TRANSLUCENT: {
                GlStateManager._enableBlend();
                GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        }
    }

    private static void setupWriteMask(WriteMask mask) {
        GlStateManager._depthMask((boolean)mask.depth());
        boolean writeColor = mask.color();
        GlStateManager._colorMask((boolean)writeColor, (boolean)writeColor, (boolean)writeColor, (boolean)writeColor);
    }

    public static void reset() {
        MaterialRenderState.resetFrameBuffer();
        MaterialRenderState.resetTexture();
        MaterialRenderState.resetBackfaceCulling();
        MaterialRenderState.resetPolygonOffset();
        MaterialRenderState.resetDepthTest();
        MaterialRenderState.resetTransparency();
        MaterialRenderState.resetWriteMask();
    }

    private static void resetFrameBuffer() {
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    private static void resetTexture() {
        Samplers.DIFFUSE.makeActive();
        RenderSystem.setShaderTexture((int)0, null);
    }

    private static void resetBackfaceCulling() {
        GlStateManager._enableCull();
    }

    private static void resetPolygonOffset() {
        GlStateManager._polygonOffset((float)0.0f, (float)0.0f);
        GlStateManager._disablePolygonOffset();
    }

    private static void resetDepthTest() {
        GlStateManager._disableDepthTest();
        GlStateManager._depthFunc((int)515);
    }

    private static void resetTransparency() {
        GlStateManager._disableBlend();
        GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
    }

    private static void resetWriteMask() {
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static boolean materialEquals(Material lhs, Material rhs) {
        if (lhs == rhs) {
            return true;
        }
        return lhs.blur() == rhs.blur() && lhs.mipmap() == rhs.mipmap() && lhs.backfaceCulling() == rhs.backfaceCulling() && lhs.polygonOffset() == rhs.polygonOffset() && lhs.depthTest() == rhs.depthTest() && lhs.transparency() == rhs.transparency() && lhs.writeMask() == rhs.writeMask() && lhs.light().source().equals((Object)rhs.light().source()) && lhs.texture().equals((Object)rhs.texture()) && lhs.cutout().source().equals((Object)rhs.cutout().source()) && lhs.shaders().fragmentSource().equals((Object)rhs.shaders().fragmentSource()) && lhs.shaders().vertexSource().equals((Object)rhs.shaders().vertexSource());
    }

    public static boolean materialIsAllNonNull(@Nullable Material material) {
        return material != null && material.shaders() != null && material.shaders().fragmentSource() != null && material.shaders().vertexSource() != null && material.fog() != null && material.fog().source() != null && material.cutout() != null && material.cutout().source() != null && material.light() != null && material.light().source() != null && material.texture() != null && material.depthTest() != null && material.transparency() != null && material.writeMask() != null && material.cardinalLightingMode() != null;
    }

    public static int compare(Material lhs, Material rhs) {
        if (lhs == rhs) {
            return 0;
        }
        int cmp = lhs.transparency().compareTo(rhs.transparency());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.light().source().method_12833(rhs.light().source());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.cutout().source().method_12833(rhs.cutout().source());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.shaders().fragmentSource().method_12833(rhs.shaders().fragmentSource());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.shaders().vertexSource().method_12833(rhs.shaders().vertexSource());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.texture().method_12833(rhs.texture());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.blur(), rhs.blur());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.mipmap(), rhs.mipmap());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.backfaceCulling(), rhs.backfaceCulling());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(lhs.polygonOffset(), rhs.polygonOffset());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.depthTest().compareTo(rhs.depthTest());
        if (cmp != 0) {
            return cmp;
        }
        cmp = lhs.writeMask().compareTo(rhs.writeMask());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }
}

