/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.nbt;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.catnip.components.ComponentProcessors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public final class NBTProcessors {
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> processors = new HashMap();
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> survivalProcessors = new HashMap();
    private static final UnaryOperator<class_2487> signProcessor = data -> {
        for (String key : List.of("front_text", "back_text")) {
            class_2487 textTag = data.method_68568(key);
            if (!textTag.method_10545("messages")) continue;
            for (class_2520 tag : textTag.method_68569("messages")) {
                class_2519 stringTag;
                if (!(tag instanceof class_2519) || !NBTProcessors.textComponentHasClickEvent((stringTag = (class_2519)tag).method_68658().orElse(""))) continue;
                return null;
            }
        }
        if (data.method_10545("front_item") || data.method_10545("back_item")) {
            return null;
        }
        return data;
    };

    public static synchronized void addProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<class_2487> itemProcessor(String tagKey) {
        return data -> {
            class_2487 compound = data.method_68568(tagKey);
            if (!compound.method_10545("components")) {
                return data;
            }
            class_2487 itemComponents = compound.method_68568("components");
            HashSet keys = new HashSet(itemComponents.method_10541());
            for (String key : keys) {
                class_9331 type = (class_9331)class_7923.field_49658.method_63535(class_2960.method_60654((String)key));
                if (type == null || !ComponentProcessors.isUnsafeItemComponent(type)) continue;
                itemComponents.method_10551(key);
            }
            if (itemComponents.method_33133()) {
                compound.method_10551("components");
            }
            return data;
        };
    }

    public static boolean textComponentHasClickEvent(String string) {
        JsonElement json = JsonParser.parseString((String)(string.isEmpty() ? "\"\"" : string));
        class_2561 text = (class_2561)class_8824.field_46597.parse((DynamicOps)class_5455.field_40585.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        return NBTProcessors.textComponentHasClickEvent(text);
    }

    public static boolean textComponentHasClickEvent(class_2561 component) {
        for (class_2561 sibling : component.method_10855()) {
            if (!NBTProcessors.textComponentHasClickEvent(sibling)) continue;
            return true;
        }
        return component.method_10866() != null && component.method_10866().method_10970() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static class_2487 process(class_2680 state, class_2586 blockEntity, @Nullable class_2487 compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        class_2591 type = blockEntity.method_11017();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (class_2487)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (class_2487)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof class_2636) {
            return compound;
        }
        if (state.method_26164(class_3481.field_41282)) {
            return (class_2487)signProcessor.apply(compound);
        }
        return compound;
    }
}

