/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.animation;

import fuzs.mutantmonsters.network.ClientboundAnimationMessage;
import fuzs.mutantmonsters.world.entity.animation.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.animation.EntityAnimation;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import org.apache.commons.lang3.ArrayUtils;

public interface AnimatedEntity
extends AdditionalSpawnDataEntity {
    public EntityAnimation getAnimation();

    public void setAnimation(EntityAnimation var1);

    public EntityAnimation[] getAnimations();

    public int getAnimationTick();

    public void setAnimationTick(int var1);

    default public boolean isAnimationPlaying() {
        return this.getAnimation() != EntityAnimation.NONE;
    }

    @Override
    default public void writeAdditionalAddEntityData(class_2487 compoundTag) {
        compoundTag.method_10567("animation_index", (byte)ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        compoundTag.method_10569("animation_tick", this.getAnimationTick());
    }

    @Override
    default public void readAdditionalAddEntityData(class_2487 compoundTag) {
        byte animationId = compoundTag.method_68562("animation_index", (byte)0);
        this.setAnimation(animationId < 0 ? EntityAnimation.NONE : this.getAnimations()[animationId]);
        this.setAnimationTick(compoundTag.method_68083("animation_tick", 0));
    }

    public static <T extends class_1297> void sendAnimationPacket(T entity, EntityAnimation animation) {
        if (!entity.method_37908().field_9236) {
            ((AnimatedEntity)entity).setAnimation(animation);
            ((AnimatedEntity)entity).setAnimationTick(0);
            PlayerSet playerSet = PlayerSet.nearEntity(entity);
            MessageSender.broadcast((PlayerSet)playerSet, (Message)new ClientboundAnimationMessage(entity.method_5628(), ArrayUtils.indexOf((Object[])((AnimatedEntity)entity).getAnimations(), (Object)animation)));
        }
    }
}

