/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.CreeperMinionModel;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.CreeperMinionRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.PowerableLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.CreeperMinionRenderState;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10201;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_922;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public class CreeperMinionOnShoulderLayer
extends class_3887<class_10055, class_591> {
    static final RenderPropertyKey<Optional<Boolean>> CREEPER_ON_LEFT_SHOULDER_RENDER_PROPERTY_KEY = new RenderPropertyKey(MutantMonsters.id("creeper_on_left_shoulder"));
    static final RenderPropertyKey<Optional<Boolean>> CREEPER_ON_RIGHT_SHOULDER_RENDER_PROPERTY_KEY = new RenderPropertyKey(MutantMonsters.id("creeper_on_right_shoulder"));
    private final class_10201 equipmentAssets;
    private final CreeperMinionModel model;
    private final CreeperMinionModel chargedModel;
    private final CreeperMinionRenderState renderState = new CreeperMinionRenderState();

    public CreeperMinionOnShoulderLayer(class_3883<class_10055, class_591> entityRenderer, class_5617.class_5618 context) {
        super(entityRenderer);
        this.equipmentAssets = context.method_64071();
        this.model = new CreeperMinionModel(context.method_32167(ModelLayerLocations.CREEPER_MINION_SHOULDER));
        this.chargedModel = new CreeperMinionModel(context.method_32167(ModelLayerLocations.CREEPER_MINION_SHOULDER_ARMOR));
        this.renderState.inSittingPose = true;
    }

    public static void addLivingEntityRenderLayers(class_1299<?> entityType, class_922<?, ?, ?> entityRenderer, class_5617.class_5618 context) {
        if (entityRenderer instanceof class_1007) {
            class_1007 playerRenderer = (class_1007)entityRenderer;
            playerRenderer.method_4046((class_3887)new CreeperMinionOnShoulderLayer((class_3883<class_10055, class_591>)playerRenderer, context));
        }
    }

    public static void onExtractRenderState(class_1297 entity, class_10017 entityRenderState, float partialTick) {
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            if (entityRenderState instanceof class_10055) {
                RenderPropertyKey.set((class_10017)entityRenderState, CREEPER_ON_LEFT_SHOULDER_RENDER_PROPERTY_KEY, CreeperMinionOnShoulderLayer.getMinionOnShoulder(player, true));
                RenderPropertyKey.set((class_10017)entityRenderState, CREEPER_ON_RIGHT_SHOULDER_RENDER_PROPERTY_KEY, CreeperMinionOnShoulderLayer.getMinionOnShoulder(player, false));
            }
        }
    }

    private static Optional<Boolean> getMinionOnShoulder(class_742 player, boolean leftShoulder) {
        class_2487 compoundTag;
        class_2487 class_24872 = compoundTag = leftShoulder ? player.method_7356() : player.method_7308();
        if (compoundTag.method_33133()) {
            return Optional.empty();
        }
        class_1299 entityType = compoundTag.method_67491("id", class_1299.field_57582).orElse(null);
        return entityType == ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349() ? compoundTag.method_10577("Powered") : Optional.empty();
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, int packedLight, class_10055 renderState, float yRot, float xRot) {
        ((Optional)RenderPropertyKey.getOrDefault((class_10017)renderState, CREEPER_ON_LEFT_SHOULDER_RENDER_PROPERTY_KEY, Optional.empty())).ifPresent(isPowered -> this.renderOnShoulder(poseStack, bufferSource, packedLight, renderState, yRot, xRot, true, (boolean)isPowered));
        ((Optional)RenderPropertyKey.getOrDefault((class_10017)renderState, CREEPER_ON_RIGHT_SHOULDER_RENDER_PROPERTY_KEY, Optional.empty())).ifPresent(isPowered -> this.renderOnShoulder(poseStack, bufferSource, packedLight, renderState, yRot, xRot, false, (boolean)isPowered));
    }

    private void renderOnShoulder(class_4587 poseStack, class_4597 bufferSource, int packedLight, class_10055 renderState, float yRot, float xRot, boolean isLeftShoulder, boolean isPowered) {
        this.extractRenderState(renderState, yRot, xRot);
        poseStack.method_22903();
        poseStack.method_46416(0.42f * (isLeftShoulder ? 1.0f : -1.0f), renderState.field_53410 ? -0.55f : -0.75f, 0.0f);
        if (this.hasLayer(renderState.field_53418, class_10186.class_10190.field_54125)) {
            poseStack.method_46416(0.0f, -0.053125f, 0.0f);
        }
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        this.model.method_62075(this.renderState);
        class_4588 vertexConsumer = bufferSource.getBuffer(this.model.method_23500(CreeperMinionRenderer.TEXTURE_LOCATION));
        this.model.method_60879(poseStack, vertexConsumer, packedLight, class_4608.field_21444);
        if (isPowered) {
            vertexConsumer = bufferSource.getBuffer(ModRenderType.energySwirl(PowerableLayer.LIGHTNING_TEXTURE, this.renderState.field_53328 * 0.01f, this.renderState.field_53328 * 0.01f));
            this.chargedModel.method_62075(this.renderState);
            int color = class_9848.method_61318((float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            this.chargedModel.method_62100(poseStack, vertexConsumer, packedLight, class_4608.field_21444, color);
        }
        poseStack.method_22909();
    }

    private boolean hasLayer(class_1799 stack, class_10186.class_10190 layer) {
        class_10192 equippable = (class_10192)stack.method_58694(class_9334.field_54196);
        if (equippable != null && !equippable.comp_3176().isEmpty()) {
            class_10186 equipmentClientInfo = this.equipmentAssets.method_64087((class_5321)equippable.comp_3176().get());
            return !equipmentClientInfo.method_63996(layer).isEmpty();
        }
        return false;
    }

    private void extractRenderState(class_10055 renderState, float yRot, float xRot) {
        this.renderState.field_53328 = renderState.field_53328;
        this.renderState.field_53450 = renderState.field_53450;
        this.renderState.field_53451 = renderState.field_53451;
        this.renderState.field_53447 = yRot;
        this.renderState.field_53448 = xRot;
    }
}

