/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.bettervillage.compat;

import com.jtorleonstudios.bettervillage.Main;
import com.jtorleonstudios.bettervillage.compat.CompatMetaData;
import com.jtorleonstudios.bettervillage.compat.CompatResourcesListener;
import com.jtorleonstudios.bettervillage.mixin.StructurePoolAccessor;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public interface ICompatProcess {
    public static void apply(MinecraftServer server, @NotNull class_3218 serverWorld) {
        if (serverWorld.method_27983().equals(class_1937.field_25179)) {
            class_5455.class_6890 manager = server.method_30611();
            class_2378 pools = manager.method_30530(class_7924.field_41249);
            class_3785 plainsPool = (class_3785)pools.method_63535(class_2960.method_60654((String)"minecraft:village/plains/houses"));
            ArrayList<Pair<class_3784, Integer>> plainsStructurePoolElementCounts = ICompatProcess.getPoolElementCounts(plainsPool);
            ObjectArrayList<class_3784> plainsStructurePoolElement = ICompatProcess.getPoolElements(plainsPool);
            class_3785 desertPool = (class_3785)pools.method_63535(class_2960.method_60654((String)"minecraft:village/desert/houses"));
            ArrayList<Pair<class_3784, Integer>> desertStructurePoolElementCounts = ICompatProcess.getPoolElementCounts(desertPool);
            ObjectArrayList<class_3784> desertStructurePoolElement = ICompatProcess.getPoolElements(desertPool);
            class_3785 snowyPool = (class_3785)pools.method_63535(class_2960.method_60654((String)"minecraft:village/snowy/houses"));
            ArrayList<Pair<class_3784, Integer>> snowyStructurePoolElementCounts = ICompatProcess.getPoolElementCounts(snowyPool);
            ObjectArrayList<class_3784> snowyStructurePoolElement = ICompatProcess.getPoolElements(snowyPool);
            class_3785 savannaPool = (class_3785)pools.method_63535(class_2960.method_60654((String)"minecraft:village/savanna/houses"));
            ArrayList<Pair<class_3784, Integer>> savannaStructurePoolElementCounts = ICompatProcess.getPoolElementCounts(savannaPool);
            ObjectArrayList<class_3784> savannaStructurePoolElement = ICompatProcess.getPoolElements(savannaPool);
            class_3785 taigaPool = (class_3785)pools.method_63535(class_2960.method_60654((String)"minecraft:village/taiga/houses"));
            ArrayList<Pair<class_3784, Integer>> taigaStructurePoolElementCounts = ICompatProcess.getPoolElementCounts(taigaPool);
            ObjectArrayList<class_3784> taigaStructurePoolElement = ICompatProcess.getPoolElements(taigaPool);
            CompatResourcesListener.COMPAT_META_DATA_LIST.forEach(v -> {
                if (v.requireApplyCompat()) {
                    ICompatProcess.poolReplacementProcess(plainsPool, plainsStructurePoolElementCounts, plainsStructurePoolElement, v, v.getPoolPlains());
                    ICompatProcess.poolReplacementProcess(desertPool, desertStructurePoolElementCounts, desertStructurePoolElement, v, v.getPoolDesert());
                    ICompatProcess.poolReplacementProcess(savannaPool, savannaStructurePoolElementCounts, savannaStructurePoolElement, v, v.getPoolSavanna());
                    ICompatProcess.poolReplacementProcess(snowyPool, snowyStructurePoolElementCounts, snowyStructurePoolElement, v, v.getPoolSnowy());
                    ICompatProcess.poolReplacementProcess(taigaPool, taigaStructurePoolElementCounts, taigaStructurePoolElement, v, v.getPoolTaiga());
                }
            });
            ICompatProcess.setPool(plainsPool, plainsStructurePoolElementCounts, plainsStructurePoolElement);
            ICompatProcess.setPool(desertPool, desertStructurePoolElementCounts, desertStructurePoolElement);
            ICompatProcess.setPool(snowyPool, snowyStructurePoolElementCounts, snowyStructurePoolElement);
            ICompatProcess.setPool(savannaPool, savannaStructurePoolElementCounts, savannaStructurePoolElement);
            ICompatProcess.setPool(taigaPool, taigaStructurePoolElementCounts, taigaStructurePoolElement);
        }
    }

    private static void poolReplacementProcess(class_3785 pool, List<Pair<class_3784, Integer>> elementCounts, ObjectArrayList<class_3784> element, CompatMetaData compatMetaData, String[] sourcePoolCompat) {
        if (pool != null && !elementCounts.isEmpty()) {
            for (String structurePathId : sourcePoolCompat) {
                int countRemovedStructuredWeight = 0;
                elementCounts.removeIf(currentPair -> ((class_3784)currentPair.getFirst()).toString().contains(structurePathId));
                ObjectListIterator iteratorElement = element.iterator();
                while (iteratorElement.hasNext()) {
                    class_3784 currentElement = (class_3784)iteratorElement.next();
                    if (!currentElement.toString().contains(structurePathId)) continue;
                    iteratorElement.remove();
                    ++countRemovedStructuredWeight;
                }
                if (compatMetaData.isReplaceStructures() && countRemovedStructuredWeight > 0) {
                    class_3781 piece = (class_3781)class_3784.method_30425((String)("bettervillage_" + structurePathId)).apply(class_3785.class_3786.field_16687);
                    for (int i = 0; i < countRemovedStructuredWeight; ++i) {
                        element.add((Object)piece);
                    }
                    elementCounts.add((Pair<class_3784, Integer>)new Pair((Object)piece, (Object)countRemovedStructuredWeight));
                    Main.LOGGER.info(String.format("Replaced structure of %s mod for compatibility between Better Villages and %<s. (Structure weight defined by the mod %<s is set to %d, you can change the weight in the configuration of the concerned mod)", compatMetaData.getModName(), countRemovedStructuredWeight));
                    continue;
                }
                Main.LOGGER.info(String.format("Deleted structure of %s mod for compatibility between Better Villages and %<s. (Better Villages include the structures by default)", compatMetaData.getModName()));
            }
        }
    }

    private static void setPool(class_3785 pool, List<Pair<class_3784, Integer>> poolElementCounts, ObjectArrayList<class_3784> poolElement) {
        if (pool != null && !poolElementCounts.isEmpty() && !poolElement.isEmpty()) {
            ((StructurePoolAccessor)pool).setElements(poolElement);
            ((StructurePoolAccessor)pool).setElementCounts(poolElementCounts);
        }
    }

    private static ObjectArrayList<class_3784> getPoolElements(class_3785 pool) {
        return pool == null ? new ObjectArrayList<class_3784>() : ((StructurePoolAccessor)pool).getElements();
    }

    @NotNull
    private static ArrayList<Pair<class_3784, Integer>> getPoolElementCounts(class_3785 pool) {
        return pool == null ? new ArrayList<Pair<class_3784, Integer>>() : new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)pool).getElementCounts());
    }
}

