/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.entity;

import com.mojang.serialization.Dynamic;
import fr.hugman.promenade.component.PromenadeComponentTypes;
import fr.hugman.promenade.entity.CapybaraBrain;
import fr.hugman.promenade.entity.PromenadeEntityTypes;
import fr.hugman.promenade.entity.ai.brain.PromenadeMemoryModuleTypes;
import fr.hugman.promenade.entity.data.PromenadeTrackedData;
import fr.hugman.promenade.entity.variant.CapybaraVariant;
import fr.hugman.promenade.entity.variant.CapybaraVariants;
import fr.hugman.promenade.registry.PromenadeRegistryKeys;
import fr.hugman.promenade.sound.PromenadeSoundEvents;
import fr.hugman.promenade.tag.PromenadeItemTags;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10209;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_5863;
import net.minecraft.class_5865;
import net.minecraft.class_6017;
import net.minecraft.class_6333;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class CapybaraEntity
extends class_1429 {
    private static final class_5863 FART_CHANCE_PROVIDER = class_5865.method_33926((float)0.1f, (float)0.55f, (float)0.2f);
    private static final class_4048 BABY_BASE_DIMENSIONS = class_4048.method_18384((float)0.7f, (float)0.875f).method_18383(0.5f).method_55685(0.5f);
    protected static final class_2940<State> STATE = class_2945.method_12791(CapybaraEntity.class, PromenadeTrackedData.CAPYBARA_STATE);
    public static final class_2940<Long> LAST_STATE_TICK = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_39965);
    public static final String FART_CHANCE_KEY = "fart_chance";
    public static final String LAST_STATE_TICK_KEY = "last_state_tick";
    public static final String STATE_KEY = "state_key";
    private static final class_2940<class_6880<CapybaraVariant>> VARIANT = class_2945.method_12791(CapybaraEntity.class, PromenadeTrackedData.CAPYBARA_VARIANT);
    private static final class_2940<Float> FART_CHANCE = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_13320);
    private static final int EAR_WIGGLE_LENGHT = 4;
    private static final class_6017 EAR_WIGGLE_COOLDOWN_PROVIDER = class_6333.method_36249((int)4, (int)64);
    public final class_7094 earWiggleAnimState = new class_7094();
    public final class_7094 fallToSleepAnimState = new class_7094();
    public final class_7094 sleepingAnimState = new class_7094();
    public final class_7094 wakeUpAnimState = new class_7094();
    public final class_7094 fartAnimState = new class_7094();
    public int earWiggleCooldown = 0;
    public static final long FALL_TO_SLEEP_LENGTH = 38L;
    public static final long WAKE_UP_LENGTH = 115L;
    public static final long FART_LENGTH = 76L;

    public CapybaraEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5942().method_6354(true);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.updateAnimations();
        }
        this.tickState();
    }

    protected void method_5958(class_3218 world) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("capybaraBrain");
        class_4095 brain = this.method_18868();
        brain.method_19542((class_3218)this.method_37908(), (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("capybaraActivityUpdate");
        CapybaraBrain.updateActivities(this);
        profiler.method_15407();
        super.method_5958(world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        CapybaraVariants.select(this.field_5974, this.method_56673(), class_10701.method_67169((class_5425)world, (class_2338)this.method_24515())).ifPresent(this::setVariant);
        this.field_6011.method_12778(LAST_STATE_TICK, (Object)(world.method_8410().method_8510() - 115L));
        this.field_6011.method_12778(FART_CHANCE, (Object)Float.valueOf(FART_CHANCE_PROVIDER.method_33920(this.field_5974)));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public static class_5132.class_5133 createCapybaraAttributes() {
        return CapybaraEntity.method_61457().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected class_4095.class_5303<CapybaraEntity> method_28306() {
        return CapybaraBrain.createProfile();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CapybaraBrain.create((class_4095<CapybaraEntity>)this.method_28306().method_28335(dynamic));
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(PromenadeItemTags.CAPYBARA_FOOD);
    }

    public void method_6091(class_243 movementInput) {
        if (!this.method_5805()) {
            return;
        }
        if (this.isStationary() && this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            movementInput = movementInput.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(movementInput);
    }

    public boolean isStationary() {
        return this.isFarting() || this.isAsleep() || this.isWakingUp() || this.isFallingToSleep();
    }

    public boolean method_52546() {
        return this.method_18868().method_18876(class_4140.field_39408, class_4141.field_18456);
    }

    protected class_4048 method_55694(class_4050 pose) {
        return this.method_6109() ? BABY_BASE_DIMENSIONS : super.method_55694(pose);
    }

    protected class_1330 method_5963() {
        return new CapybaraBodyControl(this);
    }

    public void forceDefaultState() {
        this.updateState(State.IDLING);
    }

    public void updateState(State state) {
        this.setState(state);
        this.setLastStateTick(this.method_37908().method_8510());
    }

    private void tickState() {
        if (this.isFarting() && this.getLastStateTickDelta() > this.getFartLength()) {
            this.finishFarting();
        }
        if (this.isFallingToSleep() && this.getLastStateTickDelta() > this.getFallToSleepLength()) {
            this.finishFallingToSleep();
        }
        if (this.isWakingUp() && this.getLastStateTickDelta() > this.getWakeUpLength()) {
            this.finishWakingUp();
        }
    }

    public boolean isFallingToSleep() {
        return this.getState() == State.FALL_TO_SLEEP;
    }

    public boolean canFallToSleep() {
        return this.isStanding() && !this.method_52546() && !this.isFarting();
    }

    public long getFallToSleepLength() {
        return 38L;
    }

    public void startFallingToSleep() {
        this.updateState(State.FALL_TO_SLEEP);
    }

    public void finishFallingToSleep() {
        this.updateState(State.SLEEPING);
    }

    public boolean isAsleep() {
        return this.getState() == State.SLEEPING;
    }

    private boolean isWakingUp() {
        return this.getState() == State.WAKE_UP;
    }

    public boolean canWakeUp() {
        return this.isAsleep() && this.method_37908().method_8530();
    }

    public long getWakeUpLength() {
        return 115L;
    }

    public void startWakingUp() {
        this.updateState(State.WAKE_UP);
    }

    public void finishWakingUp() {
        this.updateState(State.IDLING);
    }

    public boolean isStanding() {
        return this.getState() == State.IDLING;
    }

    public void fart() {
        this.updateState(State.FARTING);
        this.method_18868().method_24525(PromenadeMemoryModuleTypes.FART_COOLDOWN, (Object)class_3902.field_17274, this.createFartCooldown());
        this.method_5783(PromenadeSoundEvents.CAPYBARA_FART, this.method_6107(), this.method_6017());
        this.method_32876((class_6880)class_5712.field_45148);
    }

    public boolean isFarting() {
        return this.getState() == State.FARTING;
    }

    public long getFartLength() {
        return 76L;
    }

    public long createFartCooldown() {
        return 2400L;
    }

    public void finishFarting() {
        this.updateState(State.IDLING);
    }

    public void setLastStateTick(long t) {
        this.field_6011.method_12778(LAST_STATE_TICK, (Object)t);
    }

    public long getLastStateTickDelta() {
        return this.method_37908().method_8510() - (Long)this.field_6011.method_12789(LAST_STATE_TICK);
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(STATE));
    }

    public void setState(State state) {
        this.field_6011.method_12778(STATE, (Object)state);
    }

    @Environment(value=EnvType.CLIENT)
    private void updateAnimations() {
        if (this.earWiggleCooldown <= 0) {
            this.earWiggleCooldown = class_3532.method_15340((int)EAR_WIGGLE_COOLDOWN_PROVIDER.method_35008(this.field_5974), (int)((int)(4.0f / this.getEarWiggleSpeed())), (int)Integer.MAX_VALUE);
            this.earWiggleAnimState.method_41322(this.field_6012);
        } else {
            --this.earWiggleCooldown;
        }
    }

    private void stopAnimations() {
        this.fallToSleepAnimState.method_41325();
        this.sleepingAnimState.method_41325();
        this.wakeUpAnimState.method_41325();
        this.fartAnimState.method_41325();
    }

    public void method_5674(class_2940<?> data) {
        if (STATE.equals(data)) {
            class_7094 animstate;
            State state = this.getState();
            this.stopAnimations();
            State state2 = state;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FALL_TO_SLEEP", "SLEEPING", "WAKE_UP", "FARTING"}, (State)state2, n)) {
                case 0: {
                    class_7094 class_70942 = this.fallToSleepAnimState;
                    break;
                }
                case 1: {
                    class_7094 class_70942 = this.sleepingAnimState;
                    break;
                }
                case 2: {
                    class_7094 class_70942 = this.wakeUpAnimState;
                    break;
                }
                case 3: {
                    class_7094 class_70942 = this.fartAnimState;
                    break;
                }
                default: {
                    class_7094 class_70942 = animstate = null;
                }
            }
            if (animstate != null) {
                animstate.method_41324(this.field_6012);
            }
        }
        super.method_5674(data);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasLargeEyes() {
        boolean surprisedByFart = this.isFarting() && this.getLastStateTickDelta() < 40L;
        return this.method_6109() || surprisedByFart;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasClosedEyes() {
        boolean aboutToStartToSleep = this.isFallingToSleep() && this.getLastStateTickDelta() > 31L;
        boolean shakingHead = this.isFarting() && 40L < this.getLastStateTickDelta() && this.getLastStateTickDelta() < 65L;
        boolean wakingUp = this.isWakingUp() && (this.getLastStateTickDelta() < 5L || 18L < this.getLastStateTickDelta() && this.getLastStateTickDelta() < 34L);
        return aboutToStartToSleep || this.isAsleep() || shakingHead || wakingUp;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canAngleHead() {
        return !this.isFarting() && !this.isAsleep() && !this.isFallingToSleep() && !this.isWakingUp();
    }

    @Environment(value=EnvType.CLIENT)
    public float getEarWiggleSpeed() {
        return this.isAsleep() ? 0.3f : 1.0f;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.isFallingToSleep() || this.isAsleep() || this.isWakingUp() || this.isFarting()) {
            return null;
        }
        if (this.method_6109()) {
            return PromenadeSoundEvents.CAPYBARA_AMBIENT_BABY;
        }
        return PromenadeSoundEvents.CAPYBARA_AMBIENT;
    }

    public int method_5970() {
        return this.method_6109() ? 20 : super.method_5970();
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        CapybaraEntity capyBaby = (CapybaraEntity)PromenadeEntityTypes.CAPYBARA.method_5883(this.method_37908(), class_3730.field_16466);
        if (capyBaby != null && entity instanceof CapybaraEntity) {
            CapybaraEntity capyMama = (CapybaraEntity)entity;
            capyBaby.setVariant(this.field_5974.method_43056() ? this.getVariant() : capyMama.getVariant());
        }
        return capyBaby;
    }

    public class_6880<CapybaraVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(class_6880<CapybaraVariant> variant) {
        this.field_6011.method_12778(VARIANT, variant);
    }

    public float getFartChance() {
        return ((Float)this.field_6011.method_12789(FART_CHANCE)).floatValue();
    }

    public void setFartChance(float frequency) {
        this.field_6011.method_12778(FART_CHANCE, (Object)Float.valueOf(frequency));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)class_10704.method_67175((class_5455)this.method_56673(), CapybaraVariants.DEFAULT));
        builder.method_56912(FART_CHANCE, (Object)Float.valueOf(0.0f));
        builder.method_56912(STATE, (Object)State.IDLING);
        builder.method_56912(LAST_STATE_TICK, (Object)-115L);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        class_10704.method_67177((class_11372)view, this.getVariant());
        view.method_71464(FART_CHANCE_KEY, this.getFartChance());
        view.method_71469(STATE_KEY, this.getState().method_15434());
        view.method_71466(LAST_STATE_TICK_KEY, ((Long)this.field_6011.method_12789(LAST_STATE_TICK)).longValue());
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        class_10704.method_67178((class_11368)view, PromenadeRegistryKeys.CAPYBARA_VARIANT).ifPresent(this::setVariant);
        view.method_71441(STATE_KEY).ifPresent(s -> this.setState(State.fromName(s)));
        view.method_71440(LAST_STATE_TICK_KEY).ifPresent(this::setLastStateTick);
        this.setFartChance(view.method_71423(FART_CHANCE_KEY, FART_CHANCE_PROVIDER.method_33915()));
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> type) {
        return (T)(type == PromenadeComponentTypes.CAPYBARA_VARIANT ? CapybaraEntity.method_66651(type, this.getVariant()) : super.method_58694(type));
    }

    protected void method_66649(class_9473 from) {
        this.method_66650(from, PromenadeComponentTypes.CAPYBARA_VARIANT);
        super.method_66649(from);
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (type == PromenadeComponentTypes.CAPYBARA_VARIANT) {
            this.setVariant((class_6880<CapybaraVariant>)((class_6880)CapybaraEntity.method_66651(PromenadeComponentTypes.CAPYBARA_VARIANT, value)));
            return true;
        }
        return super.method_66654(type, value);
    }

    class CapybaraBodyControl
    extends class_1330 {
        public CapybaraBodyControl(CapybaraEntity capybara) {
            super((class_1308)capybara);
        }

        public void method_6224() {
            if (!CapybaraEntity.this.isStationary()) {
                super.method_6224();
            }
        }
    }

    public static enum State implements class_3542
    {
        IDLING("idling", 0),
        FARTING("farting", 1),
        SLEEPING("sleeping", 2),
        FALL_TO_SLEEP("fall_to_sleep", 3),
        WAKE_UP("wake_up", 4);

        private final String name;
        private final int index;
        private static final class_3542.class_7292<State> CODEC;
        private static final IntFunction<State> INDEX_TO_VALUE;
        public static final class_9139<ByteBuf, State> PACKET_CODEC;

        private State(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public static State fromName(String name) {
            return (State)CODEC.method_47920(name, (Enum)IDLING);
        }

        public String method_15434() {
            return this.name;
        }

        private int getIndex() {
            return this.index;
        }

        static {
            CODEC = class_3542.method_28140(State::values);
            INDEX_TO_VALUE = class_7995.method_47914(State::getIndex, (Object[])State.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, State::getIndex);
        }
    }
}

