/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag.component;

import java.util.function.Supplier;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public interface DraggableComponentProvider<T extends class_437, A>
extends Comparable<DraggableComponentProvider<T, A>> {
    public static <T extends class_437, A> DraggableComponentProvider<T, A> from(final Supplier<? extends Iterable<? extends DraggableComponentProvider<T, A>>> providers) {
        return new DraggableComponentProvider<T, A>(){

            @Override
            public <R extends class_437> boolean isHandingScreen(R screen) {
                for (DraggableComponentProvider provider : (Iterable)providers.get()) {
                    if (!provider.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public DraggableComponent<A> getHovered(DraggingContext<T> context, double mouseX, double mouseY) {
                for (DraggableComponentProvider provider : (Iterable)providers.get()) {
                    DraggableComponent component;
                    if (!provider.isHandingScreen(context.getScreen()) || (component = provider.getHovered(context, mouseX, mouseY)) == null) continue;
                    return component;
                }
                return null;
            }
        };
    }

    @Nullable
    public DraggableComponent<A> getHovered(DraggingContext<T> var1, double var2, double var4);

    public <R extends class_437> boolean isHandingScreen(R var1);

    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableComponentProvider<T, A> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }
}

