/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.blockenchants;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public final class BlockEnchantData {
    public final Map<class_2960, Integer> levels = new HashMap<class_2960, Integer>();
    public static final Codec<BlockEnchantData> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.INT).xmap(m -> {
        BlockEnchantData d = new BlockEnchantData();
        m.forEach((id, l) -> {
            if (l > 0) {
                d.levels.put((class_2960)id, (Integer)l);
            }
        });
        return d;
    }, d -> d.levels);

    public boolean isEmpty() {
        return this.levels.isEmpty();
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (Map.Entry<class_2960, Integer> e : this.levels.entrySet()) {
            class_2487 c = new class_2487();
            c.method_10582("id", e.getKey().toString());
            c.method_10569("lvl", e.getValue().intValue());
            list.add((Object)c);
        }
        tag.method_10566("list", (class_2520)list);
        return tag;
    }

    public class_2487 toNbt(class_7225.class_7874 lookup) {
        return this.toNbt();
    }

    public static BlockEnchantData fromItem(class_3218 world, class_1799 stack) {
        BlockEnchantData d = new BlockEnchantData();
        class_9304 comp = class_1890.method_57532((class_1799)stack);
        if (comp == null) {
            return d;
        }
        class_2378 enchReg = world.method_30349().method_30530(class_7924.field_41265);
        Set entries = comp.method_57539();
        if (entries.isEmpty()) {
            return d;
        }
        for (Object2IntMap.Entry e : entries) {
            class_1887 ench = (class_1887)((class_6880)e.getKey()).comp_349();
            class_2960 id = enchReg.method_10221((Object)ench);
            int lvl = e.getIntValue();
            if (id == null || lvl <= 0) continue;
            d.levels.put(id, lvl);
        }
        return d;
    }

    public void applyToItem(class_3218 world, class_1799 stack) {
        if (this.isEmpty()) {
            return;
        }
        class_9304 current = class_1890.method_57532((class_1799)stack);
        class_9304.class_9305 builder = new class_9304.class_9305(current != null ? current : class_9304.field_49385);
        class_2378 enchReg = world.method_30349().method_30530(class_7924.field_41265);
        for (Map.Entry<class_2960, Integer> e : this.levels.entrySet()) {
            class_1887 ench;
            class_2960 id = e.getKey();
            int targetLvl = e.getValue();
            if (targetLvl <= 0 || (ench = (class_1887)enchReg.method_63535(id)) == null) continue;
            class_6880 entry = enchReg.method_47983((Object)ench);
            int currentLvl = current == null ? 0 : current.method_57536(entry);
            if (currentLvl >= targetLvl) continue;
            builder.method_57547(entry, targetLvl);
        }
        stack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
    }

    public static BlockEnchantData fromNbt(class_2487 tag) {
        BlockEnchantData d = new BlockEnchantData();
        Optional listOpt = tag.method_10554("list");
        if (listOpt.isEmpty()) {
            return d;
        }
        class_2499 list = (class_2499)listOpt.get();
        for (int i = 0; i < list.size(); ++i) {
            Optional cOpt = list.method_10602(i);
            if (cOpt.isEmpty()) continue;
            class_2487 c = (class_2487)cOpt.get();
            Optional idOpt = c.method_10558("id");
            Optional lvlOpt = c.method_10550("lvl");
            if (idOpt.isEmpty()) continue;
            String idStr = (String)idOpt.get();
            int lvl = lvlOpt.orElse(0);
            class_2960 id = class_2960.method_12829((String)idStr);
            if (id == null || lvl <= 0) continue;
            d.levels.put(id, lvl);
        }
        return d;
    }
}

