/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.hugman.promenade.Promenade;
import fr.hugman.promenade.world.biome.PromenadeBiomes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.minecraft.class_6544;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public record PromenadeConfig(BiomesConfig biomes, WorldFeaturesConfig worldFeatures, AnimalsConfig animals, MonstersConfig monsters) {
    private static final Path PATH = Paths.get("config/promenade.json", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Codec<PromenadeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomesConfig.CODEC.fieldOf("biomes").forGetter(PromenadeConfig::biomes), (App)WorldFeaturesConfig.CODEC.fieldOf("world_features").forGetter(PromenadeConfig::worldFeatures), (App)AnimalsConfig.CODEC.fieldOf("animals").forGetter(PromenadeConfig::animals), (App)MonstersConfig.CODEC.fieldOf("monsters").forGetter(PromenadeConfig::monsters)).apply((Applicative)instance, PromenadeConfig::new));
    private static PromenadeConfig instance;

    private PromenadeConfig() {
        this(new BiomesConfig(20, 20, 10, Optional.of(PromenadeBiomes.DEFAULT_DARK_AMARANTH_FOREST_HYPERCUBE)), new WorldFeaturesConfig(true, true, true), new AnimalsConfig(10, 10), new MonstersConfig(15, 10));
    }

    @NotNull
    public static PromenadeConfig get() {
        if (instance == null) {
            instance = PromenadeConfig.initializeConfig();
        }
        return instance;
    }

    private static PromenadeConfig initializeConfig() {
        if (Files.exists(PATH, new LinkOption[0])) {
            return PromenadeConfig.loadConfig();
        }
        return PromenadeConfig.createDefaultConfig();
    }

    private static PromenadeConfig loadConfig() {
        PromenadeConfig promenadeConfig;
        block8: {
            InputStream input = Files.newInputStream(PATH, new OpenOption[0]);
            try {
                JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(input));
                DataResult result = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst);
                promenadeConfig = result.result().orElseGet(PromenadeConfig::new);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Promenade.LOGGER.warn("Failed to load Promenade config", (Throwable)e);
                    return new PromenadeConfig();
                }
            }
            input.close();
        }
        return promenadeConfig;
    }

    private static PromenadeConfig createDefaultConfig() {
        PromenadeConfig config = new PromenadeConfig();
        try (OutputStream output = Files.newOutputStream(PATH, new OpenOption[0]);){
            Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).result();
            if (result.isPresent()) {
                JsonElement json = (JsonElement)result.get();
                IOUtils.write((String)GSON.toJson(json), (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            Promenade.LOGGER.warn("Failed to create default Promenade config", (Throwable)e);
        }
        return config;
    }

    public record BiomesConfig(int carnelianTreewayWeight, int sakuraGrovesWeight, int glacarianTaigaWeight, Optional<class_6544.class_4762> darkAmaranthForestsNoise) {
        private static final Codec<BiomesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("carnelian_treeway_weight", (Object)20).forGetter(BiomesConfig::carnelianTreewayWeight), (App)Codec.INT.optionalFieldOf("sakura_groves_weight", (Object)20).forGetter(BiomesConfig::sakuraGrovesWeight), (App)Codec.INT.optionalFieldOf("glacarian_taiga_weight", (Object)10).forGetter(BiomesConfig::glacarianTaigaWeight), (App)class_6544.class_4762.field_24679.optionalFieldOf("dark_amaranth_forests_noise").forGetter(BiomesConfig::darkAmaranthForestsNoise)).apply((Applicative)instance, BiomesConfig::new));
    }

    public record WorldFeaturesConfig(boolean igneousRockPatches, boolean blueberryBushes, boolean palms) {
        private static final Codec<WorldFeaturesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("igneous_rock_patches", (Object)true).forGetter(WorldFeaturesConfig::igneousRockPatches), (App)Codec.BOOL.optionalFieldOf("blueberry_bushes", (Object)true).forGetter(WorldFeaturesConfig::blueberryBushes), (App)Codec.BOOL.optionalFieldOf("palms", (Object)true).forGetter(WorldFeaturesConfig::palms)).apply((Applicative)instance, WorldFeaturesConfig::new));
    }

    public record AnimalsConfig(int capybarasWeight, int ducksWeight) {
        private static final Codec<AnimalsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("capybaras_weight", (Object)10).forGetter(AnimalsConfig::capybarasWeight), (App)Codec.INT.optionalFieldOf("ducks_weight", (Object)10).forGetter(AnimalsConfig::ducksWeight)).apply((Applicative)instance, AnimalsConfig::new));
    }

    public record MonstersConfig(int lushCreepersWeight, int sunkensWeight) {
        private static final Codec<MonstersConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("lush_creepers_weight", (Object)15).forGetter(MonstersConfig::lushCreepersWeight), (App)Codec.INT.optionalFieldOf("sunkens_weight", (Object)10).forGetter(MonstersConfig::sunkensWeight)).apply((Applicative)instance, MonstersConfig::new));
    }
}

