/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.waterwheel;

import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.content.kinetics.waterwheel.WaterWheelRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBuilder;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10801;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public class WaterWheelVisual<T extends WaterWheelBlockEntity>
extends KineticBlockEntityVisual<T> {
    private static final RendererReloadCache<ModelKey, Model> MODEL_CACHE = new RendererReloadCache<ModelKey, Model>(WaterWheelVisual::createModel);
    protected final boolean large;
    protected class_2680 lastMaterial;
    protected RotatingInstance rotatingModel;

    public WaterWheelVisual(VisualizationContext context, T blockEntity, boolean large, float partialTick) {
        super(context, blockEntity, partialTick);
        this.large = large;
        this.setupInstance();
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelVisual<T> standard(VisualizationContext context, T blockEntity, float partialTick) {
        return new WaterWheelVisual<T>(context, blockEntity, false, partialTick);
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelVisual<T> large(VisualizationContext context, T blockEntity, float partialTick) {
        return new WaterWheelVisual<T>(context, blockEntity, true, partialTick);
    }

    private void setupInstance() {
        this.lastMaterial = ((WaterWheelBlockEntity)this.blockEntity).material;
        this.rotatingModel = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, MODEL_CACHE.get(new ModelKey(WaterWheelRenderer.Variant.of(this.large, this.blockState), ((WaterWheelBlockEntity)this.blockEntity).material))).createInstance();
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setPosition((class_2382)this.getVisualPosition()).rotateToFace(this.rotationAxis()).setChanged();
    }

    @Override
    public void update(float pt) {
        if (this.lastMaterial != ((WaterWheelBlockEntity)this.blockEntity).material) {
            this.rotatingModel.delete();
            this.setupInstance();
        } else {
            this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.rotatingModel);
    }

    @Override
    protected void _delete() {
        this.rotatingModel.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.rotatingModel);
    }

    private static Model createModel(ModelKey key) {
        class_10801 model = WaterWheelRenderer.generateModel(key.variant(), key.material());
        return new BakedModelBuilder(model).build();
    }

    @Environment(value=EnvType.CLIENT)
    public record ModelKey(WaterWheelRenderer.Variant variant, class_2680 material) {
    }
}

