/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.IGuiParent;

public class GuiTextfield
extends GuiControl {
    public GuiTextfield(IGuiParent parent, String name) {
        super(parent, name);
        this.setTextSilent("");
    }

    public GuiTextfield(IGuiParent parent, String name, String text) {
        super(parent, name);
        this.setTextSilent(text);
    }

    public GuiTextfield(IGuiParent parent, String name, String text, int maxStringLength) {
        super(parent, name);
        if (this.dist() != null) {
            this.dist().setMaxStringLength(maxStringLength);
        }
        this.setTextSilent(text);
    }

    @Override
    public GuiTextfieldDist dist() {
        return (GuiTextfieldDist)super.dist();
    }

    @Override
    public GuiTextfield setDim(int width, int height) {
        return (GuiTextfield)super.setDim(width, height);
    }

    public GuiTextfield setDim(int width) {
        return (GuiTextfield)super.setDim(width, 10);
    }

    public GuiTextfield setFloatOnly() {
        if (this.dist() != null) {
            this.dist().setFloatOnly();
        }
        return this;
    }

    public GuiTextfield setNumbersIncludingNegativeOnly() {
        if (this.dist() != null) {
            this.dist().setNumbersIncludingNegativeOnly();
        }
        return this;
    }

    public GuiTextfield setNumbersOnly() {
        if (this.dist() != null) {
            this.dist().setNumbersOnly();
        }
        return this;
    }

    public float parseFloat() {
        try {
            if (this.dist() != null) {
                return Float.parseFloat(this.dist().getText());
            }
            return 0.0f;
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public double parseDouble() {
        try {
            if (this.dist() != null) {
                return Double.parseDouble(this.dist().getText());
            }
            return 0.0;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public int parseInteger() {
        try {
            if (this.dist() != null) {
                return Integer.parseInt(this.dist().getText());
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
        if (this.dist() != null) {
            this.dist().tick();
        }
    }

    protected void setTextSilent(String textIn) {
        if (this.dist() != null) {
            this.dist().setText(textIn, false);
        }
    }

    public GuiTextfield setText(String textIn) {
        if (this.dist() != null) {
            this.dist().setText(textIn, true);
        }
        return this;
    }

    public String getText() {
        if (this.dist() != null) {
            return this.dist().getText();
        }
        return "";
    }

    public void setValidator(Predicate<String> validatorIn) {
        if (this.dist() != null) {
            this.dist().setValidator(validatorIn);
        }
    }

    public GuiTextfield setMaxStringLength(int length) {
        if (this.dist() != null) {
            this.dist().setMaxStringLength(length);
        }
        return this;
    }

    public GuiTextfield setSuggestion(@Nullable String suggestion) {
        if (this.dist() != null) {
            this.dist().setSuggestion(suggestion);
        }
        return this;
    }

    public void setCursorPositionZero() {
        if (this.dist() != null) {
            this.dist().setCursorPositionZero();
        }
    }

    public static interface GuiTextfieldDist
    extends GuiControl.GuiFocusControlDist {
        public void setFloatOnly();

        public void setNumbersIncludingNegativeOnly();

        public void setNumbersOnly();

        public void tick();

        public void setText(String var1, boolean var2);

        public String getText();

        public void setValidator(Predicate<String> var1);

        public void setSuggestion(@Nullable String var1);

        public void setMaxStringLength(int var1);

        public void setCursorPositionZero();
    }
}

