/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class YRangeCondition
implements Condition {
    public static final Codec<YRangeCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)YRange.CODEC.listOf().fieldOf("y_range_is").forGetter(yRangeCondition -> yRangeCondition.yRanges), (App)class_2338.field_25064.optionalFieldOf("offset", (Object)class_2338.field_10980).forGetter(yRangeCondition -> yRangeCondition.offset)).apply((Applicative)builder, YRangeCondition::new));
    private final List<YRange> yRanges;
    private final class_2338 offset;

    public YRangeCondition(List<YRange> yRanges, class_2338 offset) {
        this.yRanges = yRanges;
        this.offset = offset;
        if (yRanges.isEmpty()) {
            throw new IllegalArgumentException("No yRanges were specified.");
        }
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        for (YRange yRange : this.yRanges) {
            if (yRange.isInBetween(conditionContext.entity().method_24515().method_10081((class_2382)this.offset).method_10264())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }

    public static class YRange {
        public static Codec<YRange> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("minY").forGetter(yRange -> yRange.minY), (App)Codec.INT.fieldOf("maxY").forGetter(yRange -> yRange.maxY)).apply((Applicative)builder, YRange::new));
        private final int minY;
        private final int maxY;

        public YRange(int minY, int maxY) {
            this.minY = minY;
            this.maxY = maxY;
            if (minY > maxY) {
                throw new IllegalArgumentException("minY cannot be greater than maxY");
            }
        }

        public boolean isInBetween(int y) {
            return y >= this.minY && y <= this.maxY;
        }
    }
}

