/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import java.util.Arrays;
import net.minecraft.class_10017;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class MutantEndermanModel
extends class_583<MutantEndermanRenderState> {
    private final class_630 pelvis;
    private final class_630 abdomen;
    private final class_630 chest;
    private final class_630 neck;
    private final class_630 head;
    private final class_630 mouth;
    private final Arm rightArm;
    private final Arm leftArm;
    private final Arm lowerRightArm;
    private final Arm lowerLeftArm;
    private final class_630 legJoint1;
    private final class_630 legJoint2;
    private final class_630 leg1;
    private final class_630 leg2;
    private final class_630 foreLeg1;
    private final class_630 foreLeg2;

    public MutantEndermanModel(class_630 modelPart) {
        super(modelPart);
        this.pelvis = modelPart.method_32086("pelvis");
        this.abdomen = this.pelvis.method_32086("abdomen");
        this.chest = this.abdomen.method_32086("chest");
        this.neck = this.chest.method_32086("neck");
        this.head = this.neck.method_32086("head");
        this.mouth = this.head.method_32086("mouth");
        this.rightArm = new Arm("right_", this.chest, true);
        this.leftArm = new Arm("left_", this.chest, false);
        this.lowerRightArm = new Arm("lower_right_", this.chest, true);
        this.lowerLeftArm = new Arm("lower_left_", this.chest, false);
        this.legJoint1 = this.abdomen.method_32086("leg_joint1");
        this.legJoint2 = this.abdomen.method_32086("leg_joint2");
        this.leg1 = this.legJoint1.method_32086("leg1");
        this.leg2 = this.legJoint2.method_32086("leg2");
        this.foreLeg1 = this.leg1.method_32086("fore_leg1");
        this.foreLeg2 = this.leg2.method_32086("fore_leg2");
    }

    public static class_5607 createBodyLayer() {
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        class_5610 pelvis = root.method_32117("pelvis", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)0.0f, (float)-15.5f, (float)8.0f));
        class_5610 abdomen = pelvis.method_32117("abdomen", class_5606.method_32108().method_32101(32, 0).method_32097(-4.0f, -10.0f, -2.0f, 8.0f, 10.0f, 4.0f), class_5603.field_27701);
        class_5610 chest = abdomen.method_32117("chest", class_5606.method_32108().method_32101(50, 8).method_32097(-5.0f, -16.0f, -3.0f, 10.0f, 16.0f, 6.0f), class_5603.method_32090((float)0.0f, (float)-8.0f, (float)0.0f));
        class_5610 neck = chest.method_32117("neck", class_5606.method_32108().method_32101(32, 14).method_32097(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), class_5603.method_32090((float)0.0f, (float)-15.0f, (float)0.0f));
        class_5610 head = neck.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -4.0f, -8.0f, 8.0f, 6.0f, 8.0f, new class_5605(0.5f)).method_32101(0, 14).method_32098(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f, new class_5605(0.5f)), class_5603.method_32090((float)0.0f, (float)-5.0f, (float)3.0f));
        head.method_32117("mouth", class_5606.method_32108().method_32101(0, 24).method_32097(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f), class_5603.field_27701);
        Arm.createArmLayer("right_", chest, true, false);
        Arm.createArmLayer("left_", chest, false, false);
        Arm.createArmLayer("lower_right_", chest, true, true);
        Arm.createArmLayer("lower_left_", chest, false, true);
        class_5610 legJoint1 = abdomen.method_32117("leg_joint1", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)-1.5f, (float)0.0f, (float)0.75f));
        class_5610 legJoint2 = abdomen.method_32117("leg_joint2", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)1.5f, (float)0.0f, (float)0.75f));
        class_5610 leg1 = legJoint1.method_32117("leg1", class_5606.method_32108().method_32101(0, 34).method_32098(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new class_5605(0.5f)), class_5603.method_32090((float)0.0f, (float)-2.0f, (float)0.0f));
        class_5610 leg2 = legJoint2.method_32117("leg2", class_5606.method_32108().method_32101(0, 34).method_32096().method_32098(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new class_5605(0.5f)), class_5603.method_32090((float)0.0f, (float)-2.0f, (float)0.0f));
        leg1.method_32117("fore_leg1", class_5606.method_32108().method_32101(12, 34).method_32098(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new class_5605(0.5f)), class_5603.method_32090((float)0.0f, (float)23.0f, (float)0.0f));
        leg2.method_32117("fore_leg2", class_5606.method_32108().method_32101(12, 34).method_32096().method_32098(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new class_5605(0.5f)), class_5603.method_32090((float)0.0f, (float)23.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)mesh, (int)128, (int)64);
    }

    public void setupAnim(MutantEndermanRenderState renderState) {
        super.method_2819((class_10017)renderState);
        this.setupInitialAngles();
        float limbSwing = renderState.field_53450;
        float limbSwingAmount = renderState.field_53451;
        float ageInTicks = renderState.field_53328;
        float netHeadYaw = renderState.field_53447;
        float headPitch = renderState.field_53448;
        this.animate(renderState, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        Animator.setScale(this.lowerRightArm.arm, renderState.armScale);
        Animator.setScale(this.lowerLeftArm.arm, renderState.armScale);
    }

    private void setupInitialAngles() {
        this.pelvis.field_3656 = -15.5f;
        this.abdomen.field_3654 = 0.31415927f;
        this.chest.field_3654 = 0.3926991f;
        this.chest.field_3675 = 0.0f;
        this.chest.field_3674 = 0.0f;
        this.neck.field_3654 = 0.19634955f;
        this.neck.field_3674 = 0.0f;
        this.head.field_3654 = -0.7853982f;
        this.head.field_3675 = 0.0f;
        this.head.field_3674 = 0.0f;
        this.mouth.field_3654 = 0.0f;
        this.rightArm.setAngles();
        this.leftArm.setAngles();
        this.lowerRightArm.setAngles();
        this.lowerRightArm.arm.field_3654 += 0.1f;
        this.lowerRightArm.arm.field_3674 -= 0.2f;
        this.lowerLeftArm.setAngles();
        this.lowerLeftArm.arm.field_3654 += 0.1f;
        this.lowerLeftArm.arm.field_3674 += 0.2f;
        this.legJoint1.field_3654 = 0.0f;
        this.legJoint2.field_3654 = 0.0f;
        this.leg1.field_3654 = -0.8975979f;
        this.leg1.field_3675 = 0.0f;
        this.leg1.field_3674 = 0.2617994f;
        this.leg2.field_3654 = -0.8975979f;
        this.leg2.field_3675 = 0.0f;
        this.leg2.field_3674 = -0.2617994f;
        this.foreLeg1.field_3654 = 0.7853982f;
        this.foreLeg1.field_3674 = -0.1308997f;
        this.foreLeg2.field_3654 = 0.7853982f;
        this.foreLeg2.field_3674 = 0.1308997f;
    }

    private void animate(MutantEndermanRenderState renderState, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkSpeed = 0.3f;
        float walkAnim1 = (class_3532.method_15374((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float walkAnim2 = -(class_3532.method_15374((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim3 = (class_3532.method_15374((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim4 = -(class_3532.method_15374((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float[] walkAnim = new float[5];
        Arrays.fill(walkAnim, class_3532.method_15374((float)(limbSwing * walkSpeed)) * limbSwingAmount);
        float breatheAnim = class_3532.method_15374((float)(ageInTicks * 0.15f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        for (int i = 0; i < 4; ++i) {
            if (renderState.heldBlocks[i] == null) continue;
            this.animateHoldBlock(renderState, i);
            int n = i;
            walkAnim[n] = walkAnim[n] * 0.4f;
        }
        if (renderState.animation == MutantEnderman.MELEE_ANIMATION) {
            this.animateMelee(renderState, renderState.activeArm);
            walkAnim[renderState.activeArm] = 0.0f;
        }
        if (renderState.animation == MutantEnderman.THROW_ANIMATION) {
            this.animateThrowBlock(renderState, renderState.activeArm);
        }
        if (renderState.animation == MutantEnderman.SCREAM_ANIMATION) {
            this.animateScream(renderState);
            float scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        if (renderState.animation == MutantEnderman.TELESMASH_ANIMATION) {
            this.animateTeleSmash(renderState);
        }
        if (renderState.animation == MutantEnderman.DEATH_ANIMATION) {
            this.animateDeath(renderState);
            float scale = 1.0f - class_3532.method_15363((float)(renderState.field_53449 / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        this.head.field_3654 += facePitch * 0.5f;
        this.head.field_3675 += faceYaw * 0.7f;
        this.head.field_3674 -= faceYaw * 0.7f;
        this.neck.field_3654 += facePitch * 0.3f;
        this.chest.field_3654 += facePitch * 0.2f;
        this.mouth.field_3654 += breatheAnim * 0.02f + 0.02f;
        this.neck.field_3654 -= breatheAnim * 0.02f;
        this.rightArm.arm.field_3674 += breatheAnim * 0.004f;
        this.leftArm.arm.field_3674 -= breatheAnim * 0.004f;
        for (class_630 modelPart : this.rightArm.finger) {
            modelPart.field_3674 += breatheAnim * 0.05f;
        }
        this.rightArm.thumb.field_3674 -= breatheAnim * 0.05f;
        for (class_630 modelPart : this.leftArm.finger) {
            modelPart.field_3674 -= breatheAnim * 0.05f;
        }
        this.leftArm.thumb.field_3674 += breatheAnim * 0.05f;
        this.lowerRightArm.arm.field_3674 += breatheAnim * 0.002f;
        this.lowerLeftArm.arm.field_3674 -= breatheAnim * 0.002f;
        for (class_630 modelPart : this.lowerRightArm.finger) {
            modelPart.field_3674 += breatheAnim * 0.02f;
        }
        this.lowerRightArm.thumb.field_3674 -= breatheAnim * 0.02f;
        for (class_630 modelPart : this.lowerLeftArm.finger) {
            modelPart.field_3674 -= breatheAnim * 0.02f;
        }
        this.lowerLeftArm.thumb.field_3674 += breatheAnim * 0.02f;
        this.pelvis.field_3656 -= Math.abs(walkAnim[4]);
        this.chest.field_3675 -= walkAnim[4] * 0.06f;
        this.rightArm.arm.field_3654 -= walkAnim[0] * 0.6f;
        this.leftArm.arm.field_3654 += walkAnim[1] * 0.6f;
        this.rightArm.foreArm.field_3654 -= walkAnim[0] * 0.2f;
        this.leftArm.foreArm.field_3654 += walkAnim[1] * 0.2f;
        this.lowerRightArm.arm.field_3654 -= walkAnim[2] * 0.3f;
        this.lowerLeftArm.arm.field_3654 += walkAnim[3] * 0.3f;
        this.lowerRightArm.foreArm.field_3654 -= walkAnim[2] * 0.1f;
        this.lowerLeftArm.foreArm.field_3654 += walkAnim[3] * 0.1f;
        this.legJoint1.field_3654 += walkAnim1 * 0.6f;
        this.legJoint2.field_3654 += walkAnim2 * 0.6f;
        this.foreLeg1.field_3654 += walkAnim3 * 0.3f;
        this.foreLeg2.field_3654 += walkAnim4 * 0.3f;
    }

    private void animateHoldBlock(MutantEndermanRenderState renderState, int armId) {
        float animationProgress = renderState.heldBlockTicks[armId] / 10.0f;
        float rotationAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
        if (armId == 0) {
            this.rightArm.arm.field_3674 += rotationAmount * 0.8f;
            this.rightArm.foreArm.field_3674 += rotationAmount * 0.6f;
            this.rightArm.hand.field_3675 += rotationAmount * 0.8f;
            this.rightArm.finger[0].field_3654 += -rotationAmount * 0.2f;
            this.rightArm.finger[2].field_3654 += rotationAmount * 0.2f;
            for (class_630 modelPart : this.rightArm.finger) {
                modelPart.field_3674 += rotationAmount * 0.6f;
            }
            this.rightArm.thumb.field_3674 += -rotationAmount * 0.4f;
        } else if (armId == 1) {
            this.leftArm.arm.field_3674 += -rotationAmount * 0.8f;
            this.leftArm.foreArm.field_3674 += -rotationAmount * 0.6f;
            this.leftArm.hand.field_3675 += -rotationAmount * 0.8f;
            this.leftArm.finger[0].field_3654 += -rotationAmount * 0.2f;
            this.leftArm.finger[2].field_3654 += rotationAmount * 0.2f;
            for (class_630 modelPart : this.leftArm.finger) {
                modelPart.field_3674 += -rotationAmount * 0.6f;
            }
            this.leftArm.thumb.field_3674 += rotationAmount * 0.4f;
        } else if (armId == 2) {
            this.lowerRightArm.arm.field_3674 += rotationAmount * 0.5f;
            this.lowerRightArm.foreArm.field_3674 += rotationAmount * 0.4f;
            this.lowerRightArm.hand.field_3675 += rotationAmount * 0.4f;
            this.lowerRightArm.finger[0].field_3654 += -rotationAmount * 0.2f;
            this.lowerRightArm.finger[2].field_3654 += rotationAmount * 0.2f;
            for (class_630 modelPart : this.lowerRightArm.finger) {
                modelPart.field_3674 += rotationAmount * 0.6f;
            }
            this.lowerRightArm.thumb.field_3674 += -rotationAmount * 0.4f;
        } else if (armId == 3) {
            this.lowerLeftArm.arm.field_3674 += -rotationAmount * 0.5f;
            this.lowerLeftArm.foreArm.field_3674 += -rotationAmount * 0.4f;
            this.lowerLeftArm.hand.field_3675 += -rotationAmount * 0.4f;
            this.lowerLeftArm.finger[0].field_3654 += -rotationAmount * 0.2f;
            this.lowerLeftArm.finger[2].field_3654 += rotationAmount * 0.2f;
            for (class_630 modelPart : this.lowerLeftArm.finger) {
                modelPart.field_3674 += -rotationAmount * 0.6f;
            }
            this.lowerLeftArm.thumb.field_3674 += rotationAmount * 0.4f;
        }
    }

    private void animateMelee(MutantEndermanRenderState renderState, int armId) {
        float isRightArm = (armId & 1) == 0 ? 1.0f : -1.0f;
        Arm arm = this.getArmFromId(armId);
        if (renderState.animationTime < 2.0f) {
            float animationProgress = renderState.animationTime / 2.0f;
            float rotationAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            arm.arm.field_3654 += rotationAmount * 0.2f;
            arm.finger[0].field_3674 += rotationAmount * 0.3f * isRightArm;
            arm.finger[1].field_3674 += rotationAmount * 0.3f * isRightArm;
            arm.finger[2].field_3674 += rotationAmount * 0.3f * isRightArm;
            arm.foreFinger[0].field_3674 += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[1].field_3674 += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[2].field_3674 += -rotationAmount * 0.5f * isRightArm;
        } else if (renderState.animationTime < 5.0f) {
            float animationProgress = (renderState.animationTime - 2.0f) / 3.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.field_3675 += -f1 * 0.1f * isRightArm;
            arm.arm.field_3654 += rotationAmount * 1.1f - 1.1f;
            arm.foreArm.field_3654 += -rotationAmount * 0.4f;
            arm.finger[0].field_3674 += 0.3f * isRightArm;
            arm.finger[1].field_3674 += 0.3f * isRightArm;
            arm.finger[2].field_3674 += 0.3f * isRightArm;
            arm.foreFinger[0].field_3674 += -0.5f * isRightArm;
            arm.foreFinger[1].field_3674 += -0.5f * isRightArm;
            arm.foreFinger[2].field_3674 += -0.5f * isRightArm;
        } else if (renderState.animationTime < 6.0f) {
            this.chest.field_3675 += -0.1f * isRightArm;
            arm.arm.field_3654 += -1.1f;
            arm.foreArm.field_3654 += -0.4f;
            arm.finger[0].field_3674 += 0.3f * isRightArm;
            arm.finger[1].field_3674 += 0.3f * isRightArm;
            arm.finger[2].field_3674 += 0.3f * isRightArm;
            arm.foreFinger[0].field_3674 += -0.5f * isRightArm;
            arm.foreFinger[1].field_3674 += -0.5f * isRightArm;
            arm.foreFinger[2].field_3674 += -0.5f * isRightArm;
        } else if (renderState.animationTime < 10.0f) {
            float animationProgress = (renderState.animationTime - 6.0f) / 4.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.field_3675 += -rotationAmount * 0.1f * isRightArm;
            arm.arm.field_3654 += -rotationAmount * 1.1f;
            arm.foreArm.field_3654 += -rotationAmount * 0.4f;
            arm.finger[0].field_3674 += rotationAmount * 0.3f * isRightArm;
            arm.finger[1].field_3674 += rotationAmount * 0.3f * isRightArm;
            arm.finger[2].field_3674 += rotationAmount * 0.3f * isRightArm;
            arm.foreFinger[0].field_3674 += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[1].field_3674 += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[2].field_3674 += -rotationAmount * 0.5f * isRightArm;
        }
    }

    private void animateThrowBlock(MutantEndermanRenderState renderState, int armId) {
        switch (armId) {
            case 0: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.rightArm.arm.field_3654 += -sinSwingAmount * 1.5f;
                    this.rightArm.arm.field_3674 += cosSwingAmount * 0.8f;
                    this.rightArm.foreArm.field_3674 += cosSwingAmount * 0.6f;
                    this.rightArm.hand.field_3675 += cosSwingAmount * 0.8f;
                    this.rightArm.finger[0].field_3654 += -cosSwingAmount * 0.2f;
                    this.rightArm.finger[2].field_3654 += cosSwingAmount * 0.2f;
                    for (class_630 finger : this.rightArm.finger) {
                        finger.field_3674 += cosSwingAmount * 0.6f;
                    }
                    this.rightArm.thumb.field_3674 += -cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.rightArm.arm.field_3654 += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                this.rightArm.arm.field_3654 += -cosSwingAmount * 1.5f;
                break;
            }
            case 1: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.leftArm.arm.field_3654 += -sinSwingAmount * 1.5f;
                    this.leftArm.arm.field_3674 += -cosSwingAmount * 0.8f;
                    this.leftArm.foreArm.field_3674 += -cosSwingAmount * 0.6f;
                    this.leftArm.hand.field_3675 += -cosSwingAmount * 0.8f;
                    this.leftArm.finger[0].field_3654 += -cosSwingAmount * 0.2f;
                    this.leftArm.finger[2].field_3654 += cosSwingAmount * 0.2f;
                    for (class_630 finger : this.leftArm.finger) {
                        finger.field_3674 += -cosSwingAmount * 0.6f;
                    }
                    this.leftArm.thumb.field_3674 += cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.leftArm.arm.field_3654 += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                this.leftArm.arm.field_3654 += -cosSwingAmount * 1.5f;
                break;
            }
            case 2: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.lowerRightArm.arm.field_3654 += -sinSwingAmount * 1.5f;
                    this.lowerRightArm.arm.field_3674 += cosSwingAmount * 0.5f;
                    this.lowerRightArm.foreArm.field_3674 += cosSwingAmount * 0.4f;
                    this.lowerRightArm.hand.field_3675 += cosSwingAmount * 0.4f;
                    this.lowerRightArm.finger[0].field_3654 += -cosSwingAmount * 0.2f;
                    this.lowerRightArm.finger[2].field_3654 += cosSwingAmount * 0.2f;
                    for (class_630 finger : this.lowerRightArm.finger) {
                        finger.field_3674 += cosSwingAmount * 0.6f;
                    }
                    this.lowerRightArm.thumb.field_3674 += -cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.lowerRightArm.arm.field_3654 += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.field_3654 += -cosSwingAmount * 1.5f;
                break;
            }
            case 3: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.lowerLeftArm.arm.field_3654 += -sinSwingAmount * 1.5f;
                    this.lowerLeftArm.arm.field_3674 += -cosSwingAmount * 0.5f;
                    this.lowerLeftArm.foreArm.field_3674 += -cosSwingAmount * 0.4f;
                    this.lowerLeftArm.hand.field_3675 += -cosSwingAmount * 0.4f;
                    this.lowerLeftArm.finger[0].field_3654 += -cosSwingAmount * 0.2f;
                    this.lowerLeftArm.finger[2].field_3654 += cosSwingAmount * 0.2f;
                    for (class_630 finger : this.lowerLeftArm.finger) {
                        finger.field_3674 += -cosSwingAmount * 0.6f;
                    }
                    this.lowerLeftArm.thumb.field_3674 += cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.lowerLeftArm.arm.field_3654 += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.field_3654 += -cosSwingAmount * 1.5f;
            }
        }
    }

    private void animateScream(MutantEndermanRenderState renderState) {
        if (renderState.animationTime < 35.0f) {
            int i;
            float animationProgress = renderState.animationTime / 35.0f;
            float rotationAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += rotationAmount * 0.3f;
            this.chest.field_3654 += rotationAmount * 0.4f;
            this.neck.field_3654 += rotationAmount * 0.2f;
            this.head.field_3654 += rotationAmount * 0.3f;
            this.rightArm.arm.field_3654 += -rotationAmount * 0.6f;
            this.rightArm.arm.field_3675 += rotationAmount * 0.4f;
            this.rightArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.rightArm.hand.field_3674 += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_3674 += rotationAmount * 0.3f;
                this.rightArm.foreFinger[i].field_3674 += -rotationAmount * 0.5f;
            }
            this.leftArm.arm.field_3654 += -rotationAmount * 0.6f;
            this.leftArm.arm.field_3675 += -rotationAmount * 0.4f;
            this.leftArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.leftArm.hand.field_3674 += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_3674 += -rotationAmount * 0.3f;
                this.leftArm.foreFinger[i].field_3674 += rotationAmount * 0.5f;
            }
            this.lowerRightArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.field_3675 += rotationAmount * 0.2f;
            this.lowerRightArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.lowerRightArm.hand.field_3674 += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_3674 += rotationAmount * 0.3f;
                this.lowerRightArm.foreFinger[i].field_3674 += -rotationAmount * 0.5f;
            }
            this.lowerLeftArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.lowerLeftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.lowerLeftArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.lowerLeftArm.hand.field_3674 += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_3674 += -rotationAmount * 0.3f;
                this.lowerLeftArm.foreFinger[i].field_3674 += rotationAmount * 0.5f;
            }
        } else if (renderState.animationTime < 40.0f) {
            int i;
            this.abdomen.field_3654 += 0.3f;
            this.chest.field_3654 += 0.4f;
            this.neck.field_3654 += 0.2f;
            this.head.field_3654 += 0.3f;
            this.rightArm.arm.field_3654 += -0.6f;
            this.rightArm.arm.field_3675 += 0.4f;
            this.rightArm.foreArm.field_3654 += -0.8f;
            this.rightArm.hand.field_3674 += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_3674 += 0.3f;
                this.rightArm.foreFinger[i].field_3674 += -0.5f;
            }
            this.leftArm.arm.field_3654 += -0.6f;
            this.leftArm.arm.field_3675 += -0.4f;
            this.leftArm.foreArm.field_3654 += -0.8f;
            this.leftArm.hand.field_3674 += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_3674 += -0.3f;
                this.leftArm.foreFinger[i].field_3674 += 0.5f;
            }
            this.lowerRightArm.arm.field_3654 += -0.4f;
            this.lowerRightArm.arm.field_3675 += 0.2f;
            this.lowerRightArm.foreArm.field_3654 += -0.8f;
            this.lowerRightArm.hand.field_3674 += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_3674 += 0.3f;
                this.lowerRightArm.foreFinger[i].field_3674 += -0.5f;
            }
            this.lowerLeftArm.arm.field_3654 += -0.4f;
            this.lowerLeftArm.arm.field_3675 += -0.2f;
            this.lowerLeftArm.foreArm.field_3654 += -0.8f;
            this.lowerLeftArm.hand.field_3674 += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_3674 += -0.3f;
                this.lowerLeftArm.foreFinger[i].field_3674 += 0.5f;
            }
        } else if (renderState.animationTime < 44.0f) {
            int i;
            float animationProgress = (renderState.animationTime - 40.0f) / 4.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += -rotationAmount * 0.1f + 0.4f;
            this.chest.field_3654 += rotationAmount * 0.1f + 0.3f;
            this.chest.field_3674 += f1 * 0.5f;
            this.neck.field_3654 += rotationAmount * 0.2f;
            this.neck.field_3674 += f1 * 0.2f;
            this.head.field_3654 += rotationAmount * 1.2f - 0.8f;
            this.head.field_3674 += f1 * 0.4f;
            this.mouth.field_3654 += f1 * 0.6f;
            this.rightArm.arm.field_3654 += -rotationAmount * 0.6f;
            this.rightArm.arm.field_3675 += 0.4f;
            this.rightArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.rightArm.hand.field_3674 += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_3674 += rotationAmount * 0.3f;
                this.rightArm.foreFinger[i].field_3674 += -rotationAmount * 0.5f;
            }
            this.leftArm.arm.field_3654 += -rotationAmount * 0.6f;
            this.leftArm.arm.field_3675 += -0.4f;
            this.leftArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.leftArm.hand.field_3674 += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_3674 += -rotationAmount * 0.3f;
                this.leftArm.foreFinger[i].field_3674 += rotationAmount * 0.5f;
            }
            this.lowerRightArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.field_3675 += -rotationAmount * 0.1f + 0.3f;
            this.lowerRightArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.lowerRightArm.hand.field_3674 += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_3674 += rotationAmount * 0.3f;
                this.lowerRightArm.foreFinger[i].field_3674 += -rotationAmount * 0.5f;
            }
            this.lowerLeftArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.lowerLeftArm.arm.field_3675 += rotationAmount * 0.1f - 0.3f;
            this.lowerLeftArm.foreArm.field_3654 += -rotationAmount * 0.8f;
            this.lowerLeftArm.hand.field_3674 += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_3674 += -rotationAmount * 0.3f;
                this.lowerLeftArm.foreFinger[i].field_3674 += rotationAmount * 0.5f;
            }
            this.leg1.field_3674 += f1 * 0.1f;
            this.leg2.field_3674 += -f1 * 0.1f;
        } else if (renderState.animationTime < 155.0f) {
            float animationProgress = (renderState.animationTime - 44.0f) / 111.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += 0.4f;
            this.chest.field_3654 += 0.3f;
            this.chest.field_3674 += rotationAmount - 0.5f;
            this.neck.field_3674 += rotationAmount * 0.4f - 0.2f;
            this.head.field_3654 += -0.8f;
            this.head.field_3674 += rotationAmount * 0.8f - 0.4f;
            this.mouth.field_3654 += 0.6f;
            this.rightArm.arm.field_3675 += 0.4f;
            this.leftArm.arm.field_3675 += -0.4f;
            this.lowerRightArm.arm.field_3675 += 0.3f;
            this.lowerLeftArm.arm.field_3675 += -0.3f;
            this.leg1.field_3674 += 0.1f;
            this.leg2.field_3674 += -0.1f;
        } else if (renderState.animationTime < 160.0f) {
            float animationProgress = (renderState.animationTime - 155.0f) / 5.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += rotationAmount * 0.4f;
            this.chest.field_3654 += rotationAmount * 0.3f;
            this.chest.field_3674 += -rotationAmount * 0.5f;
            this.neck.field_3674 += -rotationAmount * 0.2f;
            this.head.field_3654 += -rotationAmount * 0.8f;
            this.head.field_3674 += -rotationAmount * 0.4f;
            this.mouth.field_3654 += rotationAmount * 0.6f;
            this.rightArm.arm.field_3675 += rotationAmount * 0.4f;
            this.leftArm.arm.field_3675 += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.field_3675 += rotationAmount * 0.3f;
            this.lowerLeftArm.arm.field_3675 += -rotationAmount * 0.3f;
            this.leg1.field_3674 += rotationAmount * 0.1f;
            this.leg2.field_3674 += -rotationAmount * 0.1f;
        }
    }

    private void animateTeleSmash(MutantEndermanRenderState renderState) {
        if (renderState.animationTime < 18.0f) {
            float animationProgress = renderState.animationTime / 18.0f;
            float rotationAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.field_3654 += -rotationAmount * 0.3f;
            this.rightArm.arm.field_3675 += rotationAmount * 0.2f;
            this.rightArm.arm.field_3674 += rotationAmount * 0.8f;
            this.rightArm.hand.field_3675 += rotationAmount * 1.7f;
            this.leftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.leftArm.arm.field_3674 += -rotationAmount * 0.8f;
            this.leftArm.hand.field_3675 += -rotationAmount * 1.7f;
            this.lowerRightArm.arm.field_3675 += rotationAmount * 0.2f;
            this.lowerRightArm.arm.field_3674 += rotationAmount * 0.6f;
            this.lowerRightArm.hand.field_3675 += rotationAmount * 1.7f;
            this.lowerLeftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.lowerLeftArm.arm.field_3674 += -rotationAmount * 0.6f;
            this.lowerLeftArm.hand.field_3675 += -rotationAmount * 1.7f;
        } else if (renderState.animationTime < 20.0f) {
            float animationProgress = (renderState.animationTime - 18.0f) / 2.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.field_3654 += -rotationAmount * 0.3f;
            this.rightArm.arm.field_3654 += -f1 * 0.8f;
            this.rightArm.arm.field_3675 += 0.2f;
            this.rightArm.arm.field_3674 += 0.8f;
            this.rightArm.hand.field_3675 += 1.0f;
            this.leftArm.arm.field_3654 += -f1 * 0.8f;
            this.leftArm.arm.field_3675 += -0.2f;
            this.leftArm.arm.field_3674 += -0.8f;
            this.leftArm.hand.field_3675 += -1.7f;
            this.lowerRightArm.arm.field_3654 += -f1 * 0.9f;
            this.lowerRightArm.arm.field_3675 += 0.2f;
            this.lowerRightArm.arm.field_3674 += 0.6f;
            this.lowerRightArm.hand.field_3675 += 1.0f;
            this.lowerLeftArm.arm.field_3654 += -f1 * 0.9f;
            this.lowerLeftArm.arm.field_3675 += -0.2f;
            this.lowerLeftArm.arm.field_3674 += -0.6f;
            this.lowerLeftArm.hand.field_3675 += -1.7f;
        } else if (renderState.animationTime < 24.0f) {
            this.rightArm.arm.field_3654 += -0.8f;
            this.rightArm.arm.field_3675 += 0.2f;
            this.rightArm.arm.field_3674 += 0.8f;
            this.rightArm.hand.field_3675 += 1.0f;
            this.leftArm.arm.field_3654 += -0.8f;
            this.leftArm.arm.field_3675 += -0.2f;
            this.leftArm.arm.field_3674 += -0.8f;
            this.leftArm.hand.field_3675 += -1.7f;
            this.lowerRightArm.arm.field_3654 += -0.9f;
            this.lowerRightArm.arm.field_3675 += 0.2f;
            this.lowerRightArm.arm.field_3674 += 0.6f;
            this.lowerRightArm.hand.field_3675 += 1.0f;
            this.lowerLeftArm.arm.field_3654 += -0.9f;
            this.lowerLeftArm.arm.field_3675 += -0.2f;
            this.lowerLeftArm.arm.field_3674 += -0.6f;
            this.lowerLeftArm.hand.field_3675 += -1.7f;
        } else if (renderState.animationTime < 30.0f) {
            float animationProgress = (renderState.animationTime - 24.0f) / 6.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            this.rightArm.arm.field_3654 += -rotationAmount * 0.8f;
            this.rightArm.arm.field_3675 += rotationAmount * 0.2f;
            this.rightArm.arm.field_3674 += rotationAmount * 0.8f;
            this.rightArm.hand.field_3675 += rotationAmount * 1.7f;
            this.leftArm.arm.field_3654 += -rotationAmount * 0.8f;
            this.leftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.leftArm.arm.field_3674 += -rotationAmount * 0.8f;
            this.leftArm.hand.field_3675 += -rotationAmount * 1.7f;
            this.lowerRightArm.arm.field_3654 += -rotationAmount * 0.9f;
            this.lowerRightArm.arm.field_3675 += rotationAmount * 0.2f;
            this.lowerRightArm.arm.field_3674 += rotationAmount * 0.6f;
            this.lowerRightArm.hand.field_3675 += rotationAmount * 1.7f;
            this.lowerLeftArm.arm.field_3654 += -rotationAmount * 0.9f;
            this.lowerLeftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.lowerLeftArm.arm.field_3674 += -rotationAmount * 0.6f;
            this.lowerLeftArm.hand.field_3675 += -rotationAmount * 1.7f;
        }
    }

    private void animateDeath(MutantEndermanRenderState renderState) {
        if (renderState.field_53449 < 80.0f) {
            float animationProgress = renderState.field_53449 / 80.0f;
            float rotationAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.head.field_3654 += rotationAmount * 0.4f;
            this.neck.field_3654 += rotationAmount * 0.3f;
            this.pelvis.field_3656 += -rotationAmount * 12.0f;
            this.rightArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.rightArm.arm.field_3675 += rotationAmount * 0.4f;
            this.rightArm.arm.field_3674 += rotationAmount * 0.6f;
            this.rightArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.leftArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.leftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.leftArm.arm.field_3674 += -rotationAmount * 0.6f;
            this.leftArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.lowerRightArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.field_3675 += rotationAmount * 0.4f;
            this.lowerRightArm.arm.field_3674 += rotationAmount * 0.6f;
            this.lowerRightArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.lowerLeftArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.lowerLeftArm.arm.field_3675 += -rotationAmount * 0.2f;
            this.lowerLeftArm.arm.field_3674 += -rotationAmount * 0.6f;
            this.lowerLeftArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.leg1.field_3654 += -rotationAmount * 0.9f;
            this.leg1.field_3675 += rotationAmount * 0.3f;
            this.leg2.field_3654 += -rotationAmount * 0.9f;
            this.leg2.field_3675 += -rotationAmount * 0.3f;
            this.foreLeg1.field_3654 += rotationAmount * 1.6f;
            this.foreLeg2.field_3654 += rotationAmount * 1.6f;
        } else if (renderState.field_53449 < 84.0f) {
            float animationProgress = (renderState.field_53449 - 80.0f) / 4.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            this.head.field_3654 += rotationAmount * 0.4f;
            this.mouth.field_3654 += f1 * 0.6f;
            this.neck.field_3654 += rotationAmount * 0.4f - 0.1f;
            this.chest.field_3654 += -f1 * 0.8f;
            this.abdomen.field_3654 += -f1 * 0.2f;
            this.pelvis.field_3656 += -12.0f;
            this.rightArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.rightArm.arm.field_3675 += -rotationAmount * 1.4f + 1.8f;
            this.rightArm.arm.field_3674 += rotationAmount * 0.6f;
            this.rightArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.leftArm.arm.field_3654 += -rotationAmount * 0.4f;
            this.leftArm.arm.field_3675 += rotationAmount * 1.6f - 1.8f;
            this.leftArm.arm.field_3674 += -rotationAmount * 0.6f;
            this.leftArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.lowerRightArm.arm.field_3654 += -rotationAmount * 0.5f + 0.1f;
            this.lowerRightArm.arm.field_3675 += -rotationAmount * 1.1f + 1.5f;
            this.lowerRightArm.arm.field_3674 += rotationAmount * 0.6f;
            this.lowerRightArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.lowerLeftArm.arm.field_3654 += -rotationAmount * 0.5f + 0.1f;
            this.lowerLeftArm.arm.field_3675 += rotationAmount * 1.1f - 1.5f;
            this.lowerLeftArm.arm.field_3674 += -rotationAmount * 0.6f;
            this.lowerLeftArm.foreArm.field_3654 += -rotationAmount * 1.2f;
            this.leg1.field_3654 += -rotationAmount * 1.7f + 0.8f;
            this.leg1.field_3675 += rotationAmount * 0.3f;
            this.leg1.field_3674 += f1 * 0.2f;
            this.leg2.field_3654 += -rotationAmount * 1.7f + 0.8f;
            this.leg2.field_3675 += -rotationAmount * 0.3f;
            this.leg2.field_3674 += -f1 * 0.2f;
            this.foreLeg1.field_3654 += rotationAmount * 1.6f;
            this.foreLeg2.field_3654 += rotationAmount * 1.6f;
        } else {
            this.mouth.field_3654 += 0.6f;
            this.neck.field_3654 += -0.1f;
            this.chest.field_3654 += -0.8f;
            this.abdomen.field_3654 += -0.2f;
            this.pelvis.field_3656 += -12.0f;
            this.rightArm.arm.field_3675 += 1.0f;
            this.leftArm.arm.field_3675 += -1.8f;
            this.lowerRightArm.arm.field_3654 += 0.1f;
            this.lowerRightArm.arm.field_3675 += 1.0f;
            this.lowerLeftArm.arm.field_3654 += 0.1f;
            this.lowerLeftArm.arm.field_3675 += -1.5f;
            this.leg1.field_3654 += 0.8f;
            this.leg1.field_3674 += 0.2f;
            this.leg2.field_3654 += 0.8f;
            this.leg2.field_3674 += -0.2f;
        }
    }

    private Arm getArmFromId(int id) {
        return id == 0 ? this.rightArm : (id == 1 ? this.leftArm : (id == 2 ? this.lowerRightArm : this.lowerLeftArm));
    }

    public void translateRotateArm(class_4587 poseStack, int id) {
        this.pelvis.method_22703(poseStack);
        this.abdomen.method_22703(poseStack);
        this.chest.method_22703(poseStack);
        this.getArmFromId(id).translateRotate(poseStack);
    }

    static class Arm {
        private final class_630 arm;
        private final class_630 foreArm;
        private final class_630 hand;
        private final class_630[] finger = new class_630[3];
        private final class_630[] foreFinger = new class_630[3];
        private final class_630 thumb;
        private final boolean right;

        private Arm(String prefix, class_630 modelPart, boolean right) {
            this.right = right;
            this.arm = modelPart.method_32086(prefix + "arm");
            this.foreArm = this.arm.method_32086(prefix + "fore_arm");
            this.hand = this.foreArm.method_32086(prefix + "hand");
            for (int i = 0; i < 3; ++i) {
                this.finger[i] = this.hand.method_32086(prefix + "finger" + i);
                this.foreFinger[i] = this.finger[i].method_32086(prefix + "fore_finger" + i);
            }
            this.thumb = this.hand.method_32086(prefix + "thumb");
        }

        static void createArmLayer(String prefix, class_5610 root, boolean right, boolean lower) {
            class_5610 arm = root.method_32117(prefix + "arm", class_5606.method_32108().method_32101(92, 0).method_32098(-1.5f, lower ? 6.0f : 0.0f, -1.5f, 3.0f, 22.0f, 3.0f, new class_5605(0.1f)).method_32106(!right), class_5603.method_32090((float)(right ? -4.0f : 4.0f), (float)-14.0f, (float)0.0f));
            class_5610 foreArm = arm.method_32117(prefix + "fore_arm", class_5606.method_32108().method_32101(104, 0).method_32097(-1.5f, 0.0f, -1.5f, 3.0f, 18.0f, 3.0f).method_32106(!right), class_5603.method_32090((float)0.0f, (float)21.0f, (float)1.0f));
            class_5610 hand = foreArm.method_32117(prefix + "hand", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)0.0f, (float)17.5f, (float)0.0f));
            for (int i = 0; i < 3; ++i) {
                class_5603 partPose = i == 0 ? class_5603.method_32090((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)-1.0f) : (i == 1 ? class_5603.method_32090((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)0.0f) : class_5603.method_32090((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)1.0f));
                class_5610 finger = hand.method_32117(prefix + "finger" + i, class_5606.method_32108().method_32101(76, 0).method_32106(!right).method_32098(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new class_5605(0.6f)), partPose);
                finger.method_32117(prefix + "fore_finger" + i, class_5606.method_32108().method_32101(76, 0).method_32106(!right).method_32098(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new class_5605(0.59000003f)), class_5603.method_32090((float)0.0f, (float)(0.5f + (float)(i == 1 ? 6 : 5)), (float)0.0f));
            }
            hand.method_32117(prefix + "thumb", class_5606.method_32108().method_32101(76, 0).method_32106(right).method_32098(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new class_5605(0.6f)), class_5603.method_32090((float)(right ? 0.5f : -0.5f), (float)0.0f, (float)-0.5f));
        }

        private void setAngles() {
            Animator.resetAngles(this.arm);
            Animator.resetAngles(this.foreArm);
            Animator.resetAngles(this.hand);
            for (int i = 0; i < this.finger.length; ++i) {
                Animator.resetAngles(this.finger[i]);
                Animator.resetAngles(this.foreFinger[i]);
            }
            Animator.resetAngles(this.thumb);
            if (this.right) {
                this.arm.field_3654 = -0.5235988f;
                this.arm.field_3674 = 0.5235988f;
                this.foreArm.field_3654 = -0.62831855f;
                this.hand.field_3675 = -0.3926991f;
                this.finger[0].field_3654 = -0.2617994f;
                this.finger[1].field_3674 = 0.17453294f;
                this.finger[2].field_3654 = 0.2617994f;
                this.foreFinger[0].field_3674 = -0.2617994f;
                this.foreFinger[1].field_3674 = -0.3926991f;
                this.foreFinger[2].field_3674 = -0.2617994f;
                this.thumb.field_3654 = -0.62831855f;
                this.thumb.field_3674 = -0.3926991f;
            } else {
                this.arm.field_3654 = -0.5235988f;
                this.arm.field_3674 = -0.5235988f;
                this.foreArm.field_3654 = -0.62831855f;
                this.hand.field_3675 = 0.3926991f;
                this.finger[0].field_3654 = -0.2617994f;
                this.finger[1].field_3674 = -0.17453294f;
                this.finger[2].field_3654 = 0.2617994f;
                this.foreFinger[0].field_3674 = 0.2617994f;
                this.foreFinger[1].field_3674 = 0.3926991f;
                this.foreFinger[2].field_3674 = 0.2617994f;
                this.thumb.field_3654 = -0.62831855f;
                this.thumb.field_3674 = 0.3926991f;
            }
        }

        private void translateRotate(class_4587 matrixStackIn) {
            this.arm.method_22703(matrixStackIn);
            this.foreArm.method_22703(matrixStackIn);
            this.hand.method_22703(matrixStackIn);
        }
    }
}

