/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common;

import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.core.PingController;
import nx.pingwheel.common.core.PingManager;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.network.UpdateChannelC2SPacket;
import nx.pingwheel.common.platform.IPlatformClientEventService;
import nx.pingwheel.common.platform.IPlatformContextService;
import nx.pingwheel.common.platform.IPlatformNetworkService;
import nx.pingwheel.common.render.OverlayRenderer;
import nx.pingwheel.common.render.WorldRenderContext;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.common.util.InputUtils;

public class CommonClient {
    public static final CommonClient INSTANCE = new CommonClient();
    public static class_310 Game = null;
    public static boolean DistantHorizonsLoaded = false;

    private CommonClient() {
    }

    public void onInit() {
        ClientConfig.HANDLER.load();
        IPlatformClientEventService.INSTANCE.registerTickStartEvent(this::onTickStart);
        IPlatformClientEventService.INSTANCE.registerJoinServerEvent(this::onJoinServer);
        IPlatformClientEventService.INSTANCE.registerLeaveServerEvent(this::onLeaveServer);
        IPlatformContextService.INSTANCE.registerKeyMapping(InputUtils.KEY_BINDING_PING);
        IPlatformContextService.INSTANCE.registerKeyMapping(InputUtils.KEY_BINDING_SETTINGS);
        IPlatformContextService.INSTANCE.registerKeyMapping(InputUtils.KEY_BINDING_NAME_LABELS);
        DistantHorizonsLoaded = IPlatformContextService.INSTANCE.isModLoaded("distanthorizons");
    }

    public void onJoinServer() {
        IPlatformNetworkService.INSTANCE.sendToServer(new UpdateChannelC2SPacket(ClientConfig.HANDLER.getConfig().getChannel()));
    }

    public void onLeaveServer() {
        PingManager.clearPings();
    }

    public void onTickStart() {
        Game = class_310.method_1551();
        GameContext.updateDimension();
        if (InputUtils.consumePingHotkey()) {
            PingController.queuePingAction();
        }
        if (InputUtils.KEY_BINDING_SETTINGS.method_1436()) {
            Game.method_1507((class_437)new SettingsScreen());
        }
    }

    public void onRenderWorld(WorldRenderContext ctx) {
        PingManager.updatePings(ctx);
        PingController.pollPingAction(ctx.tickDelta.floatValue());
    }

    public void onRenderGUI(class_332 guiGraphics, float tickDelta) {
        OverlayRenderer.draw(guiGraphics, tickDelta);
    }

    public void onPingLocationPacket(PingLocationS2CPacket packet) {
        PingManager.acceptPingPacket(packet);
    }
}

