/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public abstract class FilterUpgradeBase<T, F extends FilterSettingsBase>
extends UpgradeBase<T>
implements IFilter {
    protected final ItemStackHandler filter;
    protected final List<Runnable> changeListeners = new ArrayList<Runnable>();
    private final int filterSlotCount;
    private final F filterSettings;

    public FilterUpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize, int filterSlotCount, class_2371<class_1799> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, openTabSize);
        this.filterSlotCount = filterSlotCount;
        this.filterSettings = this.createFilterSettings(manager, filter, filterTags);
        this.filter = this.createFilter(filter);
    }

    public F getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().method_58695(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    }

    @Override
    public int getFilterSlotCount() {
        return this.filterSlotCount;
    }

    @Override
    public void updateSettings() {
        ((FilterSettingsBase)this.getFilterSettings()).updateSettings(this.getFilter());
    }

    public boolean hasTagSelector() {
        return true;
    }

    public boolean isTagSelector() {
        if (!this.hasTagSelector()) {
            return false;
        }
        return this.getFilter().get(1) == 2;
    }

    public class_1799 getFirstFilterStack() {
        return this.filter.getStackInSlot(0);
    }

    public void addChangeListener(Runnable listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public Point getTabSize() {
        Point tabSize = super.getTabSize();
        if (this.isTabOpened() && this.isTagSelector()) {
            return new Point(tabSize.x() + 21, tabSize.y());
        }
        return tabSize;
    }

    public abstract F createFilterSettings(UpgradeManager var1, class_2371<class_1799> var2, List<String> var3);

    protected abstract ItemStackHandler createFilter(class_2371<class_1799> var1);
}

