/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.FrameworkData;
import com.mrcrayfish.framework.api.client.model.FrameworkModelResource;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class StandaloneModelManager {
    private static StandaloneModelManager instance;
    private final Set<FrameworkModelResource<?>> models = Collections.synchronizedSet(new LinkedHashSet());

    public static StandaloneModelManager getInstance() {
        if (instance == null) {
            instance = new StandaloneModelManager();
        }
        return instance;
    }

    private StandaloneModelManager() {
    }

    public <T> void register(FrameworkModelResource<T> resource) {
        if (FrameworkData.isLoaded()) {
            throw new IllegalStateException("Standalone models can only be registered during client initialization");
        }
        this.models.add(resource);
    }

    public void load(Consumer<FrameworkModelResource<?>> consumer) {
        this.models.forEach(resource -> {
            Constants.LOG.debug("Registering standalone model: {}", (Object)resource.getLocation());
            consumer.accept((FrameworkModelResource<?>)resource);
        });
    }
}

