/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.function.Supplier;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public interface DraggableStackProvider<T extends class_437>
extends DraggableComponentProvider<T, EntryStack<?>> {
    public static <T extends class_437> DraggableStackProvider<T> from(final Supplier<Iterable<DraggableStackProvider<T>>> providers) {
        return new DraggableStackProvider<T>(){

            @Override
            public <R extends class_437> boolean isHandingScreen(R screen) {
                for (DraggableStackProvider provider : (Iterable)providers.get()) {
                    if (!provider.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public DraggableStack getHoveredStack(DraggingContext<T> context, double mouseX, double mouseY) {
                for (DraggableStackProvider provider : (Iterable)providers.get()) {
                    DraggableStack stack;
                    if (!provider.isHandingScreen(context.getScreen()) || (stack = provider.getHoveredStack(context, mouseX, mouseY)) == null) continue;
                    return stack;
                }
                return null;
            }
        };
    }

    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<T> var1, double var2, double var4);

    @Override
    @Nullable
    default public DraggableComponent<EntryStack<?>> getHovered(DraggingContext<T> context, double mouseX, double mouseY) {
        return this.getHoveredStack(context, mouseX, mouseY);
    }

    @Override
    public <R extends class_437> boolean isHandingScreen(R var1);

    @Override
    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    @Override
    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableStackProvider<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }
}

