/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.redstoneRequester;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.packet.s2c.RedstoneRequesterEffectPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9129;

public class RedstoneRequesterBlockEntity
extends StockCheckingBlockEntity
implements MenuProvider {
    public boolean allowPartialRequests = false;
    public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
    public String encodedTargetAdress = "";
    public boolean lastRequestSucceeded;
    protected boolean redstonePowered;

    public RedstoneRequesterBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.REDSTONE_REQUESTER, pos, state);
    }

    protected void onRedstonePowerChanged() {
        boolean hasNeighborSignal = this.field_11863.method_49803(this.field_11867);
        if (this.redstonePowered == hasNeighborSignal) {
            return;
        }
        this.lastRequestSucceeded = false;
        if (hasNeighborSignal) {
            this.triggerRequest();
        }
        this.redstonePowered = hasNeighborSignal;
        this.notifyUpdate();
    }

    public void triggerRequest() {
        if (this.encodedRequest.isEmpty()) {
            return;
        }
        boolean anySucceeded = false;
        InventorySummary summaryOfOrder = new InventorySummary();
        this.encodedRequest.stacks().forEach(summaryOfOrder::add);
        InventorySummary summary = this.getAccurateSummary();
        for (BigItemStack entry : summaryOfOrder.getStacks()) {
            class_1937 class_19372;
            if (summary.getCountOf(entry.stack) >= entry.count) {
                anySucceeded = true;
                continue;
            }
            if (this.allowPartialRequests || !((class_19372 = this.field_11863) instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_3760().method_14605(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 32.0, serverLevel.method_27983(), (class_2596)new RedstoneRequesterEffectPacket(this.field_11867, false));
            return;
        }
        this.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.REDSTONE, this.encodedRequest, null, this.encodedTargetAdress);
        class_1937 class_19373 = this.field_11863;
        if (class_19373 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19373;
            serverLevel.method_8503().method_3760().method_14605(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 32.0, serverLevel.method_27983(), (class_2596)new RedstoneRequesterEffectPacket(this.field_11867, anySucceeded));
        }
        this.lastRequestSucceeded = true;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.redstonePowered = view.method_71433("Powered", false);
        this.lastRequestSucceeded = view.method_71433("Success", false);
        this.allowPartialRequests = view.method_71433("AllowPartial", false);
        this.encodedRequest = view.method_71426("EncodedRequest", PackageOrderWithCrafts.CODEC).orElse(PackageOrderWithCrafts.empty());
        this.encodedTargetAdress = view.method_71428("EncodedAddress", "");
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71472("AllowPartial", this.allowPartialRequests);
        view.method_71469("EncodedAddress", this.encodedTargetAdress);
        view.method_71468("EncodedRequest", PackageOrderWithCrafts.CODEC, (Object)this.encodedRequest);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Powered", this.redstonePowered);
        view.method_71472("Success", this.lastRequestSucceeded);
        view.method_71472("AllowPartial", this.allowPartialRequests);
        view.method_71469("EncodedAddress", this.encodedTargetAdress);
        view.method_71468("EncodedRequest", PackageOrderWithCrafts.CODEC, (Object)this.encodedRequest);
    }

    public class_1269 use(class_1657 player) {
        if (player == null || player.method_18276()) {
            return class_1269.field_5811;
        }
        if (FakePlayerHandler.has((class_1297)player)) {
            return class_1269.field_5811;
        }
        if (this.field_11863.field_9236) {
            return class_1269.field_5812;
        }
        if (!this.behaviour.mayInteractMessage(player)) {
            return class_1269.field_5812;
        }
        this.openHandledScreen((class_3222)player);
        return class_1269.field_5812;
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    public RedstoneRequesterMenu createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer, class_9129 extraData) {
        extraData.method_10807(this.field_11867);
        return new RedstoneRequesterMenu(pContainerId, pPlayerInventory, this);
    }

    public void playEffect(boolean success) {
        class_243 vec3 = class_243.method_24953((class_2382)this.field_11867);
        if (success) {
            AllSoundEvents.CONFIRM.playAt(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.5f, false);
            AllSoundEvents.STOCK_LINK.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, false);
            this.field_11863.method_8406((class_2394)AllParticleTypes.WIFI, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.DENY.playAt(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f, false);
            this.field_11863.method_8406((class_2394)class_2398.field_11208, vec3.field_1352, vec3.field_1351 + 1.0, vec3.field_1350, 0.0, 0.0, 0.0);
        }
    }
}

