/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.steamWhistle;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import java.util.Locale;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class WhistleBlock
extends class_2248
implements IBE<WhistleBlockEntity>,
IWrenchable {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 WALL = class_2746.method_11825((String)"wall");
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<WhistleSize> SIZE = class_2754.method_11850((String)"size", WhistleSize.class);

    public WhistleBlock(class_4970.class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WALL, (Comparable)Boolean.valueOf(false))).method_11657(SIZE, (Comparable)((Object)WhistleSize.MEDIUM)));
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return FluidTankBlock.isTank(pLevel.method_8320(pPos.method_10093(WhistleBlock.getAttachedDirection(pState))));
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        return (class_2680)originalState.method_28493(SIZE);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(new class_2769[]{FACING, POWERED, SIZE, WALL}));
    }

    public class_2680 method_9605(class_1750 pContext) {
        class_2680 state;
        class_1937 level = pContext.method_8045();
        class_2338 clickedPos = pContext.method_8037();
        class_2350 face = pContext.method_8038();
        boolean wall = true;
        if (face.method_10166() == class_2350.class_2351.field_11052) {
            face = pContext.method_8042().method_10153();
            wall = false;
        }
        if (!this.method_9558(state = (class_2680)((class_2680)((class_2680)super.method_9605(pContext).method_11657(FACING, (Comparable)face.method_10153())).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(level.method_49803(clickedPos)))).method_11657((class_2769)WALL, (Comparable)Boolean.valueOf(wall)), (class_4538)level, clickedPos)) {
            return null;
        }
        return state;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (player == null) {
            return class_1269.field_52423;
        }
        if (stack.method_31574((class_1792)AllItems.STEAM_WHISTLE)) {
            WhistleBlock.incrementSize((class_1936)level, pos);
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    public static void incrementSize(class_1936 pLevel, class_2338 pPos) {
        class_2680 base = pLevel.method_8320(pPos);
        if (!base.method_28498(SIZE)) {
            return;
        }
        WhistleSize size = (WhistleSize)((Object)base.method_11654(SIZE));
        class_2498 soundtype = base.method_26231();
        class_2338 currentPos = pPos.method_10084();
        for (int i = 1; i <= 6; ++i) {
            class_2680 blockState = pLevel.method_8320(currentPos);
            float pVolume = (soundtype.method_10597() + 1.0f) / 2.0f;
            class_3414 growSound = (class_3414)class_3417.field_14776.comp_349();
            class_3414 hitSound = soundtype.method_10596();
            if (blockState.method_27852((class_2248)AllBlocks.STEAM_WHISTLE_EXTENSION)) {
                if (blockState.method_11654(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                    pLevel.method_8652(currentPos, (class_2680)blockState.method_11657(WhistleExtenderBlock.SHAPE, (Comparable)((Object)WhistleExtenderBlock.WhistleExtenderShape.DOUBLE)), 3);
                    float pPitch = (float)Math.pow(2.0, (double)(-(i * 2)) / 12.0);
                    pLevel.method_8396(null, currentPos, growSound, class_3419.field_15245, pVolume / 4.0f, pPitch);
                    pLevel.method_8396(null, currentPos, hitSound, class_3419.field_15245, pVolume, pPitch);
                    return;
                }
            } else {
                if (!blockState.method_45474()) {
                    return;
                }
                pLevel.method_8652(currentPos, (class_2680)AllBlocks.STEAM_WHISTLE_EXTENSION.method_9564().method_11657(SIZE, (Comparable)((Object)size)), 3);
                float pPitch = (float)Math.pow(2.0, (double)(-(i * 2 - 1)) / 12.0);
                pLevel.method_8396(null, currentPos, growSound, class_3419.field_15245, pVolume / 4.0f, pPitch);
                pLevel.method_8396(null, currentPos, hitSound, class_3419.field_15245, pVolume, pPitch);
                return;
            }
            currentPos = currentPos.method_10084();
        }
    }

    public static void queuePitchUpdate(class_1936 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)class_22482;
            if (!level.method_8397().method_8674(pos, (Object)whistle)) {
                level.method_64310(pos, (class_2248)whistle, 1);
            }
        }
    }

    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        this.withBlockEntityDo((class_1922)pLevel, pPos, WhistleBlockEntity::updatePitch);
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.method_10093(WhistleBlock.getAttachedDirection(pState)));
        if (pOldState.method_26204() != this || pOldState.method_11654(SIZE) != pState.method_11654(SIZE)) {
            WhistleBlock.queuePitchUpdate((class_1936)pLevel, pPos);
        }
    }

    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState(pState, (class_1937)pLevel, pPos.method_10093(WhistleBlock.getAttachedDirection(pState)));
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, @Nullable class_9904 wireOrientation, boolean isMoving) {
        if (worldIn.field_9236) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.method_11654((class_2769)POWERED);
        if (previouslyPowered != worldIn.method_49803(pos)) {
            worldIn.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
        }
    }

    public class_2680 method_9559(class_2680 pState, class_4538 pLevel, class_10225 tickView, class_2338 pCurrentPos, class_2350 pFacing, class_2338 pFacingPos, class_2680 pFacingState, class_5819 random) {
        return WhistleBlock.getAttachedDirection(pState) == pFacing && !pState.method_26184(pLevel, pCurrentPos) ? class_2246.field_10124.method_9564() : pState;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        WhistleSize size = (WhistleSize)((Object)pState.method_11654(SIZE));
        if (!((Boolean)pState.method_11654((class_2769)WALL)).booleanValue()) {
            return size == WhistleSize.SMALL ? AllShapes.WHISTLE_SMALL_FLOOR : (size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_MEDIUM_FLOOR : AllShapes.WHISTLE_LARGE_FLOOR);
        }
        class_2350 direction = (class_2350)pState.method_11654(FACING);
        return (size == WhistleSize.SMALL ? AllShapes.WHISTLE_SMALL_WALL : (size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_MEDIUM_WALL : AllShapes.WHISTLE_LARGE_WALL)).get(direction);
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public static class_2350 getAttachedDirection(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WALL) != false ? (class_2350)state.method_11654(FACING) : class_2350.field_11033;
    }

    @Override
    public Class<WhistleBlockEntity> getBlockEntityClass() {
        return WhistleBlockEntity.class;
    }

    @Override
    public class_2591<? extends WhistleBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.STEAM_WHISTLE;
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return (class_2680)pState.method_11657(FACING, (Comparable)pRotation.method_10503((class_2350)pState.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pMirror == class_2415.field_11302 ? pState : pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654(FACING)));
    }

    protected boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        return direction == class_2350.field_11036 && stateFrom.method_27852((class_2248)AllBlocks.STEAM_WHISTLE_EXTENSION);
    }

    public static enum WhistleSize implements class_3542
    {
        SMALL,
        MEDIUM,
        LARGE;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

