/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.mounted;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;

public class MountedContraption
extends Contraption {
    public CartAssemblerBlockEntity.CartMovementMode rotationMode;
    public class_1688 connectedCart;

    public MountedContraption() {
        this(CartAssemblerBlockEntity.CartMovementMode.ROTATE);
    }

    public MountedContraption(CartAssemblerBlockEntity.CartMovementMode mode) {
        this.rotationMode = mode;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.MOUNTED;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        class_2680 state = world.method_8320(pos);
        if (!state.method_28498(CartAssemblerBlock.RAIL_SHAPE)) {
            return false;
        }
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        class_2350.class_2351 axis = state.method_11654(CartAssemblerBlock.RAIL_SHAPE) == class_2768.field_12674 ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        this.addBlock(world, pos, (Pair<class_3499.class_3501, class_2586>)Pair.of((Object)new class_3499.class_3501(pos, (class_2680)AllBlocks.MINECART_ANCHOR.method_9564().method_11657((class_2769)class_2741.field_12529, (Comparable)axis), null), null));
        return this.blocks.size() != 1;
    }

    @Override
    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 direction, Queue<class_2338> frontier) {
        frontier.clear();
        frontier.add(pos.method_10084());
        return true;
    }

    @Override
    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        Pair<class_3499.class_3501, class_2586> pair = super.capture(world, pos);
        class_3499.class_3501 capture = (class_3499.class_3501)pair.getKey();
        if (!capture.comp_1342().method_27852((class_2248)AllBlocks.CART_ASSEMBLER)) {
            return pair;
        }
        Pair anchorSwap = Pair.of((Object)new class_3499.class_3501(pos, CartAssemblerBlock.createAnchor(capture.comp_1342()), null), (Object)((class_2586)pair.getValue()));
        if (pos.equals((Object)this.anchor) || this.connectedCart != null) {
            return anchorSwap;
        }
        for (class_2350.class_2351 axis : Iterate.axes) {
            class_1688 abstractMinecartEntity;
            if (axis.method_10178() || !VecHelper.onSameAxis(this.anchor, pos, axis)) continue;
            Iterator iterator = world.method_18467(class_1688.class, new class_238(pos)).iterator();
            while (iterator.hasNext() && CartAssemblerBlock.canAssembleTo(abstractMinecartEntity = (class_1688)iterator.next())) {
                this.connectedCart = abstractMinecartEntity;
                this.connectedCart.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f));
            }
        }
        return anchorSwap;
    }

    @Override
    protected boolean movementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        if (!pos.equals((Object)this.anchor) && state.method_27852((class_2248)AllBlocks.CART_ASSEMBLER)) {
            return this.testSecondaryCartAssembler(world, pos);
        }
        return super.movementAllowed(state, world, pos);
    }

    protected boolean testSecondaryCartAssembler(class_1937 world, class_2338 pos) {
        for (class_2350.class_2351 axis : Iterate.axes) {
            class_1688 abstractMinecartEntity;
            Iterator iterator;
            if (axis.method_10178() || !VecHelper.onSameAxis(this.anchor, pos, axis) || !(iterator = world.method_18467(class_1688.class, new class_238(pos)).iterator()).hasNext() || !CartAssemblerBlock.canAssembleTo(abstractMinecartEntity = (class_1688)iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71468("RotationMode", CartAssemblerBlockEntity.CartMovementMode.CODEC, (Object)this.rotationMode);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        view.method_71426("RotationMode", CartAssemblerBlockEntity.CartMovementMode.CODEC).ifPresent(mode -> {
            this.rotationMode = mode;
        });
        super.read(world, view, spawnData);
    }

    @Override
    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.MINECART_ANCHOR);
    }

    @Override
    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.MINECART_ANCHOR);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return true;
    }

    public void addExtraInventories(class_1297 cart) {
        if (cart instanceof class_1263) {
            class_1263 inventory = (class_1263)cart;
            this.storage.attachExternal(inventory);
        }
    }
}

