/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.extension;

import java.util.function.Function;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiExtensionCreator<P extends GuiClientControl, T extends GuiControl> {
    public final P parent;
    private T extension;
    private boolean lostFocus;

    public GuiExtensionCreator(P parent) {
        this.parent = parent;
    }

    public void toggle(Function<? extends GuiExtensionCreator, T> factory) {
        this.toggle(factory, ExtensionDirection.BELOW_OR_ABOVE);
    }

    public void toggle(Function<? extends GuiExtensionCreator, T> factory, ExtensionDirection direction) {
        if (this.extension == null) {
            this.open((GuiControl)factory.apply(this), direction);
        } else {
            this.close();
        }
    }

    public void open(T extension) {
        this.open(extension, ExtensionDirection.BELOW_OR_ABOVE);
    }

    public void open(T extension, ExtensionDirection direction) {
        this.open(extension, (GuiClientControl)this.parent, direction);
    }

    public void open(T extension, GuiClientControl reference, ExtensionDirection direction) {
        this.extension = extension;
        GuiLayer layer = ((GuiControl)reference.control).getLayer();
        layer.addHover((GuiControl)extension);
        Rect rect = ((GuiControl)reference.control).toLayerRect(new Rect(0.0, 0.0, reference.rect.getWidth(), reference.rect.getHeight()));
        ((GuiControl)extension).init();
        direction.apply((GuiClientLayer)layer.dist(), ((GuiClientControl)((GuiControl)extension).dist()).rect, rect, ((GuiClientControl)((Object)layer.dist())).getContentOffset());
    }

    public T get() {
        return this.extension;
    }

    public void close() {
        if (this.extension != null) {
            ((GuiControl)this.extension).closed();
            ((GuiControl)((GuiClientControl)this.parent).control).getLayer().remove((GuiControl)this.extension);
            this.extension = null;
        }
    }

    public boolean hasLostFocus() {
        return this.lostFocus;
    }

    public boolean hasExtension() {
        return this.extension != null;
    }

    public boolean checkShouldClose() {
        boolean result = this.extension != null && this.lostFocus;
        this.markLostFocus();
        return result;
    }

    public void markLostFocus() {
        this.lostFocus = true;
    }

    public void markKeptFocus() {
        this.lostFocus = false;
    }

    public static enum ExtensionDirection {
        BELOW_OR_ABOVE{

            @Override
            public void apply(GuiClientLayer layer, GuiControlRect extension, Rect creatorRect, int layerOffset) {
                extension.setX((int)creatorRect.minX);
                extension.setY((int)creatorRect.maxY);
                extension.setWidth((int)creatorRect.getWidth(), layer.rect.getWidth() - layerOffset * 2);
                extension.flowX();
                int layerHeight = layer.rect.getHeight() - layerOffset * 2;
                extension.setHeight(extension.getPreferredHeight(layerHeight), layerHeight);
                extension.flowY();
                Rect absolute = ((GuiLayer)layer.control).getIntegratedParent().toScreenRect(layer.control, extension.rectCopy());
                Rect screen = GuiClientControl.getScreenRect();
                if (absolute.maxY > screen.maxY && absolute.minY - absolute.getHeight() >= screen.minX) {
                    extension.setY(extension.getY() - ((int)creatorRect.getHeight() + extension.getHeight()));
                }
            }
        }
        ,
        BELOW_OR_ABOVE_ANY_SIZE{

            @Override
            public void apply(GuiClientLayer layer, GuiControlRect extension, Rect creatorRect, int layerOffset) {
                extension.setX((int)creatorRect.minX);
                extension.setY((int)creatorRect.maxY);
                int layerWidth = layer.rect.getWidth() - layerOffset * 2;
                extension.setWidth(extension.getPreferredWidth(layerWidth), layerWidth);
                extension.flowX();
                int layerHeight = layer.rect.getHeight() - layerOffset * 2;
                extension.setHeight(extension.getPreferredHeight(layerHeight), layerHeight);
                extension.flowY();
                Rect absolute = ((GuiLayer)layer.control).getIntegratedParent().toScreenRect(layer.control, extension.rectCopy());
                Rect screen = GuiClientControl.getScreenRect();
                if (absolute.maxY > screen.maxY && absolute.minY - absolute.getHeight() >= screen.minX) {
                    extension.setY(extension.getY() - ((int)creatorRect.getHeight() + extension.getHeight()));
                }
            }
        }
        ,
        RIGHT{

            @Override
            public void apply(GuiClientLayer layer, GuiControlRect extension, Rect creatorRect, int layerOffset) {
                extension.setX((int)creatorRect.maxX);
                extension.setY((int)creatorRect.minY);
                int layerWidth = layer.rect.getWidth() - layerOffset * 2;
                extension.setWidth(extension.getPreferredWidth(layerWidth), layerWidth);
                extension.flowX();
                int layerHeight = layer.rect.getHeight() - layerOffset * 2;
                extension.setHeight(extension.getPreferredHeight(layerHeight), layerHeight);
                extension.flowY();
                Rect absolute = ((GuiLayer)layer.control).getIntegratedParent().toScreenRect(layer.control, extension.rectCopy());
                Rect screen = GuiClientControl.getScreenRect();
                if (absolute.maxY > screen.maxY && absolute.minY - absolute.getHeight() >= screen.minX) {
                    extension.setY((int)creatorRect.maxY - extension.getHeight());
                }
            }
        };


        public abstract void apply(GuiClientLayer var1, GuiControlRect var2, Rect var3, int var4);
    }
}

