/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.advancedreborn.blocks;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.pitan76.advancedreborn.tile.CardboardBoxTile;
import net.pitan76.mcpitanlib.api.block.CompatBlockRenderType;
import net.pitan76.mcpitanlib.api.block.ExtendBlockEntityProvider;
import net.pitan76.mcpitanlib.api.block.args.RenderTypeArgs;
import net.pitan76.mcpitanlib.api.block.args.v2.GetComparatorOutputArgs;
import net.pitan76.mcpitanlib.api.block.args.v2.HasComparatorOutputArgs;
import net.pitan76.mcpitanlib.api.block.v2.CompatBlock;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.event.block.BlockBreakEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockPlacedEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockUseEvent;
import net.pitan76.mcpitanlib.api.event.block.DroppedStacksArgs;
import net.pitan76.mcpitanlib.api.event.block.PickStackEvent;
import net.pitan76.mcpitanlib.api.event.block.StateReplacedEvent;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.event.block.result.BlockBreakResult;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.state.property.CompatProperties;
import net.pitan76.mcpitanlib.api.state.property.DirectionProperty;
import net.pitan76.mcpitanlib.api.state.property.IProperty;
import net.pitan76.mcpitanlib.api.util.BlockEntityUtil;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.InventoryUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.entity.ItemEntityUtil;

public class CardboardBox
extends CompatBlock
implements ExtendBlockEntityProvider {
    public static CompatIdentifier CONTENTS = CompatIdentifier.of((String)"contents");
    public static DirectionProperty FACING = CompatProperties.HORIZONTAL_FACING;

    public CardboardBox(CompatibleBlockSettings settings) {
        super(settings);
        this.setNewDefaultState((class_2680)this.getNewDefaultState().method_11657(FACING.getProperty(), (Comparable)class_2350.field_11043));
    }

    public void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
        WorldUtil.setBlockState((class_1937)world, (class_2338)pos, (class_2680)((class_2680)WorldUtil.getBlockState((class_1937)world, (class_2338)pos).method_11657(FACING.getProperty(), (Comparable)facing)));
    }

    public class_2350 getFacing(class_2680 state) {
        return (class_2350)FACING.get(state);
    }

    public void appendProperties(AppendPropertiesArgs args) {
        super.appendProperties(args);
        args.addProperty(new IProperty[]{FACING});
    }

    public class_2586 createBlockEntity(TileCreateEvent event) {
        return new CardboardBoxTile(event);
    }

    public BlockBreakResult onBreak(BlockBreakEvent e) {
        class_1937 world = e.world;
        class_2338 pos = e.pos;
        class_2586 blockEntity = e.getBlockEntity();
        if (blockEntity instanceof CardboardBoxTile) {
            CardboardBoxTile tile = (CardboardBoxTile)blockEntity;
            if (!WorldUtil.isClient((class_1937)world) && e.player.isCreative() && !tile.method_5442()) {
                class_1799 stack = ItemStackUtil.create((class_1792)this.method_8389());
                class_2487 nbt = tile.writeInventoryNbt(NbtUtil.create());
                if (tile.hasNote()) {
                    NbtUtil.set((class_2487)nbt, (String)"note", (Object)tile.getNote());
                }
                if (!nbt.method_33133()) {
                    stack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)nbt));
                }
                if (tile.hasCustomName()) {
                    stack.method_57379(class_9334.field_49631, (Object)tile.getCustomName());
                }
                class_1542 itemEntity = ItemEntityUtil.create((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)stack);
                ItemEntityUtil.setToDefaultPickupDelay((class_1542)itemEntity);
                WorldUtil.spawnEntity((class_1937)world, (class_1297)itemEntity);
            }
        }
        return super.onBreak(e);
    }

    public void onStateReplaced(StateReplacedEvent e) {
        if (e.isSameState()) {
            return;
        }
        class_2586 blockEntity = e.getBlockEntity();
        if (blockEntity instanceof CardboardBoxTile) {
            e.updateComparators();
        }
        super.onStateReplaced(e);
    }

    public void onPlaced(BlockPlacedEvent e) {
        class_2586 blockEntity;
        class_1309 placer = e.placer;
        class_1937 world = e.world;
        class_2338 pos = e.pos;
        class_1799 stack = e.stack;
        if (placer != null) {
            this.setFacing(placer.method_5735().method_10153(), world, pos);
        }
        if (stack.method_57826(class_9334.field_49631) && (blockEntity = WorldUtil.getBlockEntity((class_1937)world, (class_2338)pos)) instanceof CardboardBoxTile) {
            ((CardboardBoxTile)blockEntity).setCustomName(stack.method_7964());
        }
        super.onPlaced(e);
    }

    public CompatActionResult onRightClick(BlockUseEvent e) {
        if (e.isClient()) {
            return e.success();
        }
        if (e.player.getPlayerEntity().method_7325()) {
            return e.consume();
        }
        class_2586 blockEntity = e.getBlockEntity();
        if (blockEntity instanceof CardboardBoxTile) {
            CardboardBoxTile tile = (CardboardBoxTile)blockEntity;
            e.player.openExtendedMenu((ExtendedMenuProvider)tile);
            return e.consume();
        }
        return e.pass();
    }

    public class_1799 getPickStack(PickStackEvent e) {
        class_1799 itemStack = super.getPickStack(e);
        class_2586 blockEntity = e.getBlockEntity();
        if (blockEntity instanceof CardboardBoxTile) {
            BlockEntityUtil.setStackNbt((class_2586)blockEntity, (class_1799)itemStack, (CompatRegistryLookup)RegistryLookupUtil.getRegistryLookup((class_2586)blockEntity));
        }
        return itemStack;
    }

    @Environment(value=EnvType.CLIENT)
    public void appendTooltip(ItemAppendTooltipEvent e) {
        super.appendTooltip(e);
        if (!e.stack.method_57826(class_9334.field_49611)) {
            return;
        }
        class_2487 nbt = ((class_9279)e.stack.method_58694(class_9334.field_49611)).method_57461();
        if (nbt != null) {
            if (nbt.method_10545("note")) {
                e.addTooltip((class_2561)TextUtil.literal((String)NbtUtil.getString((class_2487)nbt, (String)"note")));
            }
            if (NbtUtil.has((class_2487)nbt, (String)"LootTable")) {
                e.addTooltip((class_2561)TextUtil.literal((String)"???????"));
            }
            if (NbtUtil.has((class_2487)nbt, (String)"Items")) {
                class_2371 defaultedList = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                NbtRWArgs args = new NbtRWArgs(nbt, e.getRegistryLookup());
                InventoryUtil.readNbt((NbtRWArgs)args, (class_2371)defaultedList);
                int i = 0;
                int j = 0;
                for (class_1799 itemStack : defaultedList) {
                    if (itemStack.method_7960()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    class_5250 mutableText = itemStack.method_7964().method_27661();
                    mutableText.method_27693(" x").method_27693(String.valueOf(itemStack.method_7947()));
                    e.addTooltip((class_2561)mutableText);
                }
                if (j - i > 0) {
                    e.addTooltip((class_2561)TextUtil.translatable((String)"container.advanced_reborn.cardboard_box.more", (Object[])new Object[]{j - i}).method_27661().method_27692(class_124.field_1056));
                }
            }
        }
    }

    public CompatBlockRenderType getRenderType(RenderTypeArgs args) {
        return CompatBlockRenderType.MODEL;
    }

    public boolean hasComparatorOutput(HasComparatorOutputArgs args) {
        return true;
    }

    public int getComparatorOutput(GetComparatorOutputArgs args) {
        return args.calcComparatorOutputFromBlockEntity();
    }

    public List<class_1799> getDroppedStacks(DroppedStacksArgs args) {
        class_2586 blockEntity = args.getBlockEntity();
        if (blockEntity instanceof CardboardBoxTile) {
            CardboardBoxTile tile = (CardboardBoxTile)blockEntity;
            args.builder = args.builder.method_51872(CONTENTS.toMinecraft(), consumer -> {
                for (int i = 0; i < tile.method_5439(); ++i) {
                    consumer.accept(tile.method_5438(i));
                }
            });
        }
        return super.getDroppedStacks(args);
    }
}

