/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record PotionRecipe(FluidStack result, FluidIngredient fluidIngredient, class_1856 ingredient) implements BasinRecipe
{
    public static final List<class_1792> SUPPORTED_CONTAINERS = List.of(class_1802.field_8574, class_1802.field_8436, class_1802.field_8150);
    public static ReloadData data;

    public static void register(Map<class_2960, class_1860<?>> map) {
        if (data == null) {
            return;
        }
        class_1845 potionBrewing = class_1845.method_8076((class_7699)PotionRecipe.data.enabledFeatures);
        int recipeIndex = 0;
        ArrayList<class_1792> allowedSupportedContainers = new ArrayList<class_1792>();
        for (class_1792 container : SUPPORTED_CONTAINERS) {
            if (!potionBrewing.method_59700(new class_1799((class_1935)container))) continue;
            allowedSupportedContainers.add(container);
        }
        for (class_1792 container : allowedSupportedContainers) {
            BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(container);
            for (class_1845.class_1846 mix : potionBrewing.field_51404) {
                FluidIngredient fromFluid = PotionFluidHandler.getFluidIngredientFromPotion(new class_1844(mix.comp_2190()), bottleType, 81000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion(new class_1844(mix.comp_2192()), bottleType, 81000);
                class_2960 id = class_2960.method_60655((String)"create", (String)("potion_mixing_vanilla_" + recipeIndex++));
                map.put(id, new PotionRecipe(toFluid, fromFluid, mix.comp_2191()));
            }
        }
        for (class_1845.class_1846 mix : potionBrewing.field_51405) {
            class_1792 to;
            class_1792 from = (class_1792)mix.comp_2190().comp_349();
            if (!allowedSupportedContainers.contains(from) || !allowedSupportedContainers.contains(to = (class_1792)mix.comp_2192().comp_349())) continue;
            BottleType fromBottleType = PotionFluidHandler.bottleTypeFromItem(from);
            BottleType toBottleType = PotionFluidHandler.bottleTypeFromItem(to);
            class_1856 ingredient = mix.comp_2191();
            List potions = PotionRecipe.data.registries.method_46762(class_7924.field_41215).method_42017().toList();
            for (class_6880.class_6883 potion : potions) {
                FluidIngredient fromFluid = PotionFluidHandler.getFluidIngredientFromPotion(new class_1844((class_6880)potion), fromBottleType, 81000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion(new class_1844((class_6880)potion), toBottleType, 81000);
                class_2960 id = class_2960.method_60655((String)"create", (String)("potion_mixing_vanilla_" + recipeIndex++));
                map.put(id, new PotionRecipe(toFluid, fromFluid, ingredient));
            }
        }
        data = null;
    }

    @Override
    public int getIngredientSize() {
        return 2;
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return List.of(new SizedIngredient(this.ingredient, 1));
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return List.of(this.fluidIngredient);
    }

    public boolean matches(BasinInput input, class_1937 world) {
        if (!HeatCondition.HEATED.testBlazeBurner(input.heat())) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, this.ingredient);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredient)) {
            return false;
        }
        return input.acceptOutputs(outputs, List.of(this.result), true);
    }

    @Override
    public boolean apply(BasinInput input) {
        if (!HeatCondition.HEATED.testBlazeBurner(input.heat())) {
            return false;
        }
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, this.ingredient, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredient, changes)) {
            return false;
        }
        List<FluidStack> fluids = List.of(this.result);
        if (!input.acceptOutputs(outputs, fluids, true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, fluids, false);
    }

    public class_1865<PotionRecipe> method_8119() {
        return AllRecipeSerializers.POTION;
    }

    public class_3956<PotionRecipe> method_17716() {
        return AllRecipeTypes.POTION;
    }

    public record ReloadData(class_7225.class_7874 registries, class_7699 enabledFeatures) {
    }

    public static class Serializer
    implements class_1865<PotionRecipe> {
        public static final MapCodec<PotionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("result").forGetter(PotionRecipe::result), (App)FluidIngredient.CODEC.fieldOf("fluid_ingredient").forGetter(PotionRecipe::fluidIngredient), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(PotionRecipe::ingredient)).apply((Applicative)instance, PotionRecipe::new));
        public static final class_9139<class_9129, PotionRecipe> PACKET_CODEC = class_9139.method_56436(FluidStack.PACKET_CODEC, PotionRecipe::result, FluidIngredient.PACKET_CODEC, PotionRecipe::fluidIngredient, (class_9139)class_1856.field_48355, PotionRecipe::ingredient, PotionRecipe::new);

        public MapCodec<PotionRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, PotionRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

