/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.compat;

import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.impl.FlwImpl;
import com.zurrtum.create.client.flywheel.impl.compat.CompatMod;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import net.caffeinemc.mods.sodium.api.blockentity.BlockEntityRenderHandler;
import net.caffeinemc.mods.sodium.api.blockentity.BlockEntityRenderPredicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class SodiumCompat {
    public static final boolean ACTIVE = CompatMod.SODIUM.isLoaded;

    private SodiumCompat() {
    }

    @Nullable
    public static <T extends class_2586> Object onSetBlockEntityVisualizer(class_2591<T> type, @Nullable BlockEntityVisualizer<? super T> oldVisualizer, @Nullable BlockEntityVisualizer<? super T> newVisualizer, @Nullable Object predicate) {
        if (!ACTIVE) {
            return null;
        }
        if (oldVisualizer == null && newVisualizer != null) {
            if (predicate != null) {
                throw new IllegalArgumentException("Sodium predicate must be null when old visualizer is null");
            }
            return Internals.addPredicate(type);
        }
        if (oldVisualizer != null && newVisualizer == null) {
            if (predicate == null) {
                throw new IllegalArgumentException("Sodium predicate must not be null when old visualizer is not null");
            }
            Internals.removePredicate(type, predicate);
            return null;
        }
        return predicate;
    }

    static {
        if (ACTIVE) {
            FlwImpl.LOGGER.debug("Detected Sodium");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Internals {
        private Internals() {
        }

        static <T extends class_2586> Object addPredicate(class_2591<T> type) {
            BlockEntityRenderPredicate predicate = (getter, pos, be) -> !VisualizationHelper.tryAddBlockEntity(be);
            BlockEntityRenderHandler.instance().addRenderPredicate(type, predicate);
            return predicate;
        }

        static <T extends class_2586> void removePredicate(class_2591<T> type, Object predicate) {
            BlockEntityRenderHandler.instance().removeRenderPredicate(type, (BlockEntityRenderPredicate)predicate);
        }
    }
}

