/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.gui.render.BlockTransformRenderState;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2459;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class BlockTransformElementRenderer
extends class_11239<BlockTransformRenderState> {
    private static final Map<Object, GpuTexture> TEXTURES = new HashMap<Object, GpuTexture>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public BlockTransformElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(Object key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void render(BlockTransformRenderState block, class_11246 state, int windowScaleFactor) {
        GpuTexture texture;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        if ((texture = TEXTURES.get(block.getKey())) == null) {
            float size = block.size() * (float)windowScaleFactor;
            texture = GpuTexture.create((int)size);
            TEXTURES.put(block, texture);
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092(size, size), (class_10366)class_10366.field_54954);
            texture.prepare();
            this.matrices.method_22903();
            this.matrices.method_46416(size / 2.0f, size / 2.0f, 0.0f);
            if (block.padding() != 0) {
                size -= (float)(block.padding() * windowScaleFactor);
            }
            this.matrices.method_22905(size, size, size);
            if (block.zRot() != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(block.zRot()));
            }
            if (block.xRot() != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(block.xRot()));
            }
            if (block.yRot() != 0.0f) {
                this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(block.yRot()));
            }
            this.matrices.method_22905(1.0f, -1.0f, 1.0f);
            this.matrices.method_46416(-0.5f, -0.5f, -0.5f);
            class_310 mc = class_310.method_1551();
            class_1921 layer = block.state().method_27852(class_2246.field_10523) && (Boolean)block.state().method_11654((class_2769)class_2459.field_11446) != false ? class_1921.method_23581() : (class_4696.method_23679((class_2680)block.state()) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074());
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            world.blockState(block.state());
            mc.method_1541().method_3355(block.state(), class_2338.field_10980, (class_1920)world, this.matrices, this.field_59933.getBuffer(layer), false, block.parts());
            this.field_59933.method_22993();
            this.matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView()), block.method_72127(), block.comp_4122(), block.comp_4123(), block.comp_4124(), block.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, block.scissor(), null));
    }

    protected void render(BlockTransformRenderState block, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Block Transform";
    }

    public Class<BlockTransformRenderState> method_70903() {
        return BlockTransformRenderState.class;
    }
}

