/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11246;
import net.minecraft.class_11247;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import team.creative.creativecore.client.render.gui.ColorRect;
import team.creative.creativecore.client.render.gui.ColorRectF;
import team.creative.creativecore.client.render.gui.HorizontalGradientRect;
import team.creative.creativecore.client.render.gui.HorizontalGradientRectF;
import team.creative.creativecore.client.render.gui.VerticalGradientRect;
import team.creative.creativecore.client.render.gui.VerticalGradientRectF;

@Environment(value=EnvType.CLIENT)
public interface CreativeGuiGraphics {
    public static CreativeGuiGraphics as(class_332 graphics) {
        return (CreativeGuiGraphics)graphics;
    }

    default public void drawStringCentered(String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        class_310 minecraft = this.minecraft();
        int textWidth = minecraft.field_1772.method_1727((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = minecraft.field_1772.method_1727("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = minecraft.field_1772.method_1727("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = String.valueOf(builder) + "...";
        }
        class_332 class_3322 = this.as();
        class_327 class_3272 = minecraft.field_1772;
        int n = (int)(width / 2.0f - (float)(minecraft.field_1772.method_1727((String)text) / 2));
        float f = height / 2.0f;
        Objects.requireNonNull(minecraft.field_1772);
        class_3322.method_51433(class_3272, (String)text, n, (int)(f - (float)(9 / 2)), -1, shadow);
    }

    default public void drawString(class_5481 text, int x, int y, int color, int shadowColor, boolean shadow) {
        if (class_9848.method_61320((int)color) != 0) {
            this.guiRenderState().method_70921(new class_11247(this.font(), text, new Matrix3x2f((Matrix3x2fc)this.pose()), x, y, color, shadowColor, shadow, this.peekScissor()));
        }
    }

    default public void horizontalGradientRect(int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        this.guiRenderState().method_70919((class_11244)new HorizontalGradientRect(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void horizontalGradientRect(float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        this.guiRenderState().method_70919((class_11244)new HorizontalGradientRectF(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void verticalGradientRect(int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        this.guiRenderState().method_70919((class_11244)new VerticalGradientRect(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void verticalGradientRect(float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        this.guiRenderState().method_70919((class_11244)new VerticalGradientRectF(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void horizontalGradientMaskRect(int x, int y, int x2, int y2, int color, int mask) {
        this.horizontalGradientRect(x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    default public void horizontalGradientMaskRect(float x, float y, float x2, float y2, int color, int mask) {
        this.horizontalGradientRect(x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    default public void colorRect(int x, int y, int width, int height, int color) {
        this.guiRenderState().method_70919((class_11244)new ColorRect(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.pose(), x, y, x + width, y + height, color, this.peekScissor()));
    }

    default public void colorRect(float x, float y, float width, float height, int color) {
        this.guiRenderState().method_70919((class_11244)new ColorRectF(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.pose(), x, y, x + width, y + height, color, this.peekScissor()));
    }

    default public void textureRect(class_2960 location, int x, int y, int width, int height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(class_10799.field_56883, location, x, x + width, y, y + height, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight, -1);
    }

    default public void textureRect(class_2960 location, float x, float y, float width, float height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(class_10799.field_56883, location, (int)x, (int)(x + width), (int)y, (int)(y + height), u / (float)textureWidth, (u + width) / (float)textureWidth, v / (float)textureHeight, (v + height) / (float)textureHeight, -1);
    }

    default public void textureRect(class_2960 location, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(class_10799.field_56883, location, x, x + width, y, y + height, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight, -1);
    }

    default public void textureRect(class_2960 location, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(class_10799.field_56883, location, (int)x, (int)(x + width), (int)y, (int)(y + height), u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight, -1);
    }

    default public void textureRectColor(class_2960 location, int x, int y, int width, int height, float u, float v, float u2, float v2, int color) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(class_10799.field_56883, location, x, x + width, y, y + height, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight, color);
    }

    default public void textureRectStrechted(class_2960 location, int x, int y, int width, int height) {
        this.blit(class_10799.field_56883, location, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
    }

    default public void textureRectColorStretched(class_2960 location, int x, int y, int width, int height, int color) {
        this.blit(class_10799.field_56883, location, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    default public void renderItemDecorations(class_1799 stack, int x, int y) {
        this.as().method_51431(this.font(), stack, x, y);
    }

    default public void renderItemDecorations(class_1799 stack, int x, int y, @Nullable String text) {
        this.as().method_51432(this.font(), stack, x, y, text);
    }

    public void blit(RenderPipeline var1, class_2960 var2, int var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11);

    public class_332 as();

    public class_310 minecraft();

    public Matrix3x2fStack pose();

    public class_327 font();

    public class_11246 guiRenderState();

    public class_8030 peekScissor();

    public void setOverrideScissor(@Nullable class_8030 var1);

    public void clearOverrideScissor();
}

