/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SyncPacket(boolean canTeleport, List<class_2960> allowedStructureIDs, ListMultimap<class_2960, class_2960> allowedStructureIDsToDimensionIDs, Map<class_2960, class_2960> structureIDsToGroupIDs, ListMultimap<class_2960, class_2960> groupIDsToStructureIDs) implements class_8710
{
    public static final class_8710.class_9154<SyncPacket> PACKET_ID = new class_8710.class_9154(class_2960.method_60655((String)"explorerscompass", (String)"sync"));
    public static final class_9139<class_9129, SyncPacket> PACKET_CODEC = class_9139.method_56438(SyncPacket::write, SyncPacket::read);

    public static SyncPacket read(class_9129 buf) {
        boolean canTeleport = buf.readBoolean();
        ArrayList<class_2960> allowedStructureIDs = new ArrayList<class_2960>();
        ArrayListMultimap allowedStructureIDsToDimensionIDs = ArrayListMultimap.create();
        HashMap<class_2960, class_2960> structureIDsToGroupIDs = new HashMap<class_2960, class_2960>();
        ArrayListMultimap groupIDsToStructureIDs = ArrayListMultimap.create();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            class_2960 structureID = buf.method_10810();
            int numDimensions = buf.readInt();
            ArrayList<class_2960> dimensionIDs = new ArrayList<class_2960>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensionIDs.add(buf.method_10810());
            }
            class_2960 groupID = buf.method_10810();
            if (structureID == null) continue;
            allowedStructureIDs.add(structureID);
            allowedStructureIDsToDimensionIDs.putAll((Object)structureID, dimensionIDs);
            structureIDsToGroupIDs.put(structureID, groupID);
        }
        int numGroups = buf.readInt();
        for (int i = 0; i < numGroups; ++i) {
            class_2960 groupID = buf.method_10810();
            int numGroupsToAdd = buf.readInt();
            for (int j = 0; j < numGroupsToAdd; ++j) {
                class_2960 structureID = buf.method_10810();
                groupIDsToStructureIDs.put((Object)groupID, (Object)structureID);
            }
        }
        return new SyncPacket(canTeleport, allowedStructureIDs, (ListMultimap<class_2960, class_2960>)allowedStructureIDsToDimensionIDs, structureIDsToGroupIDs, (ListMultimap<class_2960, class_2960>)groupIDsToStructureIDs);
    }

    public void write(class_9129 buf) {
        buf.method_52964(this.canTeleport);
        buf.method_53002(this.allowedStructureIDs.size());
        for (class_2960 structureID : this.allowedStructureIDs) {
            buf.method_10812(structureID);
            List dimensionIDs = this.allowedStructureIDsToDimensionIDs.get((Object)structureID);
            buf.method_53002(dimensionIDs.size());
            for (class_2960 dimensionID : dimensionIDs) {
                buf.method_10812(dimensionID);
            }
            class_2960 groupID = this.structureIDsToGroupIDs.get(structureID);
            buf.method_10812(groupID);
        }
        buf.method_53002(this.groupIDsToStructureIDs.keySet().size());
        for (class_2960 groupID : this.groupIDsToStructureIDs.keySet()) {
            buf.method_10812(groupID);
            List structureIDs = this.groupIDsToStructureIDs.get((Object)groupID);
            buf.method_53002(structureIDs.size());
            for (class_2960 structureID : structureIDs) {
                buf.method_10812(structureID);
            }
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public static void apply(SyncPacket packet, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            ExplorersCompass.canTeleport = packet.canTeleport;
            ExplorersCompass.allowedStructureIDs = packet.allowedStructureIDs;
            ExplorersCompass.allowedStructureIDsToDimensionIDs = packet.allowedStructureIDsToDimensionIDs;
            ExplorersCompass.structureIDsToGroupIDs = packet.structureIDsToGroupIDs;
            ExplorersCompass.groupIDsToStructureIDs = packet.groupIDsToStructureIDs;
        });
    }
}

