/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_10179;
import net.minecraft.class_10583;
import net.minecraft.class_10598;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public class SkullSpirit
extends class_1297 {
    private static final class_2940<Optional<class_10583<class_1309>>> DATA_TARGETUUID_ID = class_2945.method_12791(SkullSpirit.class, (class_2941)class_2943.field_55584);
    private static final class_2940<Boolean> DATA_ATTACHED = class_2945.method_12791(SkullSpirit.class, (class_2941)class_2943.field_13323);
    private int startTick = 15;
    private int attachedTick = 80 + this.field_5974.method_43048(40);
    @Nullable
    private UUID conversionStarter;

    public SkullSpirit(class_1299<? extends SkullSpirit> type, class_1937 level) {
        super(type, level);
        this.field_5960 = true;
    }

    public SkullSpirit(class_1937 level, class_1308 target, @Nullable UUID conversionStarter) {
        this((class_1299<? extends SkullSpirit>)((class_1299)ModEntityTypes.SKULL_SPIRIT_ENTITY_TYPE.comp_349()), level);
        this.setTarget((class_1309)target);
        this.conversionStarter = conversionStarter;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_TARGETUUID_ID, Optional.empty());
        builder.method_56912(DATA_ATTACHED, (Object)false);
    }

    @Nullable
    public class_1309 getTarget() {
        return (class_1309)class_10583.method_66254(this.getTargetReference(), (class_10598)this.method_37908(), class_1309.class);
    }

    @Nullable
    public class_10583<class_1309> getTargetReference() {
        return ((Optional)this.field_6011.method_12789(DATA_TARGETUUID_ID)).orElse(null);
    }

    public void setTarget(@Nullable class_1309 livingEntity) {
        this.field_6011.method_12778(DATA_TARGETUUID_ID, Optional.ofNullable(livingEntity).map(class_10583::new));
    }

    public void setTargetReference(@Nullable class_10583<class_1309> entityReference) {
        this.field_6011.method_12778(DATA_TARGETUUID_ID, Optional.ofNullable(entityReference));
    }

    public boolean isAttached() {
        return (Boolean)this.field_6011.method_12789(DATA_ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.field_6011.method_12778(DATA_ATTACHED, (Object)attached);
    }

    public boolean method_5696() {
        return true;
    }

    public void method_5773() {
        class_1308 target;
        class_1309 class_13092 = this.getTarget();
        if (class_13092 instanceof class_1308 && (target = (class_1308)class_13092).method_5805()) {
            if (this.isAttached()) {
                if (!this.method_37908().field_9236) {
                    target.method_18800((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), target.method_18798().field_1351, (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f));
                    if (--this.attachedTick <= 0) {
                        class_1299<?> mutantType = ChemicalXMobEffect.getMutantOf(target);
                        if (mutantType != null && this.field_5974.method_43048(4) != 0) {
                            MutatedExplosionHelper.explode(this, 2.0f, false, class_1937.class_7867.field_40888);
                            class_1308 mob = target.method_29243(mutantType, class_10179.method_63607((class_1308)target, (boolean)true, (boolean)true), Function.identity()::apply);
                            if (mob != null) {
                                class_1657 player;
                                mob.method_5971();
                                class_238 boundingBox = mob.method_5829();
                                for (class_2338 pos : class_2338.method_10094((int)class_3532.method_15357((double)boundingBox.field_1323), (int)class_3532.method_15357((double)mob.method_23318()), (int)class_3532.method_15357((double)boundingBox.field_1321), (int)class_3532.method_15357((double)boundingBox.field_1320), (int)class_3532.method_15357((double)boundingBox.field_1325), (int)class_3532.method_15357((double)boundingBox.field_1324))) {
                                    if (!(this.method_37908().method_8320(pos).method_26214((class_1922)this.method_37908(), pos) > -1.0f)) continue;
                                    this.method_37908().method_22352(pos, true);
                                }
                                if (this.conversionStarter != null && (player = this.method_37908().method_18470(this.conversionStarter)) instanceof class_3222) {
                                    class_3222 serverPlayer = (class_3222)player;
                                    class_174.field_1182.method_9124(serverPlayer, (class_1297)mob);
                                }
                            }
                        } else {
                            this.setAttached(false);
                            MutatedExplosionHelper.explode(this, 2.0f, false, class_1937.class_7867.field_40888);
                        }
                        this.method_31472();
                    }
                }
                this.method_5814(target.method_23317(), target.method_23318(), target.method_23321());
                if (this.field_5974.method_43048(8) == 0) {
                    target.method_64419(this.method_37908().method_48963().method_48831(), 0.0f);
                }
                for (int i = 0; i < 3; ++i) {
                    double posX = target.method_23317() + (double)(this.field_5974.method_43057() * target.method_17681() * 2.0f) - (double)target.method_17681();
                    double posY = target.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * target.method_17682());
                    double posZ = target.method_23321() + (double)(this.field_5974.method_43057() * target.method_17681() * 2.0f) - (double)target.method_17681();
                    double x = this.field_5974.method_43059() * 0.02;
                    double y = this.field_5974.method_43059() * 0.02;
                    double z = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.comp_349(), posX, posY, posZ, x, y, z);
                }
            } else {
                double z;
                double y;
                double x;
                double d;
                this.field_6014 = this.method_23317();
                this.field_6036 = this.method_23318();
                this.field_5969 = this.method_23321();
                this.method_18799(class_243.field_1353);
                if (this.startTick-- >= 0) {
                    this.method_18799(this.method_18798().method_1031(0.0, (double)(0.3f * (float)this.startTick / 15.0f), 0.0));
                }
                if ((d = Math.sqrt((x = target.method_23317() - this.method_23317()) * x + (y = target.method_23318() - this.method_23318()) * y + (z = target.method_23321() - this.method_23321()) * z)) != 0.0) {
                    this.method_18799(this.method_18798().method_1031(x / d * 0.2, y / d * 0.2, z / d * 0.2));
                    this.method_5784(class_1313.field_6308, this.method_18798());
                }
                if (!this.method_37908().field_9236 && this.method_5858((class_1297)target) < 1.0) {
                    this.setAttached(true);
                }
                for (int i = 0; i < 16; ++i) {
                    float xx = (this.field_5974.method_43057() - 0.5f) * 1.2f;
                    float yy = (this.field_5974.method_43057() - 0.5f) * 1.2f;
                    float zz = (this.field_5974.method_43057() - 0.5f) * 1.2f;
                    this.method_37908().method_8406((class_2394)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.comp_349(), this.method_23317() + (double)xx, this.method_23318() + (double)yy, this.method_23321() + (double)zz, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.method_31472();
        }
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        return false;
    }

    protected void method_5652(class_11372 valueOutput) {
        valueOutput.method_71472("Attached", this.isAttached());
        valueOutput.method_71465("AttachedTick", this.attachedTick);
        class_10583<class_1309> entityReference = this.getTargetReference();
        if (entityReference != null) {
            entityReference.method_66259(valueOutput, "Target");
        }
        valueOutput.method_71477("ConversionPlayer", class_4844.field_25122, (Object)this.conversionStarter);
    }

    protected void method_5749(class_11368 valueInput) {
        this.setAttached(valueInput.method_71433("Attached", false));
        this.attachedTick = valueInput.method_71424("AttachedTick", 0);
        this.setTargetReference((class_10583<class_1309>)class_10583.method_66262((class_11368)valueInput, (String)"Target"));
        this.conversionStarter = valueInput.method_71426("ConversionPlayer", class_4844.field_25122).orElse(null);
    }
}

