/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantZombieRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.class_10017;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class MutantZombieModel
extends class_583<MutantZombieRenderState> {
    private final class_630 pelvis;
    private final class_630 waist;
    private final class_630 chest;
    private final class_630 head;
    private final class_630 arm1;
    private final class_630 arm2;
    private final class_630 forearm1;
    private final class_630 forearm2;
    private final class_630 leg1;
    private final class_630 leg2;

    public MutantZombieModel(class_630 modelPart) {
        super(modelPart);
        this.pelvis = modelPart.method_32086("pelvis");
        this.waist = this.pelvis.method_32086("waist");
        this.chest = this.waist.method_32086("chest");
        this.head = this.chest.method_32086("head");
        this.arm1 = this.chest.method_32086("arm1");
        this.arm2 = this.chest.method_32086("arm2");
        this.forearm1 = this.arm1.method_32086("fore_arm1");
        this.forearm2 = this.arm2.method_32086("fore_arm2");
        this.leg1 = this.pelvis.method_32086("leg1");
        this.leg2 = this.pelvis.method_32086("leg2");
    }

    public static class_5607 createBodyLayer() {
        class_5609 mesh = new class_5609();
        class_5610 partDefinition = mesh.method_32111();
        class_5610 pelvis = partDefinition.method_32117("pelvis", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)10.0f, (float)6.0f));
        class_5610 waist = pelvis.method_32117("waist", class_5606.method_32108().method_32101(0, 44).method_32097(-7.0f, -16.0f, -6.0f, 14.0f, 16.0f, 12.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.19634955f, (float)0.0f, (float)0.0f));
        class_5610 chest = waist.method_32117("chest", class_5606.method_32108().method_32101(0, 16).method_32097(-12.0f, -12.0f, -8.0f, 24.0f, 12.0f, 16.0f), class_5603.method_32091((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        chest.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), class_5603.method_32091((float)0.0f, (float)-11.0f, (float)-4.0f, (float)-0.71994835f, (float)0.0f, (float)0.0f));
        class_5610 arm1 = chest.method_32117("arm1", class_5606.method_32108().method_32101(104, 0).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f), class_5603.method_32091((float)-11.0f, (float)-8.0f, (float)2.0f, (float)-0.32724923f, (float)0.0f, (float)0.3926991f));
        class_5610 arm2 = chest.method_32117("arm2", class_5606.method_32108().method_32101(104, 0).method_32096().method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f), class_5603.method_32091((float)11.0f, (float)-8.0f, (float)2.0f, (float)-0.32724923f, (float)0.0f, (float)-0.3926991f));
        arm1.method_32117("fore_arm1", class_5606.method_32108().method_32101(104, 22).method_32098(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, new class_5605(0.1f)), class_5603.method_32091((float)0.0f, (float)14.0f, (float)0.0f, (float)-1.0471976f, (float)0.0f, (float)0.0f));
        arm2.method_32117("fore_arm2", class_5606.method_32108().method_32101(104, 22).method_32096().method_32098(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, new class_5605(0.1f)), class_5603.method_32091((float)0.0f, (float)14.0f, (float)0.0f, (float)-1.0471976f, (float)0.0f, (float)0.0f));
        class_5610 leg1 = pelvis.method_32117("leg1", class_5606.method_32108().method_32101(80, 0).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 11.0f, 6.0f), class_5603.method_32091((float)-5.0f, (float)-2.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        class_5610 leg2 = pelvis.method_32117("leg2", class_5606.method_32108().method_32101(80, 0).method_32096().method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 11.0f, 6.0f), class_5603.method_32091((float)5.0f, (float)-2.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        leg1.method_32117("fore_leg1", class_5606.method_32108().method_32101(80, 17).method_32098(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f, new class_5605(0.1f)), class_5603.method_32091((float)0.0f, (float)9.5f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        leg2.method_32117("fore_leg2", class_5606.method_32108().method_32101(80, 17).method_32096().method_32098(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f, new class_5605(0.1f)), class_5603.method_32091((float)0.0f, (float)9.5f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
    }

    public void setupAnim(MutantZombieRenderState renderState) {
        super.method_2819((class_10017)renderState);
        float walkAnim1 = (class_3532.method_15374((float)((renderState.field_53450 - 0.7f) * 0.4f)) + 0.7f) * renderState.field_53451;
        float walkAnim2 = -(class_3532.method_15374((float)((renderState.field_53450 + 0.7f) * 0.4f)) - 0.7f) * renderState.field_53451;
        float walkAnim = class_3532.method_15374((float)(renderState.field_53450 * 0.4f)) * renderState.field_53451;
        float breatheAnim = class_3532.method_15374((float)(renderState.field_53328 * 0.1f));
        float faceYaw = renderState.field_53447 * (float)Math.PI / 180.0f;
        float facePitch = renderState.field_53448 * (float)Math.PI / 180.0f;
        if (renderState.field_53449 <= 0.0f) {
            float scale;
            if (renderState.animation == MutantZombie.SLAM_GROUND_ANIMATION) {
                this.animateMelee(renderState);
            }
            if (renderState.animation == MutantZombie.ROAR_ANIMATION) {
                this.animateRoar(renderState);
                scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 6.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
            if (renderState.animation == MutantZombie.THROW_ANIMATION) {
                this.animateThrow(renderState);
                scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 3.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
        } else {
            this.animateDeath(renderState);
            float scale = 1.0f - class_3532.method_15363((float)(renderState.field_53449 / 6.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim *= scale;
            breatheAnim *= scale;
            faceYaw *= scale;
            facePitch *= scale;
        }
        this.chest.field_3654 += breatheAnim * 0.02f;
        this.arm1.field_3674 -= breatheAnim * 0.05f;
        this.arm2.field_3674 += breatheAnim * 0.05f;
        this.head.field_3654 += facePitch * 0.6f;
        this.head.field_3675 += faceYaw * 0.8f;
        this.head.field_3674 -= faceYaw * 0.2f;
        this.chest.field_3654 += facePitch * 0.4f;
        this.chest.field_3675 += faceYaw * 0.2f;
        this.pelvis.field_3656 += class_3532.method_15374((float)(renderState.field_53450 * 0.8f)) * renderState.field_53451 * 0.5f;
        this.chest.field_3675 -= walkAnim * 0.1f;
        this.arm1.field_3654 -= walkAnim * 0.6f;
        this.arm2.field_3654 += walkAnim * 0.6f;
        this.leg1.field_3654 += walkAnim1 * 0.9f;
        this.leg2.field_3654 += walkAnim2 * 0.9f;
    }

    private void animateMelee(MutantZombieRenderState renderState) {
        this.arm1.field_3674 = 0.0f;
        this.arm2.field_3674 = 0.0f;
        if (renderState.animationTime < 8.0f) {
            float tick = renderState.animationTime / 8.0f;
            float f = -class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.2f;
            this.chest.field_3654 += f * 0.2f;
            this.arm1.field_3654 += f * 2.3f;
            this.arm1.field_3674 += f1 * (float)Math.PI / 8.0f;
            this.arm2.field_3654 += f * 2.3f;
            this.arm2.field_3674 -= f1 * (float)Math.PI / 8.0f;
            this.forearm1.field_3654 += f * 0.8f;
            this.forearm2.field_3654 += f * 0.8f;
        } else if (renderState.animationTime < 12.0f) {
            float tick = (renderState.animationTime - 8.0f) / 4.0f;
            float f = -class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.9f + 0.7f;
            this.chest.field_3654 += f * 0.9f + 0.7f;
            this.arm1.field_3654 += f * 0.2f - 2.1f;
            this.arm1.field_3674 += f1 * 0.3f;
            this.arm2.field_3654 += f * 0.2f - 2.1f;
            this.arm2.field_3674 -= f1 * 0.3f;
            this.forearm1.field_3654 += f + 0.2f;
            this.forearm2.field_3654 += f + 0.2f;
        } else if (renderState.animationTime < 16.0f) {
            this.waist.field_3654 += 0.7f;
            this.chest.field_3654 += 0.7f;
            this.arm1.field_3654 -= 2.1f;
            this.arm1.field_3674 += 0.3f;
            this.arm2.field_3654 -= 2.1f;
            this.arm2.field_3674 -= 0.3f;
            this.forearm1.field_3654 += 0.2f;
            this.forearm2.field_3654 += 0.2f;
        } else if (renderState.animationTime < 24.0f) {
            float tick = (renderState.animationTime - 16.0f) / 8.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.7f;
            this.chest.field_3654 += f * 0.7f;
            this.arm1.field_3654 -= f * 2.1f;
            this.arm1.field_3674 += f * -0.09269908f + 0.3926991f;
            this.arm2.field_3654 -= f * 2.1f;
            this.arm2.field_3674 -= f * -0.09269908f + 0.3926991f;
            this.forearm1.field_3654 += f * 0.2f;
            this.forearm2.field_3654 += f * 0.2f;
        } else {
            this.arm1.field_3674 += 0.3926991f;
            this.arm2.field_3674 += -0.3926991f;
        }
    }

    private void animateRoar(MutantZombieRenderState renderState) {
        float f1;
        float f;
        float tick;
        if (renderState.animationTime < 10.0f) {
            tick = renderState.animationTime / 10.0f;
            f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            f1 = class_3532.method_15374((float)(tick * (float)Math.PI * (float)Math.PI / 8.0f));
            this.waist.field_3654 += f * 0.2f;
            this.chest.field_3654 += f * 0.4f;
            this.chest.field_3675 += f1 * 0.06f;
            this.head.field_3654 += f * 0.8f;
            this.arm1.field_3654 -= f * 1.2f;
            this.arm1.field_3674 += f * 0.6f;
            this.arm2.field_3654 -= f * 1.2f;
            this.arm2.field_3674 -= f * 0.6f;
            this.forearm1.field_3654 -= f * 0.8f;
            this.forearm2.field_3654 -= f * 0.8f;
        } else if (renderState.animationTime < 15.0f) {
            tick = (renderState.animationTime - 10.0f) / 5.0f;
            f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.39634955f - 0.19634955f;
            this.chest.field_3654 += f * 0.6f - 0.2f;
            this.head.field_3654 += f - 0.2f;
            this.arm1.field_3654 -= f * 2.2f - 1.0f;
            this.arm1.field_3675 += f1 * 0.4f;
            this.arm1.field_3674 += 0.6f;
            this.arm2.field_3654 -= f * 2.2f - 1.0f;
            this.arm2.field_3675 -= f1 * 0.4f;
            this.arm2.field_3674 -= 0.6f;
            this.forearm1.field_3654 -= f - 0.2f;
            this.forearm2.field_3654 -= f - 0.2f;
            this.leg1.field_3675 += f1 * 0.3f;
            this.leg2.field_3675 -= f1 * 0.3f;
        } else if (renderState.animationTime < 75.0f) {
            this.waist.field_3654 -= 0.19634955f;
            this.chest.field_3654 -= 0.2f;
            this.head.field_3654 -= 0.2f;
            Animator.addRotationAngle(this.arm1, 1.0f, 0.4f, 0.6f);
            Animator.addRotationAngle(this.arm2, 1.0f, -0.4f, -0.6f);
            this.forearm1.field_3654 += 0.2f;
            this.forearm2.field_3654 += 0.2f;
            this.leg1.field_3675 += 0.3f;
            this.leg2.field_3675 -= 0.3f;
        } else if (renderState.animationTime < 90.0f) {
            tick = (renderState.animationTime - 75.0f) / 15.0f;
            f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 -= f * 0.69634956f - 0.5f;
            this.chest.field_3654 -= f * 0.7f - 0.5f;
            this.head.field_3654 -= f * 0.6f - 0.4f;
            Animator.addRotationAngle(this.arm1, f * 2.6f - 1.6f, f * 0.4f, f * 0.99269915f - 0.3926991f);
            Animator.addRotationAngle(this.arm2, f * 2.6f - 1.6f, -f * 0.4f, -f * 0.99269915f + 0.3926991f);
            this.forearm1.field_3654 += f * -0.6f + 0.8f;
            this.forearm2.field_3654 += f * -0.6f + 0.8f;
            this.leg1.field_3675 += f * 0.3f;
            this.leg2.field_3675 -= f * 0.3f;
        } else if (renderState.animationTime < 110.0f) {
            this.waist.field_3654 += 0.5f;
            this.chest.field_3654 += 0.5f;
            this.head.field_3654 += 0.4f;
            Animator.addRotationAngle(this.arm1, -1.6f, 0.0f, -0.3926991f);
            Animator.addRotationAngle(this.arm2, -1.6f, 0.0f, 0.3926991f);
            this.forearm1.field_3654 += 0.8f;
            this.forearm2.field_3654 += 0.8f;
        } else {
            tick = (renderState.animationTime - 110.0f) / 10.0f;
            f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.5f;
            this.chest.field_3654 += f * 0.5f;
            this.head.field_3654 += f * 0.4f;
            Animator.addRotationAngle(this.arm1, f * -1.6f, 0.0f, f * (float)(-Math.PI) / 8.0f);
            Animator.addRotationAngle(this.arm2, f * -1.6f, 0.0f, f * (float)Math.PI / 8.0f);
            this.forearm1.field_3654 += f * 0.8f;
            this.forearm2.field_3654 += f * 0.8f;
        }
        if (renderState.animationTime >= 10.0f && renderState.animationTime < 75.0f) {
            tick = (renderState.animationTime - 10.0f) / 65.0f;
            f = class_3532.method_15374((float)(tick * (float)Math.PI * 8.0f));
            f1 = class_3532.method_15374((float)(tick * (float)Math.PI * 8.0f + 0.7853982f));
            this.head.field_3675 += f * 0.5f - f1 * 0.2f;
            this.head.field_3674 -= f * 0.5f;
            this.chest.field_3675 += f1 * 0.06f;
        }
    }

    private void animateThrow(MutantZombieRenderState renderState) {
        if (renderState.animationTime < 3.0f) {
            float tick = renderState.animationTime / 3.0f;
            float f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_3654 -= f * 0.4f;
            this.arm1.field_3654 -= f * 1.8f;
            this.arm1.field_3674 -= f * (float)Math.PI / 8.0f;
            this.arm2.field_3654 -= f * 1.8f;
            this.arm2.field_3674 += f * (float)Math.PI / 8.0f;
        } else if (renderState.animationTime < 5.0f) {
            this.chest.field_3654 -= 0.4f;
            this.arm1.field_3654 -= 1.0f;
            this.arm1.field_3674 = 0.0f;
            this.arm2.field_3654 -= 1.0f;
            this.arm2.field_3674 = 0.0f;
        } else if (renderState.animationTime < 8.0f) {
            float tick = (renderState.animationTime - 5.0f) / 3.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f1 * 0.2f;
            this.chest.field_3654 -= f * 0.6f - 0.2f;
            this.arm1.field_3654 -= f * 2.2f - 0.4f;
            this.arm1.field_3674 -= f * (float)Math.PI / 8.0f;
            this.arm2.field_3654 -= f * 2.2f - 0.4f;
            this.arm2.field_3674 += f * (float)Math.PI / 8.0f;
            this.forearm1.field_3654 -= f1 * 0.4f;
            this.forearm2.field_3654 -= f1 * 0.4f;
        } else if (renderState.animationTime < 10.0f) {
            this.waist.field_3654 += 0.2f;
            this.chest.field_3654 += 0.2f;
            this.arm1.field_3654 += 0.4f;
            this.arm2.field_3654 += 0.4f;
            this.forearm1.field_3654 -= 0.4f;
            this.forearm2.field_3654 -= 0.4f;
        } else if (renderState.animationTime < 15.0f) {
            float tick = (renderState.animationTime - 10.0f) / 5.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.39634955f - 0.19634955f;
            this.chest.field_3654 += f * 0.8f - 0.6f;
            this.arm1.field_3654 += f * 3.0f - 2.6f;
            this.arm2.field_3654 += f * 3.0f - 2.6f;
            this.forearm1.field_3654 -= f * 0.4f;
            this.forearm2.field_3654 -= f * 0.4f;
            this.leg1.field_3654 += f1 * 0.6f;
            this.leg2.field_3654 += f1 * 0.6f;
        } else if (renderState.throwHitTime == -1.0f) {
            this.waist.field_3654 -= 0.19634955f;
            this.chest.field_3654 -= 0.6f;
            this.arm1.field_3654 -= 2.6f;
            this.arm2.field_3654 -= 2.6f;
            this.leg1.field_3654 += 0.6f;
            this.leg2.field_3654 += 0.6f;
        } else if (renderState.throwHitTime < 5.0f) {
            float tick = renderState.throwHitTime / 3.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 -= f * 0.39634955f - 0.2f;
            this.chest.field_3654 -= f * 0.8f - 0.2f;
            Animator.addRotationAngle(this.arm1, -(f * 2.2f + 0.4f), -f1 * (float)Math.PI / 8.0f, f1 * 0.4f);
            Animator.addRotationAngle(this.arm2, -(f * 2.2f + 0.4f), f1 * (float)Math.PI / 8.0f, -f1 * 0.4f);
            this.forearm1.field_3654 += f1 * 0.2f;
            this.forearm2.field_3654 += f1 * 0.2f;
            this.leg1.field_3654 += f * 0.8f - 0.2f;
            this.leg2.field_3654 += f * 0.8f - 0.2f;
        } else if (renderState.throwFinishTime == -1.0f) {
            this.waist.field_3654 += 0.2f;
            this.chest.field_3654 += 0.2f;
            Animator.addRotationAngle(this.arm1, -0.4f, -0.3926991f, 0.4f);
            Animator.addRotationAngle(this.arm2, -0.4f, 0.3926991f, -0.4f);
            this.forearm1.field_3654 += 0.2f;
            this.forearm2.field_3654 += 0.2f;
            this.leg1.field_3654 -= 0.2f;
            this.leg2.field_3654 -= 0.2f;
        } else if (renderState.throwFinishTime < 10.0f) {
            float tick = renderState.throwFinishTime / 10.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.waist.field_3654 += f * 0.2f;
            this.chest.field_3654 += f * 0.2f;
            Animator.addRotationAngle(this.arm1, -f * 0.4f, -f * (float)Math.PI / 8.0f, f * 0.4f);
            Animator.addRotationAngle(this.arm1, -f * 0.4f, f * (float)Math.PI / 8.0f, -f * 0.4f);
            this.forearm1.field_3654 += f * 0.2f;
            this.forearm2.field_3654 += f * 0.2f;
            this.leg1.field_3654 -= f * 0.2f;
            this.leg2.field_3654 -= f * 0.2f;
        }
    }

    private void animateDeath(MutantZombieRenderState renderState) {
        if (renderState.field_53449 <= 20.0f) {
            float tick = (renderState.field_53449 - 1.0f) / 20.0f;
            float f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.field_3656 += f * 28.0f;
            this.head.field_3654 -= f * (float)Math.PI / 10.0f;
            this.head.field_3675 += f * (float)Math.PI / 5.0f;
            this.chest.field_3654 -= f * (float)Math.PI / 12.0f;
            this.waist.field_3654 -= f * (float)Math.PI / 10.0f;
            this.arm1.field_3654 -= f * (float)Math.PI / 2.0f;
            this.arm1.field_3675 += f * (float)Math.PI / 2.8f;
            this.arm2.field_3654 -= f * (float)Math.PI / 2.0f;
            this.arm2.field_3675 -= f * (float)Math.PI / 2.8f;
            this.leg1.field_3654 += f * (float)Math.PI / 6.0f;
            this.leg1.field_3674 += f * (float)Math.PI / 12.0f;
            this.leg2.field_3654 += f * (float)Math.PI / 6.0f;
            this.leg2.field_3674 -= f * (float)Math.PI / 12.0f;
        } else if (renderState.field_53449 <= 100.0f) {
            this.pelvis.field_3656 += 28.0f;
            this.head.field_3654 -= 0.31415927f;
            this.head.field_3675 += 0.62831855f;
            this.chest.field_3654 -= 0.2617994f;
            this.waist.field_3654 -= 0.31415927f;
            this.arm1.field_3654 -= 1.0f;
            this.arm1.field_3675 += 1.0f;
            this.arm2.field_3654 -= 1.0f;
            this.arm2.field_3675 -= 1.0f;
            this.leg1.field_3654 += 0.5235988f;
            this.leg1.field_3674 += 0.2617994f;
            this.leg2.field_3654 += 0.5235988f;
            this.leg2.field_3674 -= 0.2617994f;
        } else {
            float tick = (40.0f - (140.0f - renderState.field_53449)) / 40.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.field_3656 += f * 28.0f;
            this.head.field_3654 -= f * (float)Math.PI / 10.0f;
            this.head.field_3675 += f * (float)Math.PI / 5.0f;
            this.chest.field_3654 -= f * (float)Math.PI / 12.0f;
            this.waist.field_3654 -= f * (float)Math.PI / 10.0f;
            this.arm1.field_3654 -= f * (float)Math.PI / 2.0f;
            this.arm1.field_3675 += f * (float)Math.PI / 2.8f;
            this.arm2.field_3654 -= f * (float)Math.PI / 2.0f;
            this.arm2.field_3675 -= f * (float)Math.PI / 2.8f;
            this.leg1.field_3654 += f * (float)Math.PI / 6.0f;
            this.leg1.field_3674 += f * (float)Math.PI / 12.0f;
            this.leg2.field_3654 += f * (float)Math.PI / 6.0f;
            this.leg2.field_3674 -= f * (float)Math.PI / 12.0f;
        }
    }
}

