/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.SlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_2487;

public class TanksUpgrade
extends UpgradeBase<TanksUpgrade> {
    private final ItemStackHandler fluidSlotsHandler = this.createTemporaryHandler();
    protected final FluidTank leftTank = this.createFluidHandler(1000);
    protected final FluidTank rightTank = this.createFluidHandler(1000);
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TanksUpgrade(UpgradeManager manager, int dataHolderSlot, Fluids fluids) {
        super(manager, dataHolderSlot, new Point(51, 72));
        this.setTanksCapacity();
        this.setFluids(fluids);
        this.leftTankPos = new Point(7, 15);
        this.rightTankPos = new Point(195 + (manager.getWrapper().isExtended() ? 36 : 0), 15);
        this.getUpgradeManager().getWrapper().setRenderInfo(this.writeToRenderData());
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlotsHandler;
    }

    public void setTanksCapacity() {
        this.leftTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
        this.rightTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
    }

    public void setFluids(Fluids tanks) {
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setFluid(tanks.rightFluidStack());
    }

    public void syncClients(class_1799 backpack) {
        int slot = this.getDataHolderSlot();
        BackpackContainerContents contents = (BackpackContainerContents)backpack.method_58694(ModDataComponents.UPGRADES);
        if (contents == null) {
            return;
        }
        if (slot >= contents.getItems().size()) {
            return;
        }
        class_1799 stack = (class_1799)contents.getItems().get(slot);
        this.setFluids((Fluids)stack.method_58695(ModDataComponents.FLUIDS, (Object)Fluids.empty()));
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            @Override
            protected void onContentsChanged() {
                TanksUpgrade.this.updateDataHolderUnchecked(ModDataComponents.FLUIDS, new Fluids(TanksUpgrade.this.leftTank.getFluid(), TanksUpgrade.this.rightTank.getFluid()));
                TanksUpgrade.this.getUpgradeManager().getWrapper().setRenderInfo(TanksUpgrade.this.writeToRenderData());
                TanksUpgrade.this.getUpgradeManager().getWrapper().sendDataToClients(ModDataComponents.RENDER_INFO, ModDataComponents.UPGRADES);
            }
        };
    }

    public class_2487 writeToRenderData() {
        class_2487 tag = new class_2487();
        tag.method_10566("LeftTank", this.leftTank.getFluid().saveOptional(this.getUpgradeManager().getWrapper().getRegistriesAccess()));
        tag.method_10566("RightTank", this.rightTank.getFluid().saveOptional(this.getUpgradeManager().getWrapper().getRegistriesAccess()));
        tag.method_10544("Capacity", this.leftTank.getCapacity());
        return tag;
    }

    @Override
    public void remove() {
        this.getUpgradeManager().getWrapper().removeRenderInfo();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new TankWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<SlotItemHandler> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<SlotItemHandler> slots = new ArrayList<SlotItemHandler>();
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 0, x + 7, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 1, x + 7, y + 49));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 2, x + 28, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 3, x + 28, y + 49));
        return slots;
    }

    public ItemStackHandler createTemporaryHandler() {
        return new ItemStackHandler(this, 4){

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
                if (slot == 1 || slot == 3) {
                    return false;
                }
                if (stack.method_7909() instanceof class_1812 || stack.method_7909() == class_1802.field_8469 || stack.method_7909() == class_1802.field_8103) {
                    return true;
                }
                return storage != null;
            }
        };
    }
}

