/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.energy.idsu;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;
import techreborn.config.TechRebornConfig;

public class IDSUManager
extends class_18 {
    public static Codec<IDSUManager> CODEC = Codec.list(IDSUPlayer.CODEC).xmap(IDSUManager::fromIDSUPlayers, IDSUManager::getPlayers);
    private static final class_10741<IDSUManager> TYPE = new class_10741("techreborn_idsu", IDSUManager::new, CODEC, null);
    private static final String KEY = "techreborn_idsu";
    private final HashMap<String, IDSUPlayer> playerHashMap = new HashMap();

    private IDSUManager() {
    }

    @NotNull
    public static IDSUPlayer getPlayer(MinecraftServer server, String uuid) {
        return IDSUManager.get(server).getPlayer(uuid);
    }

    private static IDSUManager get(MinecraftServer server) {
        class_3218 serverWorld = server.method_3847(class_1937.field_25179);
        return (IDSUManager)serverWorld.method_17983().method_17924(TYPE);
    }

    @NotNull
    public IDSUPlayer getPlayer(String uuid) {
        return this.playerHashMap.computeIfAbsent(uuid, s -> new IDSUPlayer(uuid, () -> ((IDSUManager)this).method_80()));
    }

    public static IDSUManager fromIDSUPlayers(List<IDSUPlayer> list) {
        IDSUManager idsuManager = new IDSUManager();
        for (IDSUPlayer player : list) {
            player.setMarkDirty(() -> ((IDSUManager)idsuManager).method_80());
            idsuManager.playerHashMap.put(player.getUUID(), player);
        }
        return idsuManager;
    }

    public List<IDSUPlayer> getPlayers() {
        return this.playerHashMap.values().stream().toList();
    }

    public static class IDSUPlayer {
        public static Codec<IDSUPlayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("uuid").forGetter(IDSUPlayer::getUUID), (App)Codec.LONG.fieldOf("energy").forGetter(IDSUPlayer::getEnergy)).apply((Applicative)instance, IDSUPlayer::new));
        private String uuid;
        private Runnable markDirty;
        private final SimpleEnergyStorage storage;

        private IDSUPlayer(String uuid, Runnable markDirty) {
            this.markDirty = () -> {};
            this.storage = new SimpleEnergyStorage(this, TechRebornConfig.idsuMaxEnergy, Long.MAX_VALUE, Long.MAX_VALUE){
                final /* synthetic */ IDSUPlayer this$0;
                {
                    this.this$0 = this$0;
                    super(arg0, arg1, arg2);
                }

                protected void onFinalCommit() {
                    this.this$0.markDirty.run();
                }
            };
            this.uuid = uuid;
            this.markDirty = markDirty;
        }

        public IDSUPlayer(String uuid, Long energy) {
            this.markDirty = () -> {};
            this.storage = new /* invalid duplicate definition of identical inner class */;
            this.uuid = uuid;
            this.storage.amount = energy;
        }

        public void setMarkDirty(Runnable markDirty) {
            this.markDirty = markDirty;
        }

        public EnergyStorage getStorage() {
            return this.storage;
        }

        public long getEnergy() {
            return this.storage.amount;
        }

        public String getUUID() {
            return this.uuid;
        }

        public void setEnergy(long energy) {
            this.storage.amount = energy;
            this.markDirty.run();
        }
    }
}

