/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record MixingRecipe(class_1799 result, FluidStack fluidResult, HeatCondition heat, List<FluidIngredient> fluidIngredients, List<SizedIngredient> ingredients) implements BasinRecipe
{
    @Override
    public int getIngredientSize() {
        return this.fluidIngredients.size() + this.ingredients().size();
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public boolean matches(BasinInput input, class_1937 world) {
        if (!this.heat.testBlazeBurner(input.heat())) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, this.ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredients)) {
            return false;
        }
        if (!this.result.method_7960()) {
            outputs.add(this.result);
        }
        List<FluidStack> fluids = this.fluidResult.isEmpty() ? List.of() : List.of(this.fluidResult);
        return input.acceptOutputs(outputs, fluids, true);
    }

    @Override
    public boolean apply(BasinInput input) {
        List<FluidStack> fluids;
        if (!this.heat.testBlazeBurner(input.heat())) {
            return false;
        }
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, this.ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredients, changes)) {
            return false;
        }
        if (!this.result.method_7960()) {
            outputs.add(this.result);
        }
        List<FluidStack> list = fluids = this.fluidResult.isEmpty() ? List.of() : List.of(this.fluidResult);
        if (!input.acceptOutputs(outputs, fluids, true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, fluids, false);
    }

    public class_1865<MixingRecipe> method_8119() {
        return AllRecipeSerializers.MIXING;
    }

    public class_3956<MixingRecipe> method_17716() {
        return AllRecipeTypes.MIXING;
    }

    public static class Serializer
    implements class_1865<MixingRecipe> {
        public static final MapCodec<MixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_24671.optionalFieldOf("result", (Object)class_1799.field_8037).forGetter(MixingRecipe::result), (App)FluidStack.CODEC.optionalFieldOf("fluid_result", (Object)FluidStack.EMPTY).forGetter(MixingRecipe::fluidResult), (App)HeatCondition.CODEC.optionalFieldOf("heat_requirement", (Object)HeatCondition.NONE).forGetter(MixingRecipe::heat), (App)FluidIngredient.CODEC.listOf(0, 2).optionalFieldOf("fluid_ingredients", List.of()).forGetter(MixingRecipe::fluidIngredients), (App)SizedIngredient.getListCodec(0, 4).optionalFieldOf("ingredients", List.of()).forGetter(MixingRecipe::ingredients)).apply((Applicative)instance, MixingRecipe::new)).validate(recipe -> {
            if (recipe.result.method_7960() && recipe.fluidResult.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a result or a fluid result");
            }
            if (recipe.fluidIngredients.isEmpty() && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a result or a fluid ingredient");
            }
            return DataResult.success((Object)recipe);
        });
        private static final class_9139<class_9129, MixingRecipe> PACKET_CODEC = class_9139.method_56906((class_9139)class_1799.field_49268, MixingRecipe::result, FluidStack.OPTIONAL_PACKET_CODEC, MixingRecipe::fluidResult, HeatCondition.PACKET_CODEC, MixingRecipe::heat, (class_9139)FluidIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), MixingRecipe::fluidIngredients, (class_9139)SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), MixingRecipe::ingredients, MixingRecipe::new);

        public MapCodec<MixingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, MixingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

