/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record CompactingRecipe(class_1799 result, @Nullable FluidIngredient fluidIngredient, List<SizedIngredient> ingredients) implements BasinRecipe
{
    @Override
    public int getIngredientSize() {
        return (this.fluidIngredient == null ? 0 : 1) + this.ingredients.size();
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredient == null ? List.of() : List.of(this.fluidIngredient);
    }

    public boolean matches(BasinInput input, class_1937 world) {
        List<class_1799> outputs = BasinRecipe.tryCraft(input, this.ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredient)) {
            return false;
        }
        outputs.add(this.result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Override
    public boolean apply(BasinInput input) {
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, this.ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredient, changes)) {
            return false;
        }
        outputs.add(this.result);
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    public class_1865<CompactingRecipe> method_8119() {
        return AllRecipeSerializers.COMPACTING;
    }

    public class_3956<CompactingRecipe> method_17716() {
        return AllRecipeTypes.COMPACTING;
    }

    public static class Serializer
    implements class_1865<CompactingRecipe> {
        public static final MapCodec<CompactingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_24671.fieldOf("result").forGetter(CompactingRecipe::result), (App)FluidIngredient.CODEC.optionalFieldOf("fluid_ingredient").forGetter(Serializer::getOptionalFluidIngredient), (App)SizedIngredient.getListCodec(1, 9).optionalFieldOf("ingredients", List.of()).forGetter(CompactingRecipe::ingredients)).apply((Applicative)instance, Serializer::createRecipe)).validate(recipe -> {
            if (recipe.fluidIngredient == null && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a result or a fluid ingredient");
            }
            return DataResult.success((Object)recipe);
        });
        public static final class_9139<class_9129, CompactingRecipe> PACKET_CODEC = class_9139.method_56436((class_9139)class_1799.field_48349, CompactingRecipe::result, (class_9139)FluidIngredient.PACKET_CODEC.method_56433(class_9135::method_56382), Serializer::getOptionalFluidIngredient, (class_9139)SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), CompactingRecipe::ingredients, Serializer::createRecipe);

        private static Optional<FluidIngredient> getOptionalFluidIngredient(CompactingRecipe recipe) {
            return Optional.ofNullable(recipe.fluidIngredient);
        }

        private static CompactingRecipe createRecipe(class_1799 result, Optional<FluidIngredient> fluidIngredient, List<SizedIngredient> ingredients) {
            return new CompactingRecipe(result, fluidIngredient.orElse(null), ingredients);
        }

        public MapCodec<CompactingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CompactingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

