/*
 * Decompiled with CFR 0.152.
 */
package smsk.smoothscroll.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import smsk.smoothscroll.SmoothSc;
import smsk.smoothscroll.cfg.CfgValue;
import smsk.smoothscroll.cfg.CfgValueBuilder;
import smsk.smoothscroll.cfg.NewConfig;

public class SmScCfg
extends NewConfig {
    public static final float format = 2.2f;
    public static float hotbarSmoothness;
    public static float chatSmoothness;
    public static float chatOpeningSmoothness;
    public static float suggestionWindowSmoothness;
    public static float suggestionWindowAmount;
    public static float creativeScreenSmoothness;
    public static float entryListSmoothness;
    public static double entryListAmount;
    public static boolean enableMaskDebug;
    public static boolean hotbarRollover;
    static CfgValue template;

    public SmScCfg() {
        super("smoothscroll.json", template);
    }

    @Override
    void intoVariables() {
        hotbarSmoothness = ((Float)this.root.get("Hotbar").get("Smoothness").getValue()).floatValue();
        hotbarRollover = (Boolean)this.root.get("Hotbar").get("Rollover").getValue();
        chatSmoothness = ((Float)this.root.get("Chat").get("Smoothness").getValue()).floatValue();
        chatOpeningSmoothness = ((Float)this.root.get("Chat").get("Opening Speed").getValue()).floatValue();
        suggestionWindowSmoothness = ((Float)this.root.get("Chat").get("Suggestion Smoothness").getValue()).floatValue();
        suggestionWindowAmount = ((Float)this.root.get("Chat").get("Suggestion Speed").getValue()).floatValue();
        creativeScreenSmoothness = ((Float)this.root.get("Creative Screen").get("Smoothness").getValue()).floatValue();
        entryListSmoothness = ((Float)this.root.get("Entry List").get("Smoothness").getValue()).floatValue();
        entryListAmount = ((Float)this.root.get("Entry List").get("Speed").getValue()).floatValue();
        enableMaskDebug = (Boolean)this.root.get("Misc").get("Enable mask debug").getValue();
    }

    @Override
    void dataCorrectPermanent() {
        if (this.rawRoot.get("cfgVersion").exists() && this.rawRoot.get("cfgVersion").getValue() instanceof Float) {
            SmoothSc.print("Found old format entries in the config file, attempting to update them.");
            float cfgver = ((Float)this.rawRoot.get("cfgVersion").getValue()).floatValue();
            CfgValue a = this.rawRoot.get("hotbarSpeed");
            if (a.exists() && a.getValue() instanceof Float) {
                SmoothSc.print(a.getValue());
                if (cfgver < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                this.root.get("Hotbar").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("chatSpeed")).exists() && a.getValue() instanceof Float) {
                if (cfgver < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                this.root.get("Chat").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("chatOpeningSpeed")).exists() && a.getValue() instanceof Float) {
                this.root.get("Chat").get("Opening Speed").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("creativeScreenSpeed")).exists() && a.getValue() instanceof Float) {
                if (cfgver < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                this.root.get("Creative Screen").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("entryListSpeed")).exists() && a.getValue() instanceof Float) {
                if (cfgver < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                if (cfgver < 1.9f && ((Float)a.getValue()).floatValue() == 0.334f) {
                    a.setValue(Float.valueOf(0.5f));
                }
                this.root.get("Entry List").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("enableMaskDebug")).exists() && a.getValue() instanceof Float) {
                this.root.get("Chat").get("Smoothness").setValue(a.getValue());
            }
        }
        this.root.get("Notes").defaultToTemp();
        this.root.get("Format").defaultToTemp();
    }

    @Override
    void dataCorrectTemporary() {
        if (SmoothSc.isSmoothScrollingRefurbishedLoaded) {
            entryListSmoothness = 0.0f;
        }
    }

    @Override
    void problemReading() {
        super.problemReading();
        SmoothSc.print("There was a problem reading the config file. Using default values.");
    }

    @Override
    void problemWriting() {
        super.problemWriting();
        SmoothSc.print("There was a problem writing to the config file.");
    }

    @Override
    void fileNotFound() {
        super.fileNotFound();
        SmoothSc.print("There is no config file, creating a new one.");
    }

    static {
        template = new CfgValueBuilder("root", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Notes", new ArrayList<String>(Arrays.asList("Safe values for settings are 0 - 1 (inclusive).", "0 means animation off (no smoothness) and bigger values mean slower animation speed (high smoothness).", "Press F3+T in a world to update the config.", "To access config ingame, use the mod modmenu."))).build(), new CfgValueBuilder("Hotbar", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(0.2f)).minMax(0.0f, 1.0f).map(0.0, "Off").map(1.0, "No Scrolling").build(), new CfgValueBuilder("Rollover", true).build()))).build(), new CfgValueBuilder("Chat", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(0.5f)).minMax(0.0f, 1.0f).map(0.0, "Off").map(1.0, "No Scrolling").build(), new CfgValueBuilder("Opening Speed", Float.valueOf(0.5f)).minMax(0.0f, 1.0f).map(0.0, "Off").map(1.0, "No Scrolling").build(), new CfgValueBuilder("Suggestion Smoothness", Float.valueOf(0.5f)).minMax(0.0f, 1.0f).map(0.0, "Off").map(1.0, "No Scrolling").build(), new CfgValueBuilder("Suggestion Speed", Float.valueOf(30.0f)).minMax(0.0f, 100.0f).step(1.0).format("%s: %s px").map(0.0, "Auto").build()))).build(), new CfgValueBuilder("Creative Screen", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(0.5f)).minMax(0.0f, 1.0f).map(0.0, "Off").map(1.0, "No Scrolling").build()))).build(), new CfgValueBuilder("Entry List", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(0.5f)).minMax(0.0f, 1.0f).map(0.0, "Off").map(1.0, "No Scrolling").build(), new CfgValueBuilder("Speed", Float.valueOf(30.0f)).minMax(0.0f, 100.0f).step(1.0).format("%s: %s px").map(0.0, "Auto").build()))).build(), new CfgValueBuilder("Misc", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Enable mask debug", false).build()))).build(), new CfgValueBuilder("Format", Float.valueOf(2.2f)).build()))).build();
    }
}

