/*
 * Decompiled with CFR 0.152.
 */
package smsk.smoothscroll.cfg;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import net.fabricmc.loader.api.FabricLoader;
import smsk.smoothscroll.cfg.CfgValue;

public class NewConfig {
    private final Gson gs = new GsonBuilder().setPrettyPrinting().create();
    String fileName;
    CfgValue root;
    CfgValue rawRoot = CfgValue.parseJson("root", null);

    public NewConfig(String file, CfgValue template) {
        this.fileName = file;
        this.root = template;
        this.loadAndSave();
    }

    public void loadAndSave() {
        boolean dontSave = this.fromFile();
        try {
            this.dataCorrectPermanent();
            if (!dontSave) {
                this.toFile();
            }
            this.intoVariables();
            this.dataCorrectTemporary();
        }
        catch (Exception e) {
            this.problemReading();
            e.printStackTrace();
        }
    }

    public void save() {
        this.toFile();
        this.intoVariables();
        this.dataCorrectTemporary();
    }

    boolean fromFile() {
        File cfgfile = FabricLoader.getInstance().getConfigDir().resolve(this.fileName).toFile();
        Scanner scnr = null;
        boolean dontSave = false;
        if (cfgfile.exists()) {
            try {
                scnr = new Scanner(cfgfile);
                scnr.useDelimiter("\\Z");
                String data = scnr.next();
                JsonObject jsonData = (JsonObject)this.gs.fromJson(data, JsonObject.class);
                this.rawRoot = CfgValue.parseJson("root", (JsonElement)jsonData);
                this.root.matchValues(this.rawRoot);
            }
            catch (FileNotFoundException e) {
                this.fileNotFound();
                e.printStackTrace();
            }
            catch (Exception e) {
                this.problemReading();
                e.printStackTrace();
                dontSave = true;
            }
            if (scnr != null) {
                scnr.close();
            }
        } else {
            this.fileNotFound();
        }
        return dontSave;
    }

    void toFile() {
        File cfgfile = FabricLoader.getInstance().getConfigDir().resolve(this.fileName).toFile();
        FileWriter fw = null;
        try {
            fw = new FileWriter(cfgfile);
            fw.write(this.gs.toJson(CfgValue.exportJson(this.root)));
        }
        catch (Exception e) {
            this.problemWriting();
            e.printStackTrace();
        }
        try {
            if (fw != null) {
                fw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CfgValue getConfigForModifying() {
        return this.root;
    }

    void problemWriting() {
    }

    void problemReading() {
    }

    void fileNotFound() {
        this.toFile();
    }

    void dataCorrectPermanent() {
    }

    void intoVariables() {
    }

    void dataCorrectTemporary() {
    }
}

