/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.advancedreborn.tile;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import net.pitan76.advancedreborn.Blocks;
import net.pitan76.advancedreborn.Tiles;
import net.pitan76.advancedreborn.addons.autoconfig.AutoConfigAddon;
import net.pitan76.advancedreborn.inventory.IInventory;
import net.pitan76.advancedreborn.tile.base.HeatMachineTile;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.RecipeUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;

public class InductionFurnaceTile
extends HeatMachineTile
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public class_2248 toolDrop = (class_2248)Blocks.INDUCTION_FURNACE.getOrNull();
    public int energySlot = 4;
    int inputSlot = 0;
    int inputSlot2 = 1;
    int outputSlot = 2;
    int outputSlot2 = 3;
    public RebornInventory<?> inventory = new RebornInventory(5, "InductionFurnaceTile", 64, (MachineBaseBlockEntity)this);
    int ticksSinceLastChange;
    private class_3861 currentRecipe;
    private class_3861 currentRecipe2;
    private int cookTime;
    private int cookTimeTotal;
    final int EnergyPerTick = 1;

    public InductionFurnaceTile(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.checkTier();
    }

    public InductionFurnaceTile(class_2338 pos, class_2680 state) {
        this((class_2591)Tiles.INDUCTION_FURNACE_TILE.getOrNull(), pos, state);
    }

    public InductionFurnaceTile(TileCreateEvent event) {
        this(event.getBlockPos(), event.getBlockState());
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("advanced_reborn__induction_furnace_machine").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 37, 45).slot(1, 55, 45).outputSlot(2, 101, 45).outputSlot(3, 119, 45).energySlot(4, 8, 72).syncEnergyValue().sync(class_9135.field_49675, this::getCookingTime, this::setCookTime).sync(class_9135.field_49675, this::getCookingTimeTotal, this::setCookTimeTotal).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public class_1263 getRecipe2AsInventory() {
        class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        list.set(0, (Object)this.getInventory().method_5438(1));
        list.set(1, (Object)this.getInventory().method_5438(3));
        return IInventory.of((class_2371<class_1799>)list);
    }

    private void setInvDirty(boolean isDirty) {
        this.inventory.setHashChanged(isDirty);
    }

    private boolean isInvDirty() {
        return this.inventory.hasChanged();
    }

    private void updateCurrentRecipe() {
        if (this.inventory.method_5438(this.inputSlot).method_7960()) {
            this.resetCrafter();
            return;
        }
        MinecraftServer server = Objects.requireNonNull(this.field_11863).method_8503();
        if (server == null) {
            return;
        }
        Optional testRecipe = server.method_3772().method_8132(class_3956.field_17546, (class_9695)new class_9696(this.inventory.method_5438(this.inputSlot)), this.field_11863);
        if (testRecipe.isEmpty()) {
            this.resetCrafter();
            return;
        }
        if (!this.canAcceptOutput((class_3861)((class_8786)testRecipe.get()).comp_1933(), this.outputSlot)) {
            this.resetCrafter();
        }
        this.currentRecipe = (class_3861)((class_8786)testRecipe.get()).comp_1933();
        this.cookTime = 0;
        this.cookTimeTotal = Math.max((int)((double)this.currentRecipe.method_8167() * (1.0 - this.getSpeedMultiplier())), 1);
        this.updateState();
    }

    private void updateCurrentRecipe2() {
        if (this.inventory.method_5438(this.inputSlot2).method_7960()) {
            this.resetCrafter2();
            return;
        }
        MinecraftServer server = Objects.requireNonNull(this.field_11863).method_8503();
        if (server == null) {
            return;
        }
        Optional testRecipe = server.method_3772().method_8132(class_3956.field_17546, (class_9695)new class_9696(this.inventory.method_5438(this.inputSlot2)), this.field_11863);
        if (testRecipe.isEmpty()) {
            this.resetCrafter2();
            return;
        }
        if (!this.canAcceptOutput((class_3861)((class_8786)testRecipe.get()).comp_1933(), this.outputSlot2)) {
            this.resetCrafter2();
        }
        this.currentRecipe2 = (class_3861)((class_8786)testRecipe.get()).comp_1933();
        if (this.currentRecipe == null) {
            this.cookTime = 0;
            this.cookTimeTotal = Math.max((int)((double)this.currentRecipe2.method_8167() * (1.0 - this.getSpeedMultiplier())), 1);
        }
        this.updateState();
    }

    private boolean canAcceptOutput(class_3861 recipe, int slot) {
        class_1799 recipeOutput = RecipeUtil.getOutput((class_1860)recipe, (class_1937)this.field_11863);
        if (recipeOutput.method_7960()) {
            return false;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)recipeOutput, (boolean)true, (boolean)true)) {
            return recipeOutput.method_7947() + this.inventory.method_5438(slot).method_7947() <= recipeOutput.method_7914();
        }
        return false;
    }

    public boolean canCraftAgain() {
        if (this.inventory.method_5438(this.inputSlot).method_7960()) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        if (!this.canAcceptOutput(this.currentRecipe, this.outputSlot)) {
            return false;
        }
        return this.getEnergy() >= (long)this.currentRecipe.method_8167() * this.getEuPerTick(1L);
    }

    public boolean canCraftAgain2() {
        if (this.inventory.method_5438(this.inputSlot2).method_7960()) {
            return false;
        }
        if (this.currentRecipe2 == null) {
            return false;
        }
        if (!this.canAcceptOutput(this.currentRecipe2, this.outputSlot2)) {
            return false;
        }
        return this.getEnergy() >= (long)this.currentRecipe2.method_8167() * this.getEuPerTick(1L);
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        if (this.currentRecipe2 == null) {
            this.cookTime = 0;
            this.cookTimeTotal = 0;
        }
        this.updateState();
    }

    private void resetCrafter2() {
        this.currentRecipe2 = null;
        if (this.currentRecipe == null) {
            this.cookTime = 0;
            this.cookTimeTotal = 0;
        }
        this.updateState();
    }

    private void updateState() {
        class_2248 furnaceBlock = WorldUtil.getBlockState((class_1937)this.method_10997(), (class_2338)this.field_11867).method_26204();
        if (furnaceBlock instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)furnaceBlock;
            boolean isActive = this.currentRecipe != null || this.canCraftAgain() || this.currentRecipe2 != null || this.canCraftAgain2();
            blockMachineBase.setActive(Boolean.valueOf(isActive), this.field_11863, this.field_11867);
        }
        this.field_11863.method_8413(this.field_11867, WorldUtil.getBlockState((class_1937)this.field_11863, (class_2338)this.field_11867), WorldUtil.getBlockState((class_1937)this.field_11863, (class_2338)this.field_11867), 3);
    }

    private boolean hasAllInputs(class_3861 recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.inventory.method_5438(this.inputSlot).method_7960()) {
            return false;
        }
        return recipe.method_64719(new class_9696(this.inventory.method_5438(this.inputSlot)), this.field_11863);
    }

    private boolean hasAllInputs2(class_3861 recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.inventory.method_5438(this.inputSlot2).method_7960()) {
            return false;
        }
        return recipe.method_64719(new class_9696(this.inventory.method_5438(this.inputSlot2)), this.field_11863);
    }

    private void craftRecipe(class_3861 recipe, int outputSlot, int inputSlot) {
        if (recipe == null) {
            return;
        }
        if (!this.canAcceptOutput(recipe, outputSlot)) {
            return;
        }
        class_1799 outputStack = this.inventory.method_5438(outputSlot);
        if (outputStack.method_7960()) {
            this.inventory.method_5447(outputSlot, RecipeUtil.getOutput((class_1860)recipe, (class_1937)this.field_11863).method_7972());
        } else {
            ItemStackUtil.incrementCount((class_1799)outputStack, (int)1);
        }
        this.inventory.method_5438(inputSlot).method_7934(1);
    }

    public int getProgressScaled(int scale) {
        if (this.cookTimeTotal != 0) {
            return this.cookTime * scale / this.cookTimeTotal;
        }
        return 0;
    }

    public int getCookingTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    public int getCookingTimeTotal() {
        return this.cookTimeTotal;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        this.cookTimeTotal = cookTimeTotal;
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity2) {
        super.tick(world, pos, state, blockEntity2);
        this.charge(2);
        if (world == null || WorldUtil.isClient((class_1937)world)) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange == 20) {
            this.setInvDirty(true);
            this.ticksSinceLastChange = 0;
        }
        if (this.isInvDirty()) {
            if (this.currentRecipe == null) {
                this.updateCurrentRecipe();
            }
            if (this.currentRecipe2 == null) {
                this.updateCurrentRecipe2();
            }
            if (!(this.currentRecipe == null || this.hasAllInputs(this.currentRecipe) && this.canAcceptOutput(this.currentRecipe, this.outputSlot))) {
                this.resetCrafter();
            }
            if (!(this.currentRecipe2 == null || this.hasAllInputs2(this.currentRecipe2) && this.canAcceptOutput(this.currentRecipe2, this.outputSlot2))) {
                this.resetCrafter2();
            }
        }
        boolean crafting = false;
        boolean couldCraft = false;
        if (this.currentRecipe != null) {
            if (this.cookTime >= this.cookTimeTotal && this.hasAllInputs(this.currentRecipe)) {
                this.craftRecipe(this.currentRecipe, this.outputSlot, this.inputSlot);
                this.updateCurrentRecipe();
                couldCraft = true;
            } else if (this.cookTime < this.cookTimeTotal) {
                crafting = true;
            }
        }
        if (this.currentRecipe2 != null) {
            if (couldCraft && this.hasAllInputs2(this.currentRecipe2)) {
                this.craftRecipe(this.currentRecipe2, this.outputSlot2, this.inputSlot2);
                this.updateCurrentRecipe2();
            } else if (this.cookTime >= this.cookTimeTotal && this.hasAllInputs2(this.currentRecipe2)) {
                this.craftRecipe(this.currentRecipe2, this.outputSlot2, this.inputSlot2);
                this.updateCurrentRecipe2();
            } else if (this.cookTime < this.cookTimeTotal && this.currentRecipe == null) {
                crafting = true;
            }
        }
        if (crafting && this.getStored() > this.getEuPerTick(1L)) {
            this.useEnergy(this.getEuPerTick(1L));
            ++this.cookTime;
            if (this.cookTime == 1 || this.cookTime % 20 == 0 && RecipeCrafter.soundHandler != null) {
                RecipeCrafter.soundHandler.playSound(false, (class_2586)this);
            }
        }
        this.setInvDirty(false);
    }

    public long getBaseMaxPower() {
        return AutoConfigAddon.getConfig().advancedMachineMaxEnergy;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return AutoConfigAddon.getConfig().advancedMachineMaxInput;
    }

    public boolean canProvideEnergy(class_2350 side) {
        return false;
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return ItemStackUtil.create((class_1792)this.toolDrop.method_8389(), (int)1);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }
}

