/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.pipeline.programs.ShaderKey;

public class ShaderOverrides {
    public static ShaderKey getSkyShader(IrisRenderingPipeline pipeline) {
        if (ShaderOverrides.isSky(pipeline)) {
            return ShaderKey.SKY_BASIC;
        }
        return ShaderKey.BASIC;
    }

    public static ShaderKey getSkyTexShader(IrisRenderingPipeline pipeline) {
        if (ShaderOverrides.isSky(pipeline)) {
            return ShaderKey.SKY_TEXTURED;
        }
        return ShaderKey.TEXTURED;
    }

    public static ShaderKey getSkyTexColorShader(IrisRenderingPipeline pipeline) {
        if (ShaderOverrides.isSky(pipeline)) {
            return ShaderKey.SKY_TEXTURED_COLOR;
        }
        return ShaderKey.TEXTURED_COLOR;
    }

    public static ShaderKey getSkyColorShader(IrisRenderingPipeline pipeline) {
        if (ShaderOverrides.isSky(pipeline)) {
            return ShaderKey.SKY_BASIC_COLOR;
        }
        return ShaderKey.BASIC_COLOR;
    }

    public static boolean isBlockEntities(IrisRenderingPipeline pipeline) {
        return pipeline != null && pipeline.getPhase() == WorldRenderingPhase.BLOCK_ENTITIES;
    }

    public static boolean isEntities(IrisRenderingPipeline pipeline) {
        return pipeline != null && pipeline.getPhase() == WorldRenderingPhase.ENTITIES;
    }

    public static boolean isSky(IrisRenderingPipeline pipeline) {
        if (pipeline != null) {
            return switch (pipeline.getPhase()) {
                case WorldRenderingPhase.CUSTOM_SKY, WorldRenderingPhase.SKY, WorldRenderingPhase.SUNSET, WorldRenderingPhase.SUN, WorldRenderingPhase.STARS, WorldRenderingPhase.VOID, WorldRenderingPhase.MOON -> true;
                default -> false;
            };
        }
        return false;
    }

    public static boolean isPhase(IrisRenderingPipeline pipeline, WorldRenderingPhase phase) {
        if (pipeline != null) {
            return pipeline.getPhase() == phase;
        }
        return false;
    }
}

