/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.FrameworkData;
import com.mrcrayfish.framework.api.event.FrameworkEntityEvents;
import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import com.mrcrayfish.framework.api.event.FrameworkTickEvents;
import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.DataHolder;
import com.mrcrayfish.framework.network.Network;
import com.mrcrayfish.framework.network.message.configuration.S2CSyncedEntityData;
import com.mrcrayfish.framework.network.message.play.S2CUpdateEntityData;
import com.mrcrayfish.framework.platform.Services;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class SyncedEntityData {
    private static final Marker SYNCED_ENTITY_DATA_MARKER = MarkerFactory.getMarker((String)"SYNCED_ENTITY_DATA");
    private static SyncedEntityData instance;
    private final Set<SyncedClassKey<?>> registeredClassKeys = new HashSet();
    private final Object2ObjectMap<class_2960, SyncedClassKey<?>> idToClassKey = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, SyncedClassKey<?>> classNameToClassKey = new Object2ObjectOpenHashMap();
    private final Map<String, Boolean> clientClassNameCapabilityCache = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> serverClassNameCapabilityCache = new ConcurrentHashMap<String, Boolean>();
    private final Set<SyncedDataKey<?, ?>> registeredDataKeys = new HashSet();
    private final Reference2ObjectMap<SyncedClassKey<?>, HashMap<class_2960, SyncedDataKey<?, ?>>> classToKeys = new Reference2ObjectOpenHashMap();
    private final Reference2IntMap<SyncedDataKey<?, ?>> internalIds = new Reference2IntOpenHashMap();
    private final Int2ReferenceMap<SyncedDataKey<?, ?>> syncedIdToKey = new Int2ReferenceOpenHashMap();
    private final AtomicInteger nextIdTracker = new AtomicInteger();
    private final Set<class_1297> pendingEntitiesForSync = new HashSet<class_1297>();
    private boolean needsSync = false;

    private SyncedEntityData() {
        FrameworkPlayerEvents.STARTED_TRACKING_ENTITY.register(this::onStartTracking);
        FrameworkEntityEvents.JOIN_LEVEL.register(this::onEntityJoinWorld);
        FrameworkTickEvents.END_SERVER.register(this::onServerTickEnd);
        FrameworkPlayerEvents.COPY.register(this::onPlayerClone);
    }

    public static SyncedEntityData instance() {
        if (instance == null) {
            instance = new SyncedEntityData();
        }
        return instance;
    }

    private <E extends class_1297> void registerClassKey(SyncedClassKey<E> classKey) {
        if (!this.registeredClassKeys.contains(classKey)) {
            this.registeredClassKeys.add(classKey);
            this.idToClassKey.put((Object)classKey.id(), classKey);
            this.classNameToClassKey.put((Object)classKey.entityClass().getName(), classKey);
        }
    }

    public synchronized <E extends class_1297, T> void registerDataKey(SyncedDataKey<E, T> dataKey) {
        class_2960 keyId = dataKey.id();
        SyncedClassKey<E> classKey = dataKey.classKey();
        if (FrameworkData.isLoaded()) {
            throw new IllegalStateException(String.format("Tried to register synced data key %s for %s after game initialization", keyId, classKey.id()));
        }
        if (this.registeredDataKeys.contains(dataKey)) {
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is already registered", keyId, classKey.id()));
        }
        this.registerClassKey(dataKey.classKey());
        this.registeredDataKeys.add(dataKey);
        ((HashMap)this.classToKeys.computeIfAbsent(classKey, c -> new HashMap())).put(keyId, dataKey);
        int nextId = this.nextIdTracker.getAndIncrement();
        this.internalIds.put(dataKey, nextId);
        this.syncedIdToKey.put(nextId, dataKey);
        Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Registered synced data key {} for {}", (Object)dataKey.id(), (Object)classKey.id());
    }

    private void validateKey(SyncedDataKey<?, ?> key) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
    }

    public <E extends class_1297, T> void set(E entity, SyncedDataKey<?, ?> key, T value) {
        this.validateKey(key);
        DataHolder holder = this.getDataHolder(entity);
        if (holder != null) {
            holder.set(key, value);
        }
    }

    public <E extends class_1297, T> T get(E entity, SyncedDataKey<E, T> key) {
        this.validateKey(key);
        DataHolder holder = this.getDataHolder(entity);
        return holder != null ? holder.get(key) : key.defaultValueSupplier().get();
    }

    public <E extends class_1297, T> void updateClientEntry(class_1297 entity, DataEntry<E, T> entry) {
        SyncedEntityData.instance().set(entity, entry.getKey(), entry.getValue());
    }

    public int getInternalId(SyncedDataKey<?, ?> key) {
        return this.internalIds.getInt(key);
    }

    SyncedClassKey<?> getClassKey(class_2960 id) {
        return (SyncedClassKey)this.idToClassKey.get((Object)id);
    }

    Map<class_2960, SyncedDataKey<?, ?>> getDataKeys(SyncedClassKey<?> key) {
        return (Map)this.classToKeys.get(key);
    }

    @Nullable
    SyncedDataKey<?, ?> getKey(int id) {
        return (SyncedDataKey)this.syncedIdToKey.get(id);
    }

    public Set<SyncedDataKey<?, ?>> getKeys() {
        return ImmutableSet.copyOf(this.registeredDataKeys);
    }

    @Nullable
    private DataHolder getDataHolder(class_1297 entity) {
        return Services.ENTITY.getDataHolder(entity);
    }

    public boolean hasSyncedDataKey(class_1297 entity) {
        Class<class_1297> entityClass = entity.getClass();
        String entityClassName = entityClass.getName();
        Map<String, Boolean> cache = this.getClassNameCapabilityCache(entity.method_37908().field_9236);
        if (cache.containsKey(entityClassName)) {
            return cache.get(entityClassName);
        }
        Class<class_1297> targetClass = entityClass;
        while (!targetClass.isAssignableFrom(class_1297.class)) {
            if (this.classNameToClassKey.containsKey((Object)targetClass.getName())) {
                cache.put(entityClassName, true);
                return true;
            }
            targetClass = targetClass.getSuperclass();
        }
        cache.put(entityClassName, false);
        return false;
    }

    private Map<String, Boolean> getClassNameCapabilityCache(boolean client) {
        return client ? this.clientClassNameCapabilityCache : this.serverClassNameCapabilityCache;
    }

    private void onStartTracking(class_1297 target, class_1657 player) {
        DataHolder holder;
        if (!player.method_37908().method_8608() && this.hasSyncedDataKey(target) && (holder = this.getDataHolder(target)) != null) {
            List<DataEntry<?, ?>> entries = holder.gatherAllTrackingDataEntries();
            entries.removeIf(entry -> !entry.getKey().syncMode().isTracking());
            if (!entries.isEmpty()) {
                Network.getPlayChannel().sendToPlayer(() -> (class_3222)player, new S2CUpdateEntityData(target.method_5628(), entries));
            }
        }
    }

    private void onEntityJoinWorld(class_1297 entity, class_1937 level, boolean disk) {
        if (entity instanceof class_1657) {
            List<DataEntry<?, ?>> entries;
            DataHolder holder;
            class_1657 player = (class_1657)entity;
            if (!level.method_8608() && this.hasSyncedDataKey((class_1297)player) && (holder = this.getDataHolder((class_1297)player)) != null && !(entries = holder.gatherAllTrackingDataEntries()).isEmpty()) {
                Network.getPlayChannel().sendToPlayer(() -> (class_3222)player, new S2CUpdateEntityData(player.method_5628(), entries));
            }
        }
    }

    private void onPlayerClone(class_1657 oldPlayer, class_1657 newPlayer, boolean respawn) {
        if (!this.hasSyncedDataKey((class_1297)newPlayer)) {
            return;
        }
        DataHolder oldHolder = Services.ENTITY.getDataHolder((class_1297)oldPlayer);
        if (oldHolder == null) {
            return;
        }
        DataHolder newHolder = this.getDataHolder((class_1297)newPlayer);
        if (newHolder == null) {
            return;
        }
        class_5455 access = newPlayer.method_56673();
        oldHolder.copyInto(newHolder, (class_7225.class_7874)access, respawn);
    }

    private void onServerTickEnd(MinecraftServer server) {
        if (!this.needsSync) {
            return;
        }
        if (this.pendingEntitiesForSync.isEmpty()) {
            this.needsSync = false;
            return;
        }
        for (class_1297 entity : this.pendingEntitiesForSync) {
            List<DataEntry<?, ?>> trackingEntries;
            List<DataEntry<?, ?>> entries;
            DataHolder holder;
            if (entity.method_31481() || (holder = this.getDataHolder(entity)) == null || !holder.isPendingSync() || (entries = holder.gatherPendingSyncDataEntries()).isEmpty()) continue;
            List<DataEntry<?, ?>> selfEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isSelf()).collect(Collectors.toList());
            if (!selfEntries.isEmpty() && entity instanceof class_3222) {
                Network.getPlayChannel().sendToPlayer(() -> (class_3222)entity, new S2CUpdateEntityData(entity.method_5628(), selfEntries));
            }
            if (!(trackingEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isTracking()).collect(Collectors.toList())).isEmpty()) {
                Network.getPlayChannel().sendToTrackingEntity(() -> entity, new S2CUpdateEntityData(entity.method_5628(), trackingEntries));
            }
            holder.clearSync();
        }
        this.pendingEntitiesForSync.clear();
        this.needsSync = false;
    }

    public boolean updateMappings(S2CSyncedEntityData message) {
        this.syncedIdToKey.clear();
        ArrayList missingKeys = new ArrayList();
        message.getKeyMap().forEach((classId, list) -> {
            SyncedClassKey classKey = (SyncedClassKey)this.idToClassKey.get(classId);
            if (classKey == null || !this.classToKeys.containsKey((Object)classKey)) {
                list.forEach(pair -> missingKeys.add(Pair.of((Object)classId, (Object)((class_2960)pair.getLeft()))));
                return;
            }
            Map keys = (Map)this.classToKeys.get((Object)classKey);
            list.forEach(pair -> {
                SyncedDataKey syncedDataKey = (SyncedDataKey)keys.get(pair.getLeft());
                if (syncedDataKey == null) {
                    missingKeys.add(Pair.of((Object)classId, (Object)((class_2960)pair.getLeft())));
                    return;
                }
                this.syncedIdToKey.put(((Integer)pair.getRight()).intValue(), (Object)syncedDataKey);
            });
        });
        if (!missingKeys.isEmpty()) {
            String keys = missingKeys.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Received unknown synced entity keys: {}", (Object)keys);
        }
        return missingKeys.isEmpty();
    }

    public List<S2CSyncedEntityData> getConfigurationMessages() {
        HashMap<class_2960, List<Pair<class_2960, Integer>>> map = new HashMap<class_2960, List<Pair<class_2960, Integer>>>();
        this.getKeys().forEach(key -> {
            int id = this.getInternalId((SyncedDataKey<?, ?>)key);
            map.computeIfAbsent(key.classKey().id(), c -> new ArrayList()).add(Pair.of((Object)key.id(), (Object)id));
        });
        return List.of(new S2CSyncedEntityData(map));
    }

    boolean markForSync(class_1297 entity) {
        if (entity != null && !entity.method_37908().method_8608() && !entity.method_31481()) {
            this.needsSync = true;
            this.pendingEntitiesForSync.add(entity);
            return true;
        }
        return false;
    }
}

