/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.entity;

import fr.hugman.promenade.component.PromenadeComponentTypes;
import fr.hugman.promenade.entity.data.PromenadeTrackedData;
import fr.hugman.promenade.entity.variant.SunkenVariant;
import fr.hugman.promenade.entity.variant.SunkenVariants;
import fr.hugman.promenade.registry.PromenadeRegistryKeys;
import fr.hugman.promenade.sound.PromenadeSoundEvents;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1344;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1380;
import net.minecraft.class_1383;
import net.minecraft.class_1384;
import net.minecraft.class_1393;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1412;
import net.minecraft.class_1433;
import net.minecraft.class_1454;
import net.minecraft.class_1547;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_9331;
import net.minecraft.class_9473;

public class SunkenEntity
extends class_1547
implements class_3745 {
    private static final class_2940<class_6880<SunkenVariant>> VARIANT = class_2945.method_12791(SunkenEntity.class, PromenadeTrackedData.SUNKEN_VARIANT);
    private static final class_2940<Boolean> CHARGING = class_2945.method_12791(SunkenEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SWIMMING = class_2945.method_12791(SunkenEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4048 SWIMMING_DIMENSIONS = class_4048.method_18385((float)0.6f, (float)0.6f);
    protected final class_1412 waterNavigation;
    protected final class_1409 landNavigation;
    private final class_1383<SunkenEntity> crossbowAttackGoal = new class_1383((class_1588)this, 1.0, 20.0f);
    private final class_1380<class_1547> bowAttackGoal = new class_1380((class_1588)this, 1.0, 20, 15.0f);
    private final class_1366 meleeAttackGoal = new class_1366((class_1314)this, 1.2, false){

        public void method_6270() {
            super.method_6270();
            SunkenEntity.this.method_19540(false);
        }

        public void method_6269() {
            super.method_6269();
            SunkenEntity.this.method_19540(true);
        }
    };
    boolean targetingUnderwater;

    public SunkenEntity(class_1299<? extends SunkenEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_6997();
        this.field_6207 = new SunkenMoveControl(this);
        this.method_5941(class_7.field_18, 0.0f);
        this.waterNavigation = new class_1412((class_1308)this, world);
        this.landNavigation = new class_1409((class_1308)this, world);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        SunkenVariants.select(this.field_5974, this.method_56673(), class_10701.method_67169((class_5425)world, (class_2338)this.method_24515())).ifPresent(this::setVariant);
        this.field_6198 = Optional.ofNullable(((SunkenVariant)this.getVariant().comp_349()).lootTable());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public static boolean canSpawn(class_1299<SunkenEntity> ignoredType, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean bl = world.method_8407() != class_1267.field_5801 && SunkenEntity.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) && (spawnReason == class_3730.field_16469 || world.method_8316(pos).method_15767(class_3486.field_15517));
        return pos.method_10264() < world.method_8615() - 10 && bl;
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public class_4048 method_55694(class_4050 pose) {
        if (this.isBreaststrokeSwimming()) {
            return SWIMMING_DIMENSIONS;
        }
        return super.method_55694(pose);
    }

    public static class_5132.class_5133 createSunkenAttributes() {
        return SunkenEntity.method_26905();
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new class_1384((class_1314)this));
        this.field_6201.method_6277(2, (class_1352)new class_1383((class_1588)this, 1.0, 4.5f));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1454.class, 8.0f, 1.0, 1.2));
        this.field_6201.method_6277(3, (class_1352)new class_1344((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1378((class_1314)this, 1.0, 40));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new TargetAboveWaterGoal(this, 1.0, this.method_37908().method_8615()));
        this.field_6201.method_6277(7, (class_1352)new LeaveWaterGoal(this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1433.class, true));
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.method_24520(stack -> stack.method_7909() instanceof class_1764)) {
            this.method_24654((class_1309)this, 1.6f);
        } else {
            class_1799 itemStack = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102));
            class_1665 persistentProjectileEntity = this.method_6996(this.method_18808(itemStack), pullProgress, itemStack);
            double d = target.method_23317() - this.method_23317();
            double e = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
            double f = target.method_23321() - this.method_23321();
            double g = Math.sqrt(d * d + f * f);
            persistentProjectileEntity.method_7485(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
            this.method_5783(this.getShootSound(), 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)persistentProjectileEntity);
        }
    }

    public void method_24654(class_1309 entity, float speed) {
        super.method_24654(entity, speed);
    }

    protected class_1665 method_6996(class_1799 arrow, float damageModifier, @Nullable class_1799 shotFrom) {
        class_1665 persistentProjectileEntity = super.method_6996(arrow, damageModifier, shotFrom);
        if (persistentProjectileEntity instanceof class_1667) {
            ((class_1667)persistentProjectileEntity).method_7463(new class_1293(class_1294.field_5909, 600));
        }
        return persistentProjectileEntity;
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        super.method_5964(random, difficulty);
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
    }

    public boolean method_25938(class_1811 weapon) {
        return weapon instanceof class_1753 || weapon instanceof class_1764;
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_66249() && this.method_5799()) {
            float speed = 0.075f;
            this.method_5724(speed, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(movementInput);
        }
    }

    public boolean method_5675() {
        return !this.method_5681();
    }

    public void method_5790() {
        if (!this.method_37908().field_9236) {
            boolean b = this.method_37908().method_22347(this.method_24515().method_10086(2));
            if (!b && this.method_66249() && this.method_5869()) {
                this.field_6189 = this.waterNavigation;
                this.method_5796(true);
                this.setBreaststrokeSwimming(true);
            } else {
                this.field_6189 = this.landNavigation;
                this.method_5796(false);
                this.setBreaststrokeSwimming(false);
            }
        }
    }

    public void method_6997() {
        if (this.method_37908() != null && !this.method_37908().field_9236 && this.bowAttackGoal != null && this.crossbowAttackGoal != null && this.meleeAttackGoal != null) {
            this.field_6201.method_6280(this.bowAttackGoal);
            this.field_6201.method_6280(this.crossbowAttackGoal);
            this.field_6201.method_6280((class_1352)this.meleeAttackGoal);
            class_1799 itemStack = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8399));
            if (itemStack.method_31574(class_1802.field_8399)) {
                this.field_6201.method_6277(4, this.crossbowAttackGoal);
            } else if (itemStack.method_31574(class_1802.field_8102)) {
                this.bowAttackGoal.method_6305(this.method_37908().method_8407() != class_1267.field_5807 ? 40 : 20);
                this.field_6201.method_6277(4, this.bowAttackGoal);
            } else {
                this.field_6201.method_6277(4, (class_1352)this.meleeAttackGoal);
            }
        }
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void method_7110(boolean charging) {
        this.field_6011.method_12778(CHARGING, (Object)charging);
    }

    public boolean isBreaststrokeSwimming() {
        if (this.method_18798().method_1033() < (double)0.1f) {
            return false;
        }
        return (Boolean)this.field_6011.method_12789(SWIMMING);
    }

    public void setBreaststrokeSwimming(boolean breaststrokeSwimming) {
        this.field_6011.method_12778(SWIMMING, (Object)breaststrokeSwimming);
    }

    public boolean method_20232() {
        return this.isBreaststrokeSwimming();
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    protected boolean hasFinishedCurrentPath() {
        class_2338 blockPos;
        class_11 path = this.method_5942().method_6345();
        if (path != null && (blockPos = path.method_48()) != null) {
            double d = this.method_5649(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            return d < 4.0;
        }
        return false;
    }

    boolean isTargetingUnderwater() {
        if (this.targetingUnderwater) {
            return true;
        }
        class_1309 livingEntity = this.method_5968();
        return livingEntity != null && livingEntity.method_5799();
    }

    public void setTargetingUnderwater(boolean targetingUnderwater) {
        this.targetingUnderwater = targetingUnderwater;
    }

    protected class_3414 method_5994() {
        return this.method_5777(class_3486.field_15517) ? PromenadeSoundEvents.SUNKEN_AMBIENT : class_3417.field_15200;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.method_5777(class_3486.field_15517) ? PromenadeSoundEvents.SUNKEN_HURT : class_3417.field_15069;
    }

    protected class_3414 method_6002() {
        return this.method_5777(class_3486.field_15517) ? PromenadeSoundEvents.SUNKEN_DEATH : class_3417.field_14877;
    }

    protected class_3414 method_6998() {
        return this.method_5777(class_3486.field_15517) ? PromenadeSoundEvents.SUNKEN_STEP : class_3417.field_14548;
    }

    protected class_3414 getShootSound() {
        return this.method_5777(class_3486.field_15517) ? PromenadeSoundEvents.SUNKEN_SHOOT : (this.method_24520(stack -> stack.method_7909() instanceof class_1764) ? class_3417.field_15187 : class_3417.field_14633);
    }

    public class_6880<SunkenVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(class_6880<SunkenVariant> variant) {
        this.field_6011.method_12778(VARIANT, variant);
    }

    public State getState() {
        if (this.method_24518(class_1802.field_8399) && this.isCharging()) {
            return State.CROSSBOW_CHARGE;
        }
        if (this.method_24520(class_1764::method_7781)) {
            return State.CROSSBOW_HOLD;
        }
        if (this.isBreaststrokeSwimming()) {
            return State.SWIMMING;
        }
        if (this.method_24518(class_1802.field_8102)) {
            return State.BOW_HOLD;
        }
        return State.NEUTRAL;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)this.method_56673().method_30530(PromenadeRegistryKeys.SUNKEN_VARIANT).method_46747(SunkenVariants.DEFAULT));
        builder.method_56912(CHARGING, (Object)false);
        builder.method_56912(SWIMMING, (Object)false);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        class_10704.method_67177((class_11372)view, this.getVariant());
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        class_10704.method_67178((class_11368)view, PromenadeRegistryKeys.SUNKEN_VARIANT).ifPresent(this::setVariant);
    }

    @org.jetbrains.annotations.Nullable
    public <T> T method_58694(class_9331<? extends T> type) {
        return (T)(type == PromenadeComponentTypes.SUNKEN_VARIANT ? SunkenEntity.method_66651(type, this.getVariant()) : super.method_58694(type));
    }

    protected void method_66649(class_9473 from) {
        this.method_66650(from, PromenadeComponentTypes.SUNKEN_VARIANT);
        super.method_66649(from);
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (type == PromenadeComponentTypes.SUNKEN_VARIANT) {
            this.setVariant((class_6880<SunkenVariant>)((class_6880)SunkenEntity.method_66651(PromenadeComponentTypes.SUNKEN_VARIANT, value)));
            return true;
        }
        return super.method_66654(type, value);
    }

    static class SunkenMoveControl
    extends class_1335 {
        private final SunkenEntity sunken;

        public SunkenMoveControl(SunkenEntity sunken) {
            super((class_1308)sunken);
            this.sunken = sunken;
        }

        public void method_6240() {
            class_1309 target = this.sunken.method_5968();
            if (this.sunken.isTargetingUnderwater() || this.sunken.method_5869()) {
                if (target != null) {
                    if (target.method_23318() > this.sunken.method_23318()) {
                        this.sunken.method_18799(this.sunken.method_18798().method_1031(0.0, 0.002, 0.0));
                    } else {
                        this.sunken.method_18799(this.sunken.method_18798().method_1031(0.0, -0.002, 0.0));
                    }
                }
                if (this.field_6374 == class_1335.class_1336.field_6377 || this.sunken.method_5942().method_6357()) {
                    this.sunken.method_6125(0.0f);
                }
                double d = this.field_6370 - this.sunken.method_23317();
                double e = this.field_6369 - this.sunken.method_23318();
                double f = this.field_6367 - this.sunken.method_23321();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.sunken.method_36456(this.method_6238(this.sunken.method_36454(), h, 90.0f));
                this.sunken.field_6283 = this.sunken.method_36454();
                float i = (float)(this.field_6372 * this.sunken.method_45325(class_5134.field_23719));
                float j = class_3532.method_16439((float)0.125f, (float)this.sunken.method_6029(), (float)i);
                this.sunken.method_6125(j);
                this.sunken.method_18799(this.sunken.method_18798().method_1031((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
            } else {
                if (!this.sunken.method_24828()) {
                    this.sunken.method_18799(this.sunken.method_18798().method_1031(0.0, -0.008, 0.0));
                }
                super.method_6240();
            }
        }
    }

    private static class TargetAboveWaterGoal
    extends class_1352 {
        private final SunkenEntity sunken;
        private final double speed;
        private final int minY;
        private boolean foundTarget;

        public TargetAboveWaterGoal(SunkenEntity sunken, double speed, int minY) {
            this.sunken = sunken;
            this.speed = speed;
            this.minY = minY;
        }

        public boolean method_6264() {
            return !this.sunken.method_37908().method_8530() && this.sunken.method_5799() && !this.sunken.isTargetingUnderwater() && this.sunken.method_23318() < (double)(this.minY - 2);
        }

        public boolean method_6266() {
            return this.method_6264() && !this.foundTarget;
        }

        public void method_6268() {
            if (this.sunken.method_23318() < (double)(this.minY - 1) && (this.sunken.method_5942().method_6357() || this.sunken.hasFinishedCurrentPath())) {
                class_243 vec3d = class_5532.method_31512((class_1314)this.sunken, (int)4, (int)8, (class_243)new class_243(this.sunken.method_23317(), (double)(this.minY - 1), this.sunken.method_23321()), (double)1.6);
                if (vec3d == null) {
                    this.foundTarget = true;
                    return;
                }
                this.sunken.method_5942().method_6337(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, this.speed);
            }
        }

        public void method_6269() {
            this.sunken.setTargetingUnderwater(true);
            this.foundTarget = false;
        }

        public void method_6270() {
            this.sunken.setTargetingUnderwater(false);
        }
    }

    static class LeaveWaterGoal
    extends class_1367 {
        private final SunkenEntity sunken;

        public LeaveWaterGoal(SunkenEntity sunken, double speed) {
            super((class_1314)sunken, speed, 8, 2);
            this.sunken = sunken;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.sunken.method_37908().method_8530() && this.sunken.method_5799() && this.sunken.method_23318() >= (double)(this.sunken.method_37908().method_8615() - 3);
        }

        public boolean method_6266() {
            return super.method_6266();
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            class_2338 blockPos = pos.method_10084();
            return world.method_22347(blockPos) && world.method_22347(blockPos.method_10084()) && world.method_8320(pos).method_26168((class_1922)world, pos, (class_1297)this.sunken);
        }

        public void method_6269() {
            this.sunken.setTargetingUnderwater(false);
            this.sunken.field_6189 = (class_1408)this.sunken.landNavigation;
            super.method_6269();
        }

        public void method_6270() {
            super.method_6270();
        }
    }

    public static enum State {
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        BOW_HOLD,
        SWIMMING,
        NEUTRAL;

    }
}

