/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.multiblock;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.crafting.SizedIngredient;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.StringUtils;
import reborncore.common.util.Torus;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.recipe.recipes.FusionReactorRecipe;

public class FusionControlComputerBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public int craftingTickTime = 0;
    public int neededPower = 0;
    public int size = 6;
    public int state = -1;
    final int topStackSlot = 0;
    final int bottomStackSlot = 1;
    final int outputStackSlot = 2;
    class_8786<FusionReactorRecipe> currentRecipeEntry = null;
    boolean hasStartedCrafting = false;
    boolean checkNBTRecipe = false;
    long lastTick = -1L;

    public FusionControlComputerBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.FUSION_CONTROL_COMPUTER, pos, state, "FusionControlComputer", -1, -1, TRContent.Machine.FUSION_CONTROL_COMPUTER.block, -1);
        this.inventory = new RebornInventory(3, "FusionControlComputerBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public boolean hasMultiblock() {
        return true;
    }

    public class_2561 getStateText() {
        if (this.state == -1) {
            return class_2561.method_43473();
        }
        if (this.state == 0) {
            return class_2561.method_43471((String)"gui.techreborn.fusion.norecipe");
        }
        if (this.state == 1) {
            if (this.currentRecipeEntry == null) {
                return class_2561.method_43471((String)"gui.techreborn.fusion.charging");
            }
            int percentage = this.percentage(((FusionReactorRecipe)this.currentRecipeEntry.comp_1933()).getStartEnergy(), this.getEnergy());
            return class_2561.method_43469((String)"gui.techreborn.fusion.chargingdetailed", (Object[])new Object[]{StringUtils.getPercentageText((int)percentage)});
        }
        if (this.state == 2) {
            return class_2561.method_43471((String)"gui.techreborn.fusion.crafting");
        }
        return class_2561.method_43473();
    }

    public void changeSize(int sizeDelta) {
        int newSize = this.size + sizeDelta;
        this.size = Math.max(6, Math.min(TechRebornConfig.fusionControlComputerMaxCoilSize, newSize));
    }

    private void resetCrafter() {
        this.currentRecipeEntry = null;
        this.craftingTickTime = 0;
        this.neededPower = 0;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(class_1799 stack, int slot, boolean tags) {
        if (stack.method_7960()) {
            return true;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)stack, (boolean)true, (boolean)tags)) {
            return stack.method_7947() + this.inventory.method_5438(slot).method_7947() <= stack.method_7914();
        }
        return false;
    }

    private void updateCurrentRecipe() {
        for (class_8786 entry : RecipeUtils.getRecipeEntries((class_1937)this.field_11863, ModRecipes.FUSION_REACTOR)) {
            if (!this.validateRecipe((class_8786<FusionReactorRecipe>)entry)) continue;
            this.currentRecipeEntry = entry;
            this.craftingTickTime = 0;
            this.neededPower = ((FusionReactorRecipe)entry.comp_1933()).getStartEnergy();
            this.hasStartedCrafting = false;
            break;
        }
    }

    private boolean validateRecipe(class_8786<FusionReactorRecipe> entry) {
        FusionReactorRecipe recipe = (FusionReactorRecipe)entry.comp_1933();
        return this.hasAllInputs(recipe) && this.canFitStack(recipe.outputs().getFirst(), 2, true);
    }

    private boolean hasAllInputs(RebornRecipe recipeType) {
        for (SizedIngredient ingredient : recipeType.ingredients()) {
            boolean hasItem = false;
            if (ingredient.test(this.inventory.method_5438(0)) || ingredient.test(this.inventory.method_5438(1))) {
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private void useInput(int slot) {
        if (this.currentRecipeEntry == null) {
            return;
        }
        for (SizedIngredient ingredient : ((FusionReactorRecipe)this.currentRecipeEntry.comp_1933()).ingredients()) {
            if (!ingredient.test(this.inventory.method_5438(slot))) continue;
            this.inventory.shrinkSlot(slot, ingredient.count());
            break;
        }
    }

    private int percentage(double MaxValue, double CurrentValue) {
        if (CurrentValue == 0.0) {
            return 0;
        }
        return (int)(CurrentValue * 100.0 / MaxValue);
    }

    @Override
    public int getProgressScaled(int scale) {
        if (this.craftingTickTime != 0 && this.currentRecipeEntry != null && ((FusionReactorRecipe)this.currentRecipeEntry.comp_1933()).time() != 0) {
            return this.craftingTickTime * scale / ((FusionReactorRecipe)this.currentRecipeEntry.comp_1933()).time();
        }
        return 0;
    }

    @Override
    public long getBaseMaxPower() {
        return Math.min((long)((double)TechRebornConfig.fusionControlComputerMaxEnergy * this.getPowerMultiplier()), Long.MAX_VALUE);
    }

    @Override
    public long getBaseMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0L;
        }
        return TechRebornConfig.fusionControlComputerMaxOutput;
    }

    @Override
    public long getBaseMaxInput() {
        if (this.hasStartedCrafting) {
            return 0L;
        }
        return TechRebornConfig.fusionControlComputerMaxInput;
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.checkNBTRecipe) {
            this.checkNBTRecipe = false;
            for (class_8786 entry : RecipeUtils.getRecipeEntries((class_1937)world, ModRecipes.FUSION_REACTOR)) {
                if (!this.validateRecipe((class_8786<FusionReactorRecipe>)entry)) continue;
                this.currentRecipeEntry = entry;
            }
        }
        if (this.lastTick == world.method_8510()) {
            return;
        }
        this.lastTick = world.method_8510();
        if (world.method_8510() % 20L == 0L) {
            this.inventory.setHashChanged();
        }
        if (!this.isShapeValid()) {
            this.resetCrafter();
            return;
        }
        if (this.currentRecipeEntry == null && this.inventory.hasChanged()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipeEntry != null) {
            class_1799 result;
            FusionReactorRecipe currentRecipe = (FusionReactorRecipe)this.currentRecipeEntry.comp_1933();
            if (!this.hasStartedCrafting && !this.validateRecipe(this.currentRecipeEntry)) {
                this.resetCrafter();
                this.inventory.resetHasChanged();
                return;
            }
            if (!this.hasStartedCrafting && this.getStored() > (long)currentRecipe.getStartEnergy()) {
                this.useEnergy(currentRecipe.getStartEnergy());
                this.hasStartedCrafting = true;
                this.useInput(0);
                this.useInput(1);
            }
            if (this.hasStartedCrafting && this.craftingTickTime < currentRecipe.time()) {
                int recipePower = currentRecipe.power();
                if (recipePower > 0) {
                    long power = (long)((double)Math.abs(currentRecipe.power()) * this.getPowerMultiplier());
                    this.addEnergy(power);
                    this.powerChange = power;
                    ++this.craftingTickTime;
                } else if (this.getStored() > (long)(-recipePower)) {
                    this.setEnergy(this.getEnergy() + (long)recipePower);
                    ++this.craftingTickTime;
                }
            } else if (this.craftingTickTime >= currentRecipe.time() && this.canFitStack(result = currentRecipe.outputs().getFirst(), 2, true)) {
                if (this.inventory.method_5438(2).method_7960()) {
                    this.inventory.method_5447(2, result.method_7972());
                } else {
                    this.inventory.shrinkSlot(2, -result.method_7947());
                }
                if (this.validateRecipe(this.currentRecipeEntry)) {
                    this.craftingTickTime = 0;
                    this.useInput(0);
                    this.useInput(1);
                } else {
                    this.resetCrafter();
                }
            }
            this.method_5431();
        }
        this.inventory.resetHasChanged();
    }

    protected boolean canAcceptEnergy(@Nullable class_2350 side) {
        return side != class_2350.field_11033 && side != class_2350.field_11036;
    }

    @Override
    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return side == class_2350.field_11033 || side == class_2350.field_11036;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.craftingTickTime = view.method_71424("craftingTickTime", 0);
        this.neededPower = view.method_71424("neededPower", 0);
        this.hasStartedCrafting = view.method_71433("hasStartedCrafting", false);
        if (view.method_71433("hasActiveRecipe", false) && this.currentRecipeEntry == null) {
            this.checkNBTRecipe = true;
        }
        this.size = view.method_71424("size", 0);
        this.size = Math.min(this.size, TechRebornConfig.fusionControlComputerMaxCoilSize);
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("craftingTickTime", this.craftingTickTime);
        view.method_71465("neededPower", this.neededPower);
        view.method_71472("hasStartedCrafting", this.hasStartedCrafting);
        view.method_71472("hasActiveRecipe", this.currentRecipeEntry != null);
        view.method_71465("size", this.size);
    }

    public double getPowerMultiplier() {
        double calc = 0.5 * Math.pow(this.size - 5, 1.8);
        return Math.max((double)Math.round(calc * 100.0) / 100.0, 1.0);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 coil = TRContent.Machine.FUSION_COIL.block.method_9564();
        Torus.getOriginPositions((int)this.size).forEach(pos -> writer.add(pos.method_10263(), pos.method_10264(), pos.method_10260(), coil));
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("fusionreactor").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 34, 47).slot(1, 126, 47).outputSlot(2, 80, 47).syncEnergyValue().sync(class_9135.field_49675, this::getCraftingTickTime, this::setCraftingTickTime).sync(class_9135.field_49675, this::getSize, this::setSize).sync(class_9135.field_49675, this::getState, this::setState).sync(class_9135.field_49675, this::getNeededPower, this::setNeededPower).sync(class_2960.field_48267, this::getCurrentRecipeID, this::setCurrentRecipeID).syncShapeValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getCraftingTickTime() {
        return this.craftingTickTime;
    }

    public void setCraftingTickTime(int craftingTickTime) {
        this.craftingTickTime = craftingTickTime;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getState() {
        if (this.currentRecipeEntry == null) {
            return 0;
        }
        if (!this.hasStartedCrafting) {
            return 1;
        }
        return 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getNeededPower() {
        return this.neededPower;
    }

    public void setNeededPower(int neededPower) {
        this.neededPower = neededPower;
    }

    public class_2960 getCurrentRecipeID() {
        if (this.currentRecipeEntry == null) {
            return class_2960.method_60655((String)"null", (String)"null");
        }
        return this.currentRecipeEntry.comp_1932().method_29177();
    }

    public void setCurrentRecipeID(class_2960 currentRecipeID) {
        if (currentRecipeID.method_12832().equals("null")) {
            this.currentRecipeEntry = null;
            return;
        }
        this.currentRecipeEntry = this.getRecipeFromID(currentRecipeID);
    }

    private class_8786<FusionReactorRecipe> getRecipeFromID(class_2960 identifier) {
        return RecipeUtils.getRecipeEntries((class_1937)this.field_11863, ModRecipes.FUSION_REACTOR).stream().filter(recipe -> recipe.comp_1932().equals(identifier)).findFirst().orElse(null);
    }
}

