/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart.capability;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_5568;
import org.jetbrains.annotations.Nullable;

public class CapabilityMinecartController {
    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID = new WorldAttached<Map>($ -> new HashMap());
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling = new WorldAttached<Set>($ -> new HashSet());
    static WorldAttached<List<class_1688>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    static WorldAttached<List<UUID>> queuedUnloads = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(class_1937 world) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        List<class_1688> queued = queuedAdditions.get((class_1936)world);
        List<UUID> queuedRemovals = queuedUnloads.get((class_1936)world);
        Set<UUID> cartsWithCoupling = loadedMinecartsWithCoupling.get((class_1936)world);
        Set<UUID> keySet = carts.keySet();
        for (UUID removal : queuedRemovals) {
            keySet.remove(removal);
            cartsWithCoupling.remove(removal);
        }
        for (class_1688 cart : queued) {
            class_1688 minecartEntity;
            MinecartController minecartController;
            UUID uniqueID = cart.method_5667();
            if (world.field_9236 && carts.containsKey(uniqueID) && (minecartController = carts.get(uniqueID)) != null && (minecartEntity = minecartController.cart()) != null && minecartEntity.method_5628() != cart.method_5628()) continue;
            cartsWithCoupling.remove(uniqueID);
            AllSynchedDatas.MINECART_CONTROLLER.get((class_1297)cart).ifPresent(controller -> {
                carts.put(uniqueID, (MinecartController)controller);
                if (controller.isLeadingCoupling()) {
                    cartsWithCoupling.add(uniqueID);
                }
                if (!world.field_9236) {
                    controller.sendData();
                }
            });
        }
        queuedRemovals.clear();
        queued.clear();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, MinecartController> entry : carts.entrySet()) {
            MinecartController controller2 = entry.getValue();
            if (controller2 != null && controller2.isPresent()) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID uuid : toRemove) {
            keySet.remove(uuid);
            cartsWithCoupling.remove(uuid);
        }
    }

    public static void entityTick(class_1297 entity) {
        if (!(entity instanceof class_1688)) {
            return;
        }
        AllSynchedDatas.MINECART_CONTROLLER.get(entity).ifPresent(MinecartController::tick);
    }

    public static void onChunkUnloaded(class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        class_1937 world = chunk.method_12200();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        for (MinecartController minecartController : carts.values()) {
            class_1688 cart;
            if (minecartController == null || !minecartController.isPresent() || !(cart = minecartController.cart()).method_31476().equals((Object)chunkPos)) continue;
            queuedUnloads.get((class_1936)world).add(cart.method_5667());
        }
    }

    protected static void onCartRemoved(class_1937 world, class_1688 entity) {
        AllSynchedDatas.MINECART_CONTROLLER.set((class_1297)entity, Optional.empty());
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        List<UUID> unloads = queuedUnloads.get((class_1936)world);
        UUID uniqueID = entity.method_5667();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID)) {
            return;
        }
        if (world.field_9236) {
            return;
        }
        CapabilityMinecartController.handleKilledMinecart(world, carts.get(uniqueID), entity.method_19538());
    }

    protected static void handleKilledMinecart(class_1937 world, MinecartController controller, class_243 removedPos) {
        if (controller == null) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            class_1688 cart;
            Optional<MinecartController> next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next.isEmpty()) continue;
            MinecartController nextController = next.get();
            nextController.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward) || (cart = nextController.cart()) == null) continue;
            class_243 itemPos = cart.method_19538().method_1019(removedPos).method_1021(0.5);
            class_1542 itemEntity = new class_1542(world, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, AllItems.MINECART_COUPLING.method_7854());
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(class_1937 world, UUID cartId) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((class_1936)world);
        if (carts == null) {
            return null;
        }
        if (!carts.containsKey(cartId)) {
            return null;
        }
        return carts.get(cartId);
    }

    public static void attach(class_5568 entity) {
        if (!(entity instanceof class_1688)) {
            return;
        }
        class_1688 abstractMinecart = (class_1688)entity;
        MinecartController controller = new MinecartController(abstractMinecart);
        AllSynchedDatas.MINECART_CONTROLLER.set((class_1297)abstractMinecart, Optional.of(controller));
        queuedAdditions.get((class_1936)abstractMinecart.method_37908()).add(abstractMinecart);
    }

    public static void onEntityDeath(class_1937 world, class_1297 entity) {
        if (entity instanceof class_1688) {
            class_1688 abstractMinecart = (class_1688)entity;
            CapabilityMinecartController.onCartRemoved(world, abstractMinecart);
        }
    }
}

