/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.PonderElement;
import com.zurrtum.create.client.ponder.api.element.PonderOverlayElement;
import com.zurrtum.create.client.ponder.api.element.PonderSceneElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderSceneBuilder;
import com.zurrtum.create.client.ponder.foundation.PonderSceneBuildingUtil;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.element.WorldSectionElementImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.HideAllInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.PonderInstruction;
import com.zurrtum.create.client.ponder.foundation.registration.PonderLocalization;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class PonderScene {
    public static final String TITLE_KEY = "header";
    final PonderLocalization localization;
    private boolean finished;
    private int textIndex;
    class_2960 sceneId;
    private final IntList keyframeTimes;
    List<PonderInstruction> schedule;
    private final List<PonderInstruction> activeSchedule;
    private final Map<UUID, PonderElement> linkedElements;
    private final Set<PonderElement> elements;
    private final List<PonderTag> tags;
    private final List<StoryBoardEntry.SceneOrderingEntry> orderingEntries;
    private final PonderLevel world;
    private final String namespace;
    private final class_2960 location;
    private final SceneCamera camera;
    private final Outliner outliner;
    private SceneTransform transform;
    private final WorldSectionElement baseWorldSection;
    private final class_1297 renderViewEntity;
    private class_243 pointOfInterest;
    @Nullable
    private class_243 chasingPointOfInterest;
    int basePlateOffsetX;
    int basePlateOffsetZ;
    int basePlateSize;
    float scaleFactor;
    float yOffset;
    boolean hidePlatformShadow;
    private boolean stoppedCounting;
    private int totalTime;
    private int currentTime;
    private boolean nextUpEnabled = true;

    public PonderScene(@Nullable PonderLevel world, PonderLocalization localization, String namespace, class_2960 location, Collection<class_2960> tags, Collection<StoryBoardEntry.SceneOrderingEntry> orderingEntries) {
        if (world != null) {
            world.scene = this;
        }
        this.world = world;
        this.localization = localization;
        this.pointOfInterest = class_243.field_1353;
        this.textIndex = 1;
        this.hidePlatformShadow = false;
        this.namespace = namespace;
        this.location = location;
        this.sceneId = class_2960.method_60655((String)namespace, (String)"missing_title");
        this.outliner = new Outliner();
        this.elements = new HashSet<PonderElement>();
        this.linkedElements = new HashMap<UUID, PonderElement>();
        this.tags = tags.stream().map(PonderIndex.getTagAccess()::getRegisteredTag).toList();
        this.orderingEntries = new ArrayList<StoryBoardEntry.SceneOrderingEntry>(orderingEntries);
        this.schedule = new ArrayList<PonderInstruction>();
        this.activeSchedule = new ArrayList<PonderInstruction>();
        this.transform = new SceneTransform();
        this.basePlateSize = this.getBounds().method_35414();
        this.camera = new SceneCamera();
        this.baseWorldSection = new WorldSectionElementImpl();
        this.keyframeTimes = new IntArrayList(4);
        this.scaleFactor = 1.0f;
        this.yOffset = 0.0f;
        this.renderViewEntity = world != null ? new class_1531((class_1937)world, 0.0, 0.0, 0.0) : null;
        this.setPointOfInterest(new class_243(0.0, 4.0, 0.0));
    }

    public void deselect() {
        this.forEach(WorldSectionElement.class, WorldSectionElement::resetSelectedBlock);
    }

    public Pair<class_1799, class_2338> rayTraceScene(class_243 from, class_243 to) {
        MutableObject nearestHit = new MutableObject();
        MutableDouble bestDistance = new MutableDouble(0.0);
        this.forEach(WorldSectionElement.class, wse -> {
            wse.resetSelectedBlock();
            if (!wse.isVisible()) {
                return;
            }
            Pair<class_243, class_3965> rayTrace = wse.rayTrace(this.world, from, to);
            if (rayTrace == null) {
                return;
            }
            double distanceTo = rayTrace.getFirst().method_1022(from);
            if (nearestHit.getValue() != null && distanceTo >= bestDistance.getValue()) {
                return;
            }
            nearestHit.setValue(Pair.of(wse, rayTrace));
            bestDistance.setValue(distanceTo);
        });
        if (nearestHit.getValue() == null) {
            return Pair.of(class_1799.field_8037, class_2338.field_10980);
        }
        Pair selectedHit = (Pair)((Pair)nearestHit.getValue()).getSecond();
        class_2338 selectedPos = ((class_3965)selectedHit.getSecond()).method_17777();
        class_2338 origin = new class_2338(this.basePlateOffsetX, 0, this.basePlateOffsetZ);
        if (!this.world.getBounds().method_14662((class_2382)selectedPos)) {
            return Pair.of(class_1799.field_8037, null);
        }
        if (class_3341.method_34390((class_2382)origin, (class_2382)origin.method_10081(new class_2382(this.basePlateSize - 1, 0, this.basePlateSize - 1))).method_14662((class_2382)selectedPos)) {
            if (PonderIndex.editingModeActive()) {
                ((WorldSectionElement)((Pair)nearestHit.getValue()).getFirst()).selectBlock(selectedPos);
            }
            return Pair.of(class_1799.field_8037, selectedPos);
        }
        ((WorldSectionElement)((Pair)nearestHit.getValue()).getFirst()).selectBlock(selectedPos);
        class_2680 blockState = this.world.method_8320(selectedPos);
        class_1799 pickBlock = blockState.method_65171((class_4538)this.world, selectedPos, true);
        return Pair.of(pickBlock, selectedPos);
    }

    public void reset() {
        this.currentTime = 0;
        this.activeSchedule.clear();
        this.schedule.forEach((? super T mdi) -> mdi.reset(this));
    }

    public void begin() {
        this.reset();
        this.forEach(pe -> pe.reset(this));
        this.world.restore();
        this.elements.clear();
        this.linkedElements.clear();
        this.keyframeTimes.clear();
        this.transform = new SceneTransform();
        this.finished = false;
        this.setPointOfInterest(new class_243(0.0, 4.0, 0.0));
        this.baseWorldSection.setEmpty();
        this.baseWorldSection.forceApplyFade(1.0f);
        this.elements.add(this.baseWorldSection);
        this.totalTime = 0;
        this.stoppedCounting = false;
        this.activeSchedule.addAll(this.schedule);
        this.activeSchedule.forEach((? super T i) -> i.onScheduled(this));
    }

    public WorldSectionElement getBaseWorldSection() {
        return this.baseWorldSection;
    }

    public float getSceneProgress() {
        return this.totalTime == 0 ? 0.0f : (float)this.currentTime / (float)this.totalTime;
    }

    public void fadeOut() {
        this.reset();
        this.activeSchedule.add(new HideAllInstruction(10, null));
    }

    public void renderScene(SuperRenderTypeBuffer buffer, class_4587 ms, float pt) {
        ms.method_22903();
        class_310 mc = class_310.method_1551();
        class_1297 prevRVE = mc.field_1719;
        mc.field_1719 = this.renderViewEntity;
        this.forEachVisible(PonderSceneElement.class, e -> e.renderFirst(this.world, buffer, ms, pt));
        mc.field_1719 = prevRVE;
        for (class_11515 type : class_11515.values()) {
            this.forEachVisible(PonderSceneElement.class, e -> e.renderLayer(this.world, buffer, type, ms, pt));
        }
        this.forEachVisible(PonderSceneElement.class, e -> e.renderLast(this.world, buffer, ms, pt));
        this.camera.set(this.transform.xRotation.getValue(pt) + 90.0f, this.transform.yRotation.getValue(pt) + 180.0f);
        this.world.renderEntities(ms, buffer, this.camera, pt);
        this.world.renderParticles(ms, buffer, this.camera, pt);
        this.outliner.renderOutlines(mc, ms, buffer, class_243.field_1353, pt);
        ms.method_22909();
    }

    public void renderOverlay(PonderUI screen, class_332 graphics, float partialTicks) {
        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        this.forEachVisible(PonderOverlayElement.class, e -> e.render(this, screen, graphics, partialTicks));
        matrices.popMatrix();
    }

    public void setPointOfInterest(class_243 poi) {
        if (this.chasingPointOfInterest == null) {
            this.pointOfInterest = poi;
        }
        this.chasingPointOfInterest = poi;
    }

    public class_243 getPointOfInterest() {
        return this.pointOfInterest;
    }

    public void tick() {
        if (this.chasingPointOfInterest != null) {
            this.pointOfInterest = VecHelper.lerp(0.25f, this.pointOfInterest, this.chasingPointOfInterest);
        }
        this.outliner.tickOutlines();
        this.world.tick();
        this.transform.tick();
        this.forEach(e -> e.tick(this));
        if (this.currentTime < this.totalTime) {
            ++this.currentTime;
        }
        Iterator<PonderInstruction> iterator = this.activeSchedule.iterator();
        while (iterator.hasNext()) {
            PonderInstruction instruction = iterator.next();
            instruction.tick(this);
            if (instruction.isComplete()) {
                iterator.remove();
                if (!instruction.isBlocking()) continue;
                break;
            }
            if (!instruction.isBlocking()) continue;
            break;
        }
        if (this.activeSchedule.isEmpty()) {
            this.finished = true;
        }
    }

    public void seekToTime(int time) {
        if (time < this.currentTime) {
            throw new IllegalStateException("Cannot seek backwards. Rewind first.");
        }
        while (this.currentTime < time && !this.finished) {
            this.forEach(e -> e.whileSkipping(this));
            this.tick();
        }
        this.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
    }

    public void addToSceneTime(int time) {
        if (!this.stoppedCounting) {
            this.totalTime += time;
        }
    }

    public void stopCounting() {
        this.stoppedCounting = true;
    }

    public void markKeyframe(int offset) {
        if (!this.stoppedCounting) {
            this.keyframeTimes.add(this.totalTime + offset);
        }
    }

    public void addElement(PonderElement e) {
        this.elements.add(e);
    }

    public <E extends PonderElement> void linkElement(E e, ElementLink<E> link) {
        this.linkedElements.put(link.getId(), e);
    }

    @Nullable
    public <E extends PonderElement> E resolve(ElementLink<E> link) {
        return link.cast(this.linkedElements.get(link.getId()));
    }

    public <E extends PonderElement> Optional<E> resolveOptional(ElementLink<E> link) {
        return Optional.ofNullable(this.resolve(link));
    }

    public <E extends PonderElement> void runWith(ElementLink<E> link, Consumer<E> callback) {
        callback.accept(this.resolve(link));
    }

    public <E extends PonderElement, F> F applyTo(ElementLink<E> link, Function<E, F> function) {
        return function.apply(this.resolve(link));
    }

    public void forEach(Consumer<? super PonderElement> function) {
        for (PonderElement elemtent : this.elements) {
            function.accept(elemtent);
        }
    }

    public <T extends PonderElement> void forEach(Class<T> type, Consumer<T> function) {
        for (PonderElement element : this.elements) {
            if (!type.isInstance(element)) continue;
            function.accept((PonderElement)type.cast(element));
        }
    }

    public <T extends PonderElement> void forEachVisible(Class<T> type, Consumer<T> function) {
        for (PonderElement element : this.elements) {
            if (!type.isInstance(element) || !element.isVisible()) continue;
            function.accept((PonderElement)type.cast(element));
        }
    }

    public <T extends class_1297> void forEachWorldEntity(Class<T> type, Consumer<T> function) {
        for (class_1297 entity : this.world.getEntityList()) {
            if (!type.isInstance(entity)) continue;
            function.accept((class_1297)type.cast(entity));
        }
    }

    public Supplier<String> registerText(String defaultText) {
        String key = "text_" + this.textIndex;
        this.localization.registerSpecific(this.sceneId, key, defaultText);
        Supplier<String> supplier = () -> this.localization.getSpecific(this.sceneId, key);
        ++this.textIndex;
        return supplier;
    }

    public SceneBuilder builder() {
        return new PonderSceneBuilder(this);
    }

    public SceneBuildingUtil getSceneBuildingUtil() {
        return new PonderSceneBuildingUtil(this.getBounds());
    }

    public String getTitle() {
        return this.getString(TITLE_KEY);
    }

    public String getString(String key) {
        return this.localization.getSpecific(this.sceneId, key);
    }

    public PonderLevel getWorld() {
        return this.world;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getKeyframeCount() {
        return this.keyframeTimes.size();
    }

    public int getKeyframeTime(int index) {
        return this.keyframeTimes.getInt(index);
    }

    public List<PonderTag> getTags() {
        return this.tags;
    }

    public List<StoryBoardEntry.SceneOrderingEntry> getOrderingEntries() {
        return this.orderingEntries;
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public Set<PonderElement> getElements() {
        return this.elements;
    }

    public class_3341 getBounds() {
        return this.world == null ? new class_3341(class_2338.field_10980) : this.world.getBounds();
    }

    public class_2960 getId() {
        return this.sceneId;
    }

    public SceneTransform getTransform() {
        return this.transform;
    }

    public Outliner getOutliner() {
        return this.outliner;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getBasePlateOffsetX() {
        return this.basePlateOffsetX;
    }

    public int getBasePlateOffsetZ() {
        return this.basePlateOffsetZ;
    }

    public boolean shouldHidePlatformShadow() {
        return this.hidePlatformShadow;
    }

    public int getBasePlateSize() {
        return this.basePlateSize;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public void setNextUpEnabled(boolean nextUpEnabled) {
        this.nextUpEnabled = nextUpEnabled;
    }

    public boolean isNextUpEnabled() {
        return this.nextUpEnabled;
    }

    @Environment(value=EnvType.CLIENT)
    public class SceneTransform {
        public LerpedFloat xRotation = LerpedFloat.angular().disableSmartAngleChasing().startWithValue(-35.0);
        public LerpedFloat yRotation = LerpedFloat.angular().disableSmartAngleChasing().startWithValue(145.0);
        private int width;
        private int height;
        private double offset;
        private Matrix4f cachedMat;

        public void tick() {
            this.xRotation.tickChaser();
            this.yRotation.tickChaser();
        }

        public void updateScreenParams(int width, int height, double offset) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.cachedMat = null;
        }

        public class_4587 apply(class_4587 ms) {
            return this.apply(ms, AnimationTickHolder.getPartialTicks(PonderScene.this.world));
        }

        public class_4587 apply(class_4587 ms, float pt) {
            ms.method_22904((double)(this.width / 2), (double)(this.height / 2), 200.0 + this.offset);
            ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-35.0f));
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(55.0f));
            ms.method_22904(this.offset, 0.0, 0.0);
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-55.0f));
            ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(35.0f));
            ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(this.xRotation.getValue(pt)));
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(this.yRotation.getValue(pt)));
            UIRenderHelper.flipForGuiRender(ms);
            float f = 30.0f * PonderScene.this.scaleFactor;
            ms.method_22905(f, f, f);
            ms.method_46416((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetX, -1.0f + PonderScene.this.yOffset, (float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetZ);
            return ms;
        }

        public void updateSceneRVE(float pt) {
            class_243 v = this.screenToScene(this.width / 2, this.height / 2, 500, pt);
            if (PonderScene.this.renderViewEntity != null) {
                PonderScene.this.renderViewEntity.method_23327(v.field_1352, v.field_1351, v.field_1350);
            }
        }

        public class_243 screenToScene(double x, double y, int depth, float pt) {
            this.refreshMatrix(pt);
            class_243 vec = new class_243(x, y, (double)depth);
            vec = vec.method_1023((double)(this.width / 2), (double)(this.height / 2), 200.0 + this.offset);
            vec = VecHelper.rotate(vec, 35.0, class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, -55.0, class_2350.class_2351.field_11052);
            vec = vec.method_1023(this.offset, 0.0, 0.0);
            vec = VecHelper.rotate(vec, 55.0, class_2350.class_2351.field_11052);
            vec = VecHelper.rotate(vec, -35.0, class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, -this.xRotation.getValue(pt), class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, -this.yRotation.getValue(pt), class_2350.class_2351.field_11052);
            float f = 1.0f / (30.0f * PonderScene.this.scaleFactor);
            vec = vec.method_18805((double)f, (double)(-f), (double)f);
            vec = vec.method_1023((double)((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetX), (double)(-1.0f + PonderScene.this.yOffset), (double)((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetZ));
            return vec;
        }

        public class_241 sceneToScreen(class_243 vec, float pt) {
            this.refreshMatrix(pt);
            Vector4f vec4 = new Vector4f((float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350, 1.0f);
            vec4.mul((Matrix4fc)this.cachedMat);
            return new class_241(vec4.x(), vec4.y());
        }

        protected void refreshMatrix(float pt) {
            if (this.cachedMat != null) {
                return;
            }
            this.cachedMat = this.apply(new class_4587(), pt).method_23760().method_23761();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SceneCamera
    extends class_4184 {
        public void set(float xRotation, float yRotation) {
            this.method_19325(yRotation, xRotation);
        }
    }
}

