/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.api.goggles.IHaveHoveringInformation;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class KineticTooltipBehaviour<T extends KineticBlockEntity>
extends TooltipBehaviour<T>
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    public KineticTooltipBehaviour(T be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough;
        boolean bl = notFastEnough = !((KineticBlockEntity)this.blockEntity).isSpeedRequirementFulfilled() && ((KineticBlockEntity)this.blockEntity).getSpeed() != 0.0f;
        if (((KineticBlockEntity)this.blockEntity).isOverStressed() && ((Boolean)AllConfigs.client().enableOverstressedTooltip.get()).booleanValue()) {
            CreateLang.translate("gui.stressometer.overstressed", new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
            class_5250 hint = CreateLang.translateDirect("gui.contraptions.network_overstressed", new Object[0]);
            List<class_2561> cutString = TooltipHelper.cutTextComponent((class_2561)hint, FontHelper.Palette.GRAY_AND_WHITE);
            for (class_2561 component : cutString) {
                CreateLang.builder().add(component.method_27661()).forGoggles(tooltip);
            }
            return true;
        }
        if (notFastEnough) {
            CreateLang.translate("tooltip.speedRequirement", new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
            class_5250 hint = CreateLang.translateDirect("gui.contraptions.not_fast_enough", class_1074.method_4662((String)((KineticBlockEntity)this.blockEntity).method_11010().method_26204().method_63499(), (Object[])new Object[0]));
            List<class_2561> cutString = TooltipHelper.cutTextComponent((class_2561)hint, FontHelper.Palette.GRAY_AND_WHITE);
            for (class_2561 component : cutString) {
                CreateLang.builder().add(component.method_27661()).forGoggles(tooltip);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        float stressAtBase = ((KineticBlockEntity)this.blockEntity).calculateStressApplied();
        if (class_3532.method_15347((float)stressAtBase, (float)0.0f)) {
            return false;
        }
        CreateLang.translate("gui.goggles.kinetic_stats", new Object[0]).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, stressAtBase);
        return true;
    }

    protected void addStressImpactStats(List<class_2561> tooltip, float stressAtBase) {
        CreateLang.translate("tooltip.stressImpact", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float stressTotal = stressAtBase * Math.abs(((KineticBlockEntity)this.blockEntity).getTheoreticalSpeed());
        CreateLang.number(stressTotal).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(CreateLang.translate("gui.goggles.at_current_speed", new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
    }
}

