/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.symmetryWand;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10801;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SymmetryHandlerClient {
    private static int tickCounter = 0;

    public static void onRenderWorld(class_310 mc, class_4587 ms, class_4597 buffer, class_243 cameraPos) {
        class_746 player = mc.field_1724;
        class_1661 inventory = player.method_31548();
        int size = class_1661.method_7368();
        for (int i = 0; i < size; ++i) {
            SymmetryMirror mirror;
            class_1799 stackInSlot = inventory.method_5438(i);
            if (!stackInSlot.method_31574((class_1792)AllItems.WAND_OF_SYMMETRY) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
            class_2338 pos = class_2338.method_49638((class_2374)mirror.getPosition());
            double speed = 0.0625;
            float yShift = class_3532.method_15374((float)((float)((double)AnimationTickHolder.getRenderTime() * speed))) / 5.0f;
            ms.method_22903();
            ms.method_22904((double)pos.method_10263() - cameraPos.method_10216(), (double)pos.method_10264() - cameraPos.method_10214(), (double)pos.method_10260() - cameraPos.method_10215());
            ms.method_46416(0.0f, yShift + 0.2f, 0.0f);
            SymmetryHandlerClient.applyModelTransform(mirror, ms);
            class_10801 model = SymmetryHandlerClient.getModel(mirror).get();
            class_4588 builder = buffer.getBuffer(class_1921.method_23577());
            mc.method_1541().method_3350().method_3374((class_1920)mc.field_1687, List.of(model), class_2246.field_10124.method_9564(), pos, ms, builder, true, class_4608.field_21444);
            ms.method_22909();
        }
    }

    @Nullable
    public static PartialModel getModel(SymmetryMirror mirror) {
        SymmetryMirror symmetryMirror = mirror;
        Objects.requireNonNull(symmetryMirror);
        SymmetryMirror symmetryMirror2 = symmetryMirror;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlaneMirror.class, CrossPlaneMirror.class, TriplePlaneMirror.class}, (Object)symmetryMirror2, n)) {
            case 0 -> {
                PlaneMirror planeMirror = (PlaneMirror)symmetryMirror2;
                yield AllPartialModels.SYMMETRY_PLANE;
            }
            case 1 -> {
                CrossPlaneMirror crossPlaneMirror = (CrossPlaneMirror)symmetryMirror2;
                yield AllPartialModels.SYMMETRY_CROSSPLANE;
            }
            case 2 -> {
                TriplePlaneMirror triplePlaneMirror = (TriplePlaneMirror)symmetryMirror2;
                yield AllPartialModels.SYMMETRY_TRIPLEPLANE;
            }
            default -> throw new IllegalArgumentException("Unknown mirror type: " + mirror.getClass().getName());
        };
    }

    public static void applyModelTransform(SymmetryMirror mirror, class_4587 ms) {
        if (mirror instanceof PlaneMirror) {
            if (mirror.orientation != PlaneMirror.Align.XY) {
                ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).center()).rotateYDegrees(90.0f)).uncenter();
            }
        } else if (mirror instanceof CrossPlaneMirror && mirror.orientation != CrossPlaneMirror.Align.Y) {
            ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).center()).rotateYDegrees(45.0f)).uncenter();
        }
    }

    public static void onClientTick(class_310 mc) {
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        if (mc.method_1493()) {
            return;
        }
        class_746 player = mc.field_1724;
        if (++tickCounter % 10 == 0) {
            class_1661 inventory = player.method_31548();
            int size = class_1661.method_7368();
            for (int i = 0; i < size; ++i) {
                SymmetryMirror mirror;
                class_1799 stackInSlot = inventory.method_5438(i);
                if (!stackInSlot.method_31574((class_1792)AllItems.WAND_OF_SYMMETRY) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
                class_5819 random = mc.field_1687.field_9229;
                double offsetX = (random.method_43058() - 0.5) * 0.3;
                double offsetZ = (random.method_43058() - 0.5) * 0.3;
                class_243 pos = mirror.getPosition().method_1031(0.5 + offsetX, 0.25, 0.5 + offsetZ);
                class_243 speed = new class_243(0.0, random.method_43058() * 1.0 / 8.0, 0.0);
                world.method_8406((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
            }
        }
    }

    public static void drawEffect(class_310 client, class_2338 from, class_2338 to) {
        class_243 pos;
        class_5819 random = client.field_1687.field_9229;
        double density = 0.8f;
        class_243 start = class_243.method_24954((class_2382)from).method_1031(0.5, 0.5, 0.5);
        class_243 end = class_243.method_24954((class_2382)to).method_1031(0.5, 0.5, 0.5);
        class_243 diff = end.method_1020(start);
        class_243 step = diff.method_1029().method_1021(density);
        int steps = (int)(diff.method_1033() / step.method_1033());
        class_638 world = client.field_1687;
        for (int i = 3; i < steps - 1; ++i) {
            pos = start.method_1019(step.method_1021((double)i));
            class_243 speed = new class_243(0.0, random.method_43058() * -40.0, 0.0);
            world.method_8406((class_2394)new class_2390(65793, 1.0f), pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
        }
        class_243 speed = new class_243(0.0, random.method_43058() * 1.0 / 32.0, 0.0);
        pos = start.method_1019(step.method_1021(2.0));
        world.method_8406((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
        speed = new class_243(0.0, random.method_43058() * 1.0 / 32.0, 0.0);
        pos = start.method_1019(step.method_1021((double)steps));
        world.method_8406((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
    }
}

