/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.json;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import org.jetbrains.annotations.Nullable;

public enum ModelFormatVersion {
    V_1_12_0("1.12.0"),
    V_1_14_0("1.14.0"),
    V_1_21_0("1.21.0");

    private static final Supplier<Map<String, ModelFormatVersion>> LOOKUP;
    private final String serializedName;
    private final boolean supported;
    private final String errorMessage;

    private ModelFormatVersion(String serializedName) {
        this(serializedName, null);
    }

    private ModelFormatVersion(String serializedName, String errorMessage) {
        this.serializedName = serializedName;
        this.supported = errorMessage == null;
        this.errorMessage = errorMessage;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public static ModelFormatVersion match(String version) {
        return LOOKUP.get().get(version);
    }

    static {
        LOOKUP = Suppliers.memoize(() -> (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> {
            for (ModelFormatVersion formatVersion : ModelFormatVersion.values()) {
                map.put((Object)formatVersion.serializedName, (Object)formatVersion);
                map.put((Object)formatVersion.name(), (Object)formatVersion);
            }
        }));
    }
}

