/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.keyframe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Variable;

public record Keyframe<T extends MathValue>(double length, T startValue, T endValue, EasingType easingType, List<T> easingArgs) {
    public Keyframe(double length, T startValue, T endValue) {
        this(length, startValue, endValue, EasingType.LINEAR);
    }

    public Keyframe(double length, T startValue, T endValue, EasingType easingType) {
        this(length, startValue, endValue, easingType, (List<T>)new ObjectArrayList(0));
    }

    public Set<Variable> getUsedVariables() {
        ReferenceOpenHashSet usedVariables = new ReferenceOpenHashSet();
        if (this.startValue.isMutable()) {
            usedVariables.addAll(this.startValue.getUsedVariables());
        }
        if (this.endValue.isMutable()) {
            usedVariables.addAll(this.endValue.getUsedVariables());
        }
        for (MathValue easingArg : this.easingArgs) {
            if (!easingArg.isMutable()) continue;
            usedVariables.addAll(easingArg.getUsedVariables());
        }
        return usedVariables;
    }

    private static void findVariablesFromMathValue(MathValue mathValue, Set<Variable> variables) {
        if (!mathValue.isMutable()) {
            return;
        }
        variables.addAll(mathValue.getUsedVariables());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length, this.startValue, this.endValue, this.easingType, this.easingArgs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }
}

